<?php
ob_start();
include "layout.php";
require_once "db.php";

if (!in_array($role, ['admin', 'eventController'])) {
    die("Access denied.");
}

$pdo = get_db();
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id <= 0) {
    die("<div class='alert alert-danger'>Invalid Event ID.</div>");
}

// ---------- Handle Delete ----------
if (isset($_POST['delete_event']) && $_POST['delete_event'] == '1') {
    $pdo->prepare("DELETE FROM event_paragraphs WHERE event_id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM events WHERE id=?")->execute([$id]);

    header("Location: event_controller.php");
    exit;
}

// ---------- Fetch event ----------
$stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");
$stmt->execute([$id]);
$event = $stmt->fetch();

if (!$event) {
    die("<div class='alert alert-warning'>Event not found.</div>");
}

// ---------- Fetch paragraphs ----------
$pstmt = $pdo->prepare("SELECT * FROM event_paragraphs WHERE event_id = ?");
$pstmt->execute([$id]);
$paragraphs = $pstmt->fetchAll();

// ---------- Handle Update ----------
if ($_SERVER["REQUEST_METHOD"] === "POST" && ($_POST['delete_event'] == "0")) {

    $title = trim($_POST['title']);
    $subtitle = trim($_POST['subtitle']);
    $eventDate = $_POST['event_date'];
    $expiryDate = $_POST['expiry_date'];
    $capacity = (int)$_POST['capacity'];
    $basePrice = (float)$_POST['base_price'];
    $discount = (float)$_POST['discount'];

    // ✅ NEW FIELDS
    $link = trim($_POST['link'] ?? "");
    $description = trim($_POST['description'] ?? "");

    // ✅ Ticket Options 1..5
    $ticketoption1heading = trim($_POST['ticketoption1heading'] ?? "");
    $ticketoption1price   = (float)($_POST['ticketoption1price'] ?? 0);

    $ticketoption2heading = trim($_POST['ticketoption2heading'] ?? "");
    $ticketoption2price   = (float)($_POST['ticketoption2price'] ?? 0);

    $ticketoption3heading = trim($_POST['ticketoption3heading'] ?? "");
    $ticketoption3price   = (float)($_POST['ticketoption3price'] ?? 0);

    $ticketoption4heading = trim($_POST['ticketoption4heading'] ?? "");
    $ticketoption4price   = (float)($_POST['ticketoption4price'] ?? 0);

    $ticketoption5heading = trim($_POST['ticketoption5heading'] ?? "");
    $ticketoption5price   = (float)($_POST['ticketoption5price'] ?? 0);

    // ✅ Member Price Calculation
    $memberPrice = $basePrice - (($basePrice * $discount) / 100);

    // Handle image update
    $image = $event['image'];
    if (!empty($_FILES['image']['name'])) {
        $uploadDir = "uploads/events/";
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
        $filename = time() . "_" . basename($_FILES['image']['name']);
        $image = $uploadDir . $filename;
        move_uploaded_file($_FILES['image']['tmp_name'], $image);
    }

    // ✅ UPDATED QUERY — link + description + ticket options added
    $update = $pdo->prepare("
        UPDATE events SET 
            title=?, subtitle=?, event_date=?, expiry_date=?, image=?, 
            capacity=?, base_price=?, member_price=?, member_discount=?, 
            link=?, description=?,

            ticketoption1heading=?, ticketoption1price=?,
            ticketoption2heading=?, ticketoption2price=?,
            ticketoption3heading=?, ticketoption3price=?,
            ticketoption4heading=?, ticketoption4price=?,
            ticketoption5heading=?, ticketoption5price=?

        WHERE id=?
    ");

    $update->execute([
        $title, $subtitle, $eventDate, $expiryDate, $image,
        $capacity, $basePrice, $memberPrice, $discount,
        $link, $description,

        $ticketoption1heading, $ticketoption1price,
        $ticketoption2heading, $ticketoption2price,
        $ticketoption3heading, $ticketoption3price,
        $ticketoption4heading, $ticketoption4price,
        $ticketoption5heading, $ticketoption5price,

        $id
    ]);

    // ✅ Update paragraphs
    $pdo->prepare("DELETE FROM event_paragraphs WHERE event_id=?")->execute([$id]);
    if (!empty($_POST['paragraphs'])) {
        foreach ($_POST['paragraphs'] as $para) {
            if (trim($para) !== "") {
                $pdo->prepare("
                    INSERT INTO event_paragraphs (event_id, paragraph_text) 
                    VALUES (?, ?)
                ")->execute([$id, trim($para)]);
            }
        }
    }

    header("Location: edit_event.php?id=$id&status=success");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Edit Event</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body { background:#064635; color:white; padding:20px; font-family:sans-serif; }
.card { background:rgba(255,255,255,0.1); border:none; border-radius:15px; padding:25px; }
.form-control { background:rgba(255,255,255,0.9); color:black; border:none; }
.form-control:focus { box-shadow:0 0 5px #0b7b4c; }
.btn-success { background:#0b7b4c; border:none; }
.btn-outline-light { border-color:white; color:white; }
.btn-outline-light:hover { background:white; color:#064635; }
</style>
</head>

<body>
<div class="container-fluid" style="margin-top:50px;">
  <h3 class="mb-4"><i class="bi bi-pencil-square"></i> Edit Event</h3>

  <?php if(isset($_GET['status']) && $_GET['status'] == 'success'): ?>
  <script>
  Swal.fire({
    icon: 'success',
    title: 'Event Updated!',
    text: 'Your event has been successfully updated.',
    showConfirmButton: false,
    timer: 1800,
    background: '#e6ffee',
    color: '#064635'
  });
  </script>
  <?php endif; ?>

  <div class="card shadow-lg">
    <form method="POST" enctype="multipart/form-data" id="eventForm">

      <div class="row mb-3">
        <div class="col-md-6">
          <label>Event Title</label>
          <input type="text" name="title" class="form-control"
            value="<?= htmlspecialchars($event['title']) ?>" required>
        </div>
        <div class="col-md-6">
          <label>Event Location</label>
          <input type="text" name="subtitle" class="form-control"
            value="<?= htmlspecialchars($event['subtitle']) ?>">
        </div>
      </div>

      <div class="row mb-3">
        <div class="col-md-3">
          <label>Event Date</label>
          <input type="date" name="event_date" class="form-control"
            value="<?= htmlspecialchars($event['event_date']) ?>" required>
        </div>
        <div class="col-md-3">
          <label>Ticket Expiry</label>
          <input type="datetime-local" name="expiry_date" class="form-control"
            value="<?= date('Y-m-d\TH:i', strtotime($event['expiry_date'])) ?>" required>
        </div>
        <div class="col-md-2">
          <label>Capacity</label>
          <input type="number" name="capacity" class="form-control"
            value="<?= htmlspecialchars($event['capacity']) ?>" min="1" required>
        </div>
        <div class="col-md-2">
          <label>Base Price (CAD)</label>
          <input type="number" step="0.01" name="base_price" class="form-control"
            value="<?= htmlspecialchars($event['base_price']) ?>" required>
        </div>
        <div class="col-md-2">
          <label>Discount (%)</label>
          <input type="number" step="0.01" name="discount" class="form-control"
            value="<?= htmlspecialchars($event['member_discount']) ?>">
        </div>
      </div>

      <div class="row mb-3 align-items-center">
        <div class="col-md-3">
          <label>Current Image</label><br>
          <?php if($event['image']): ?>
            <img src="<?= $event['image'] ?>" width="120" height="90" style="object-fit:cover;border-radius:6px;">
          <?php else: ?>
            <p class="text-muted">No image uploaded</p>
          <?php endif; ?>
        </div>

        <div class="col-md-3">
          <label>Replace Image</label>
          <input type="file" name="image" accept="image/*" class="form-control">
        </div>
      </div>

      <!-- ✅ NEW LINK + DESCRIPTION -->
      <div class="row mb-3">
        <div class="col-md-6">
          <label>Event Link</label>
          <input type="text" name="link" class="form-control"
            value="<?= htmlspecialchars($event['link']) ?>"
            placeholder="https://example.com">
        </div>

        <div class="col-md-6">
          <label>Short Description</label>
          <input type="text" name="description" class="form-control"
            value="<?= htmlspecialchars($event['description']) ?>"
            placeholder="Event Location">
        </div>
      </div>

      <!-- ✅ TICKET OPTIONS 1..5 -->
      <div class="mt-4 mb-2">
        <h5 class="fw-bold"><i class="bi bi-ticket-perforated"></i> Extra Ticket Options</h5>
        <p class="text-light small mb-3">Fill heading + price. Leave empty if you don’t want to show it.</p>

        <?php for($i=1; $i<=5; $i++): ?>
          <div class="row mb-3">
            <div class="col-md-8">
              <label>Ticket Option <?= $i ?> Heading</label>
              <input type="text" class="form-control"
                name="ticketoption<?= $i ?>heading"
                value="<?= htmlspecialchars($event["ticketoption{$i}heading"] ?? "") ?>"
                placeholder="Example: VIP Ticket / Student Ticket">
            </div>
            <div class="col-md-4">
              <label>Ticket Option <?= $i ?> Price (CAD)</label>
              <input type="number" step="0.01" class="form-control"
                name="ticketoption<?= $i ?>price"
                value="<?= htmlspecialchars($event["ticketoption{$i}price"] ?? "0") ?>"
                min="0">
            </div>
          </div>
        <?php endfor; ?>
      </div>

      <!-- Paragraphs -->
      <div id="paragraphsContainer" class="mb-3">
        <label>Paragraphs</label>
        <?php if($paragraphs): ?>
          <?php foreach($paragraphs as $p): ?>
<textarea name="paragraphs[]" class="form-control mb-2" rows="2"><?= htmlspecialchars($p['paragraph_text']) ?></textarea>
          <?php endforeach; ?>
        <?php else: ?>
<textarea name="paragraphs[]" class="form-control mb-2" rows="2" placeholder="Add paragraph..."></textarea>
        <?php endif; ?>
      </div>

      <button type="button" class="btn btn-outline-light btn-sm mb-3" id="addParagraphBtn">
        <i class="bi bi-plus-circle"></i> Add Another Paragraph
      </button>

      <div class="text-end mt-3 d-flex justify-content-between">
        <button type="button" id="deleteBtn" class="btn btn-danger">
          <i class="bi bi-trash"></i> Delete Event
        </button>

        <div>
          <button class="btn btn-success px-4"><i class="bi bi-save"></i> Update Event</button>
          <a href="event_controller.php" class="btn btn-secondary">Back</a>
        </div>
      </div>

      <input type="hidden" name="delete_event" id="delete_event" value="0">
    </form>
  </div>
</div>

<script>
document.getElementById("addParagraphBtn").addEventListener("click", function() {
  const container = document.getElementById("paragraphsContainer");
  const textarea = document.createElement("textarea");
  textarea.name = "paragraphs[]";
  textarea.className = "form-control mb-2";
  textarea.rows = 2;
  textarea.placeholder = "Write another paragraph...";
  container.appendChild(textarea);
});

document.getElementById("deleteBtn").addEventListener("click", function() {
  Swal.fire({
    title: 'Delete this event?',
    text: "This action cannot be undone!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#d33',
    cancelButtonColor: '#3085d6',
    confirmButtonText: 'Yes, delete it!'
  }).then((result) => {
    if (result.isConfirmed) {
      document.getElementById("delete_event").value = "1";
      document.getElementById("eventForm").submit();
    }
  });
});
</script>

</body>
</html>
