<?php
ob_start();
include "layout.php";
require_once "db.php";

if (!in_array($role, ['admin', 'imamController'])) {
    die("Access denied.");
}

$pdo = get_db();

// ✅ Handle answer submission or update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['answer'])) {
    $stmt = $pdo->prepare("UPDATE imam_questions SET answer=?, status='answered', answered_at=NOW() WHERE id=?");
    $stmt->execute([$_POST['answer'], $_POST['id']]);
    echo "<div class='alert alert-success text-center mt-3'>✅ Answer saved successfully!</div>";
}

// ✅ Fetch all questions (Pending always on top)
$questions = $pdo->query("
    SELECT q.*, 
           COALESCE((SELECT COUNT(*) FROM imam_chat c WHERE c.question_id = q.id AND c.sender='user'),0) AS total_msgs,
           q.unread_count
    FROM imam_questions q
    ORDER BY 
      CASE WHEN q.status = 'answered' THEN 1 ELSE 0 END ASC,
      q.created_at DESC
")->fetchAll();
?>

<div class="container-fluid mt-5">
  <h3><i class="bi bi-gear-fill"></i> Imam Controller – Manage Questions</h3>

  <div class="card mt-3 p-3 shadow">
    <table class="table table-bordered table-striped align-middle text-center">
      <thead class="table-dark">
        <tr>
          <th>ID</th>
          <th>Full Name</th>
          <th>Contact</th>
          <th>Question</th>
          <th>Status</th>
          <th>Answer / Reply</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach ($questions as $q): ?>
        <tr>
          <td><?= $q['id'] ?></td>
          <td><?= htmlspecialchars($q['full_name']) ?></td>
          <td>
            <?= htmlspecialchars($q['email'] ?? '-') ?><br>
            <?= htmlspecialchars($q['phone'] ?? '-') ?>
          </td>
          <td><?= nl2br(htmlspecialchars($q['question'])) ?></td>
          <td>
            <?php if($q['status'] === 'answered'): ?>
              <span class="badge bg-success">Answered</span>
            <?php else: ?>
              <span class="badge bg-warning text-dark">Pending</span>
            <?php endif; ?>
          </td>
          <td>
            <?php if($q['answer']): ?>
              <div class="text-success"><?= nl2br(htmlspecialchars($q['answer'])) ?></div>
            <?php else: ?>
              <form method="post" class="d-flex flex-column">
                <input type="hidden" name="id" value="<?= $q['id'] ?>">
                <textarea name="answer" rows="3" class="form-control mb-2" required></textarea>
                <button class="btn btn-sm btn-primary"><i class="bi bi-send-fill"></i> Submit</button>
              </form>
            <?php endif; ?>
          </td>
          <td>
              <?php if ($q['answer']): ?>
                <!-- ✅ Edit + Chat buttons when answered -->
                <button class="btn btn-sm btn-warning"
                        onclick="openEditModal(<?= $q['id'] ?>, '<?= htmlspecialchars(addslashes($q['answer'])) ?>')">
                  <i class="bi bi-pencil-square"></i> Edit
                </button>
                <br>
                <a href="imam_chat.php?id=<?= $q['id'] ?>" class="btn btn-sm btn-success mt-2 position-relative">
                  <i class="bi bi-chat-dots-fill"></i> View Chat
                  <?php if ($q['unread_count'] > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                      <?= $q['unread_count'] ?>
                    </span>
                  <?php endif; ?>
                </a>
                <br>
                <small class="text-muted">Answered on <?= htmlspecialchars($q['answered_at']) ?></small>
              <?php else: ?>
                <!-- ✅ Chat button for pending -->
                <a href="imam_chat.php?id=<?= $q['id'] ?>" class="btn btn-sm btn-outline-primary position-relative">
                  <i class="bi bi-chat-dots-fill"></i> Open Chat
                  <?php if ($q['unread_count'] > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                      <?= $q['unread_count'] ?>
                    </span>
                  <?php endif; ?>
                </a>
                <br>
                <em>Awaiting reply</em>
              <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- ✅ Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header bg-success text-white">
          <h5 class="modal-title" id="editModalLabel"><i class="bi bi-pencil-square"></i> Edit Answer</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="editId">
          <textarea name="answer" id="editAnswer" class="form-control text-dark" rows="5" required></textarea>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="bi bi-x-circle"></i> Cancel</button>
          <button type="submit" class="btn btn-success"><i class="bi bi-save"></i> Update Answer</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- ✅ Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function openEditModal(id, answer) {
  document.getElementById('editId').value = id;
  document.getElementById('editAnswer').value = answer.replace(/\\n/g, "\n");
  var modal = new bootstrap.Modal(document.getElementById('editModal'));
  modal.show();
}
</script>
