<?php
// -------------------- CONFIG --------------------
$host     = "localhost";
$user     = "root";   // your DB username
$pass     = "";     // change to your DB password
$dbname   = "u290827053_iaos";   // your DB name
$csv_file = __DIR__ . "/ExportedPrayerTimesCsv664.csv"; // your CSV file path

// -------------------- CONNECT --------------------
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// -------------------- CREATE TABLE (if not exists) --------------------
$sql = "CREATE TABLE IF NOT EXISTS prayer_times (
    id INT AUTO_INCREMENT PRIMARY KEY,
    prayer_date DATE NOT NULL,
    fajar_begins TIME,
    fajar TIME,
    sunrise TIME,
    zuhar_begins TIME,
    zuhar TIME,
    asar_begins TIME,
    asar TIME,
    sunset TIME,
    magrib_begins TIME,
    isha_begins TIME,
    isha TIME,
    jumah1 TIME NULL,
    jumah2 TIME NULL,
    jumah3 TIME NULL,
    jumah4 TIME NULL
)";
if (!$conn->query($sql)) {
    die("Error creating table: " . $conn->error);
}

// -------------------- READ CSV --------------------
if (!file_exists($csv_file)) {
    die("CSV file not found: $csv_file");
}

$handle = fopen($csv_file, "r");
if ($handle === false) {
    die("Unable to open the CSV file.");
}

// Skip header row
fgetcsv($handle);

// -------------------- INSERT DATA --------------------
$conn->query("TRUNCATE TABLE prayer_times"); // clear old data

while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
    $stmt = $conn->prepare("INSERT INTO prayer_times 
        (prayer_date, fajar_begins, fajar, sunrise, zuhar_begins, zuhar, 
         asar_begins, asar, sunset, magrib_begins, isha_begins, isha,
         jumah1, jumah2, jumah3, jumah4)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param(
        "ssssssssssssssss",
        $data[0], // PrayerDate
        $data[1], // FajarBegins
        $data[2], // Fajar
        $data[3], // Sunrise
        $data[4], // ZuharBegins
        $data[5], // Zuhar
        $data[6], // AsarBegins
        $data[7], // Asar
        $data[8], // Sunset
        $data[9], // MagribBegins
        $data[10], // IshaBegins
        $data[11], // Isha
        $data[12], // Jumah1
        $data[13], // Jumah2
        $data[14], // Jumah3
        $data[15]  // Jumah4
    );

    if (!$stmt->execute()) {
        echo "Insert error on date {$data[0]}: " . $stmt->error . "\n";
    }
}
fclose($handle);

echo "✅ CSV import completed successfully!";
$conn->close();
?>
