<?php
ob_start();
session_start();
if (!isset($_SESSION['user_id'])) {
  header("Location: login.php");
  exit;
}
$role = $_SESSION['role'];
$username = $_SESSION['username'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>IAOS Control Panel</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link rel="icon" href="img/logo-white.png" type="image/x-icon">
<style>
body {background:#043b29;color:#fff;font-family:'Segoe UI',sans-serif;overflow-x:hidden;}
.navbar {background:#0b7b4c;}
.navbar-brand {color:white!important;font-weight:600;}
.sidebar {
  width:250px;position:fixed;top:0;bottom:0;left:0;background:#032a1e;
  padding-top:70px;z-index:1000;box-shadow:2px 0 10px rgba(0,0,0,0.3);
}
.sidebar a {
  color:#fff;text-decoration:none;display:block;padding:12px 20px;font-size:15px;border-left:3px solid transparent;
}
.sidebar a:hover, .sidebar a.active {
  background:#0b7b4c;border-left:3px solid #ffe45c;
}
.main {margin-left:250px;padding:30px;}
.card {
  background:rgba(255,255,255,0.08);
  border:none;border-radius:12px;
  box-shadow:0 4px 15px rgba(0,0,0,0.3);
}
.table thead {background:#0b7b4c;color:#fff;}
.table tbody tr td input {
  background:rgba(255,255,255,0.1);
  border:none;color:#fff;width:90px;text-align:center;
  border-radius:4px;
}
.quick-links .card {transition:transform .2s, box-shadow .2s;}
.quick-links .card:hover {transform:translateY(-5px);box-shadow:0 8px 20px rgba(0,0,0,0.4);}
.time-input {
  width:100%;min-width:100%;height:42px;border:1px solid #ddd;
  border-radius:6px;background-color:#f8f9fa;color:#000;
  font-weight:500;text-align:center;padding:5px 8px;box-sizing:border-box;
}
@media (max-width:1400px){.time-input{min-width:90px;font-size:14px;padding:3px 6px;}}
.time-input:focus {background-color:#fff;box-shadow:0 0 5px 2px #0b7b4c;outline:none;}
</style>
</head>
<body>

<!-- 🔝 Navbar -->
<nav class="navbar navbar-expand-lg fixed-top shadow">
  <div class="container-fluid">
    <span class="navbar-brand d-flex align-items-center">
  <img src="img/logo.png" alt="Logo" style="height:35px;width:auto;margin-right:10px;">
  IAOS Control Panel
</span>
    <span class="text-white">Welcome, <?= htmlspecialchars($username) ?> (<?= htmlspecialchars($role) ?>)</span>
    <a href="logout.php" class="btn btn-light btn-sm ms-2"><i class="bi bi-box-arrow-right"></i> Logout</a>
  </div>
</nav>

<!-- 📁 Sidebar -->
<div class="sidebar">
<?php if ($role === 'imamController'): ?>

  <!-- 👳 Imam Controller Only -->
  <a href="imam_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='imam_controller.php'?'active':'' ?>">
    <i class="bi bi-person-vcard-fill text-secondary"></i> Imam Controller
  </a>

<?php else: ?>

  <!-- 🌐 Full Menu for Admin and Others -->
  <a href="dashboard.php" class="<?= basename($_SERVER['PHP_SELF'])=='dashboard.php'?'active':'' ?>">
    <i class="bi bi-speedometer2"></i> Dashboard
  </a>

  <a href="edit_salah.php" class="<?= basename($_SERVER['PHP_SELF'])=='edit_salah.php'?'active':'' ?>">
    <i class="bi bi-moon-stars-fill"></i> Edit Salah
  </a>

  <?php if($role=='admin'): ?>
  <a href="user_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='user_controller.php'?'active':'' ?>">
     <i class="bi bi-person-lines-fill text-warning"></i> User Controller
  </a>
  <?php endif; ?>

  <a href="donation_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='donation_controller.php'?'active':'' ?>">
    <i class="bi bi-hand-thumbs-up-fill text-danger"></i> Donation Controller
  </a>

  <a href="event_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='event_controller.php'?'active':'' ?>">
    <i class="bi bi-calendar2-event-fill text-info"></i> Event Controller
  </a>

  <a href="members_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='members_controller.php'?'active':'' ?>">
    <i class="bi bi-people-fill text-primary"></i> Member Controller
  </a>

  <a href="finance_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='finance_controller.php'?'active':'' ?>">
    <i class="bi bi-currency-exchange text-success"></i> Finance Controller
  </a>

  <a href="services_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='services_controller.php'?'active':'' ?>">
    <i class="bi bi-tools text-warning"></i> Services Controller
  </a>

  <a href="imam_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='imam_controller.php'?'active':'' ?>">
    <i class="bi bi-person-vcard-fill text-secondary"></i> Imam Controller
  </a>

  <a href="education_controller.php" class="<?= basename($_SERVER['PHP_SELF'])=='education_controller.php'?'active':'' ?>">
    <i class="bi bi-mortarboard-fill text-primary"></i> Education Controller
  </a>

  <a href="student_registration.php" class="<?= basename($_SERVER['PHP_SELF'])=='student_registration.php'?'active':'' ?>">
    <i class="bi bi-person-lines-fill text-success"></i> Student Registration
  </a>

  <a href="web/admin_pannel/manage_menu.php">
    <i class="bi bi-brush-fill text-danger"></i> Website Editor
  </a>

<?php endif; ?>
</div>

<div class="main">
