<?php
session_start();
header_remove("X-Powered-By");

$con = mysqli_connect("localhost","iaosr874_newWeb","kkrNvZVT57-ru3~]","iaosr874_qrCode");
if (!$con) {
    die("DB Connection Failed!");
}

if (!isset($_SESSION['userEmail']) || $_SESSION['userEmail'] == '') {
    header("Location:index.php");
    exit;
}

$userEmail = $_SESSION['userEmail'];
$stmt = $con->prepare("SELECT userType FROM users WHERE userEmail=? LIMIT 1");
$stmt->bind_param("s", $userEmail);
$stmt->execute();
$stmt->bind_result($currentUser);
$stmt->fetch();
$stmt->close();

if (!($currentUser == "Admin" || $currentUser == "editor")) {
    header("Location:index.php");
    exit;
}

// Filters
$filterQrId = isset($_GET['qr_id']) ? (int)$_GET['qr_id'] : 0;
$dateFrom   = isset($_GET['from']) ? trim($_GET['from']) : '';
$dateTo     = isset($_GET['to']) ? trim($_GET['to']) : '';

function isValidDate($date) {
    return preg_match("/^\d{4}-\d{2}-\d{2}$/", $date);
}
if ($dateFrom && !isValidDate($dateFrom)) $dateFrom = '';
if ($dateTo && !isValidDate($dateTo)) $dateTo = '';

// Build query
$where  = " WHERE 1 ";
$params = [];
$types  = "";

if ($filterQrId > 0) {
    $where .= " AND qr_id = ? ";
    $params[] = $filterQrId;
    $types .= "i";
}

if ($dateFrom != '') {
    $where .= " AND datestimes >= ? ";
    $params[] = $dateFrom . " 00:00:00";
    $types .= "s";
}

if ($dateTo != '') {
    $where .= " AND datestimes <= ? ";
    $params[] = $dateTo . " 23:59:59";
    $types .= "s";
}

$sql = "
    SELECT 
        name,
        datestimes,
        country_code,
        device_type,
        os_name,
        browser_name,
        ip_address
    FROM hits
    $where
    ORDER BY datestimes DESC
";

$stmt = $con->prepare($sql);
if ($types !== "") {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// ==============================
// HTML FOR PDF
// ==============================
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { text-align:center; margin-bottom:20px; }
        table { width:100%; border-collapse: collapse; }
        th, td { border:1px solid #000; padding:6px; }
        th { background:#eee; }
    </style>
</head>
<body>
    <h2>Alaraby TV - QR Hits Report</h2>
    <table>
        <thead>
            <tr>
                <th>QR Name</th>
                <th>DateTime</th>
                <th>Country</th>
                <th>Device</th>
                <th>OS</th>
                <th>Browser</th>
                <th>IP</th>
            </tr>
        </thead>
        <tbody>
';

while ($row = $result->fetch_assoc()) {
    $html .= '<tr>
        <td>'.htmlspecialchars($row['name']).'</td>
        <td>'.htmlspecialchars($row['datestimes']).'</td>
        <td>'.htmlspecialchars($row['country_code']).'</td>
        <td>'.htmlspecialchars($row['device_type']).'</td>
        <td>'.htmlspecialchars($row['os_name']).'</td>
        <td>'.htmlspecialchars($row['browser_name']).'</td>
        <td>'.htmlspecialchars($row['ip_address']).'</td>
    </tr>';
}

$html .= '
        </tbody>
    </table>
</body>
</html>';

// ==============================
// DOMPDF EXPORT
// ==============================

// ✅ IMPORTANT: install dompdf using composer:
// composer require dompdf/dompdf

if (!file_exists(__DIR__ . "/vendor/autoload.php")) {
    echo "DOMPDF not installed. Please run: composer require dompdf/dompdf";
    exit;
}

require_once __DIR__ . "/vendor/autoload.php";

use Dompdf\Dompdf;
use Dompdf\Options;

$options = new Options();
$options->set("isRemoteEnabled", true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "landscape");
$dompdf->render();

$pdfName = "QR_Hits_" . date("Y-m-d_His") . ".pdf";
$dompdf->stream($pdfName, ["Attachment" => true]);

$stmt->close();
mysqli_close($con);
exit;
