<?php
ob_start();
include "layout.php";
require_once "db.php";

if ($role !== 'admin') { die("Access denied."); }

$pdo = get_db();

// ---------------- ADD NEW USER ----------------
$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'add') {
    $full_name = trim($_POST['full_name']);
    $username  = trim($_POST['username']);
    $email     = trim($_POST['email']);
    $password  = trim($_POST['password']);
    // ✅ Ensure imamController saves correctly and never blank
    $userRole  = isset($_POST['role']) && $_POST['role'] !== '' ? $_POST['role'] : 'imamController';

    try {
        $stmt = $pdo->prepare("INSERT INTO users (username, password, role, full_name, email, status)
                               VALUES (?, ?, ?, ?, ?, 'active')");
        $stmt->execute([$username, $password, $userRole, $full_name, $email]);
        $message = "✅ User created successfully!";
    } catch (PDOException $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}

// ---------------- UPDATE EXISTING USERS ----------------
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'update') {
    try {
        for ($i = 0; $i < count($_POST['id']); $i++) {
            $id        = $_POST['id'][$i];
            $full_name = $_POST['full_name'][$i];
            $username  = $_POST['username'][$i];
            $email     = $_POST['email'][$i];
            $password  = $_POST['password'][$i];
            // ✅ Prevent empty role overwriting
            $roleUser  = isset($_POST['role'][$i]) && $_POST['role'][$i] !== '' ? $_POST['role'][$i] : 'imamController';
            $status    = $_POST['status'][$i];

            $stmt = $pdo->prepare("UPDATE users 
                                   SET full_name=?, username=?, email=?, password=?, role=?, status=? 
                                   WHERE id=?");
            $stmt->execute([$full_name, $username, $email, $password, $roleUser, $status, $id]);
        }
        // ❌ Removed redirect that blanked page
        $message = "✅ Users updated successfully!";
    } catch (PDOException $e) {
        $message = "❌ Update failed: " . $e->getMessage();
    }
}

// ---------------- DELETE USER ----------------
if (isset($_POST['delete_user']) && is_numeric($_POST['delete_user'])) {
    $deleteId = (int)$_POST['delete_user'];
    $pdo->prepare("DELETE FROM users WHERE id=?")->execute([$deleteId]);
    $message = "🗑️ User deleted successfully!";
}

// ---------------- FETCH USERS ----------------
$stmt = $pdo->query("SELECT * FROM users ORDER BY id ASC");
$users = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Management</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body { background:#064635; color:white; padding:20px; font-family:sans-serif; }
.card { background:rgba(255,255,255,0.1); border:none; border-radius:15px; padding:20px; }
.form-control, .form-select { background:rgba(255,255,255,0.9); color:black; border:none; text-align:center; }
.form-control:focus { box-shadow:0 0 5px #0b7b4c; }
.btn-light { color:#064635; font-weight:600; }
.btn-warning { background:#f4c542; border:none; color:#064635; font-weight:600; }
.btn-danger { font-weight:600; }
</style>
</head>
<body>

<div class="container-fluid" style="margin-top:50px;">
  <h3 class="mb-4"><i class="bi bi-people"></i> User Management</h3>

  <?php if($message): ?>
    <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <!-- ADD NEW USER FORM -->
  <div class="card mb-4">
    <h5 class="text-white"><i class="bi bi-person-plus text-white"></i> Add New User</h5>
    <form method="POST">
      <input type="hidden" name="action" value="add">
      <div class="row mb-2">
        <div class="col-md-3">
          <label class="text-white">Full Name</label>
          <input type="text" class="form-control" name="full_name" required>
        </div>
        <div class="col-md-2">
          <label class="text-white">Username</label>
          <input type="text" class="form-control" name="username" required>
        </div>
        <div class="col-md-3">
          <label class="text-white">Email</label>
          <input type="email" class="form-control" name="email" required>
        </div>
        <div class="col-md-2">
          <label class="text-white">Password</label>
          <input type="text" class="form-control" name="password" required>
        </div>
        <div class="col-md-2">
          <label class="text-white">Role</label>
          <select name="role" class="form-select">
            <option value="admin">Admin</option>
            <option value="salahController">Salah Controller</option>
            <option value="eventController">Event Controller</option>
            <option value="financeController">Finance Controller</option>
            <option value="memberController">Member Controller</option>
            <option value="websiteEditor">Website Editor</option>
            <option value="donorController">Donor Controller</option>
            <option value="adsController">Ads Controller</option>
            <option value="imamController">Imam Controller</option>
          </select>
        </div>
      </div>
      <button class="btn btn-light w-100"><i class="bi bi-person-check"></i> Create User</button>
    </form>
  </div>

  <!-- EDIT USERS TABLE -->
  <div class="card p-3 shadow">
    <form method="POST" id="updateForm">
      <input type="hidden" name="action" value="update">
      <div class="table-responsive">
        <table class="table table-striped align-middle text-center">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>Full Name</th>
              <th>Username</th>
              <th>Email</th>
              <th>Password</th>
              <th>Role</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($users as $u): ?>
            <tr>
              <td><?= htmlspecialchars($u['id']) ?></td>
              <td class="text-dark"><input type="text" class="form-control text-dark" name="full_name[]" value="<?= htmlspecialchars($u['full_name']) ?>" style="width:100%"></td>
              <td class="text-dark"><input type="text" class="form-control text-dark" name="username[]" value="<?= htmlspecialchars($u['username']) ?>" style="width:100%"></td>
              <td class="text-dark"><input type="email" class="form-control text-dark" name="email[]" value="<?= htmlspecialchars($u['email']) ?>" style="width:100%"></td>
              <td class="text-dark"><input type="text" class="form-control text-dark" name="password[]" value="<?= htmlspecialchars($u['password']) ?>" style="width:100%"></td>
              <td>
                <select class="form-select" name="role[]">
                  <option value="admin" <?= $u['role']=='admin'?'selected':'' ?>>Admin</option>
                  <option value="salahController" <?= $u['role']=='salahController'?'selected':'' ?>>Salah Controller</option>
                  <option value="eventController" <?= $u['role']=='eventController'?'selected':'' ?>>Event Controller</option>
                  <option value="financeController" <?= $u['role']=='financeController'?'selected':'' ?>>Finance Controller</option>
                  <option value="memberController" <?= $u['role']=='memberController'?'selected':'' ?>>Member Controller</option>
                  <option value="websiteEditor" <?= $u['role']=='websiteEditor'?'selected':'' ?>>Website Editor</option>
                  <option value="donorController" <?= $u['role']=='donorController'?'selected':'' ?>>Donor Controller</option>
                  <option value="adsController" <?= $u['role']=='adsController'?'selected':'' ?>>Ads Controller</option>
                  <option value="imamController" <?= $u['role']=='imamController'?'selected':'' ?>>Imam Controller</option>
                </select>
              </td>
              <td>
                <select class="form-select" name="status[]">
                  <option value="active" <?= $u['status']=='active'?'selected':'' ?>>Active</option>
                  <option value="inactive" <?= $u['status']=='inactive'?'selected':'' ?>>Inactive</option>
                </select>
              </td>
              <td>
                <button type="button" class="btn btn-danger btn-sm delete-btn" data-id="<?= $u['id'] ?>" data-name="<?= htmlspecialchars($u['username']) ?>">
                  <i class="bi bi-trash"></i>
                </button>
              </td>
              <input type="hidden" name="id[]" value="<?= htmlspecialchars($u['id']) ?>">
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="text-end">
        <button class="btn btn-warning mt-3"><i class="bi bi-save"></i> Save Changes</button>
      </div>
    </form>
  </div>
</div>

<!-- Hidden Delete Form -->
<form method="POST" id="deleteForm" style="display:none;">
  <input type="hidden" name="delete_user" id="delete_user_id">
</form>

<script>
document.querySelectorAll(".delete-btn").forEach(btn => {
  btn.addEventListener("click", function() {
    const id = this.dataset.id;
    const name = this.dataset.name;
    Swal.fire({
      title: `Delete user "${name}"?`,
      text: "This action cannot be undone!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6",
      confirmButtonText: "Yes, delete it!",
      background: "#fff",
      color: "#064635"
    }).then((result) => {
      if (result.isConfirmed) {
        document.getElementById("delete_user_id").value = id;
        document.getElementById("deleteForm").submit();
      }
    });
  });
});
</script>

</body>
</html>
