<?php
ob_start();
require_once "db.php";  // ✅ your connection style

/* -------------------------------------------
   LOAD SETTINGS (REQUIRED)
------------------------------------------- */
$set = $pdo->query("SELECT * FROM iaos_imam_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

if (!$set) {
    die("❌ ERROR: Missing row id=1 in iaos_imam_settings.");
}

/* -------------------------------------------
   LOAD IMAM BIO
------------------------------------------- */
$bio = $pdo->query("SELECT * FROM iaos_imam_bio WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$bio) {
    die("❌ ERROR: Missing row id=1 in iaos_imam_bio.");
}

$paras = $pdo->query("SELECT * FROM iaos_imam_bio_paragraphs ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

/* -------------------------------------------
   ACTION HANDLER
------------------------------------------- */
$action = $_POST['action'] ?? '';

/* ✅ Save Page Header */
if ($action === "save_settings") {

    $title = $_POST['page_title'];
    $subtitle = $_POST['page_subtitle'];
    $bg = $set['bg_image'];

    if (!empty($_FILES['bg_image']['name'])) {
        $ext = strtolower(pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg','jpeg','png','webp'])) {
            $file = "uploads/" . time() . "_" . basename($_FILES['bg_image']['name']);
            move_uploaded_file($_FILES['bg_image']['tmp_name'], "../".$file);
            $bg = $file;
        }
    }

    $pdo->prepare("
        UPDATE iaos_imam_settings 
        SET page_title=?, page_subtitle=?, bg_image=? 
        WHERE id=1
    ")->execute([$title, $subtitle, $bg]);

    header("Location: admin_ask_imam.php?saved=1");
    exit;
}

/* ✅ Save Imam Bio (name, image, emails) */
if ($action === "save_bio") {

    $name = $_POST['imam_name'];
    $email1 = $_POST['appointment_email'];
    $email2 = $_POST['question_email'];

    $img = $bio['imam_image'];

    if (!empty($_FILES['imam_image']['name'])) {
        $ext = strtolower(pathinfo($_FILES['imam_image']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg','jpeg','png','webp'])) {
            $file = "uploads/" . time() . "_" . basename($_FILES['imam_image']['name']);
            move_uploaded_file($_FILES['imam_image']['tmp_name'], "../".$file);
            $img = $file;
        }
    }

    $pdo->prepare("
        UPDATE iaos_imam_bio 
        SET imam_name=?, imam_image=?, appointment_email=?, question_email=? 
        WHERE id=1
    ")->execute([$name, $img, $email1, $email2]);

    header("Location: admin_ask_imam.php?bio_saved=1");
    exit;
}

/* ✅ Add Paragraph */
if ($action === "add_para") {
    $pdo->prepare("INSERT INTO iaos_imam_bio_paragraphs (para_text) VALUES (?)")
        ->execute([$_POST['para_text']]);
    header("Location: admin_ask_imam.php#bio");
    exit;
}

/* ✅ Update Paragraph */
if ($action === "update_para") {
    $pdo->prepare("UPDATE iaos_imam_bio_paragraphs SET para_text=? WHERE id=?")
        ->execute([$_POST['para_text'], $_POST['id']]);
    header("Location: admin_ask_imam.php#bio");
    exit;
}

/* ✅ Delete Paragraph */
if ($action === "delete_para") {
    $pdo->prepare("DELETE FROM iaos_imam_bio_paragraphs WHERE id=?")
        ->execute([$_POST['id']]);
    header("Location: admin_ask_imam.php#bio");
    exit;
}

/* ✅ Update Question Status */
if ($action === "update_status") {

    $pdo->prepare("UPDATE imam_questions SET status=? WHERE id=?")
        ->execute([$_POST['status'], $_POST['question_id']]);

    header("Location: admin_ask_imam.php?updated=1#q".$_POST['question_id']);
    exit;
}

/* ✅ Delete Question */
if ($action === "delete_question") {

    $pdo->prepare("DELETE FROM imam_questions WHERE id=?")
        ->execute([$_POST['question_id']]);

    header("Location: admin_ask_imam.php?deleted=1");
    exit;
}

/* ✅ Add Reply */
if ($action === "add_reply") {

    $pdo->prepare("
        INSERT INTO imam_messages (question_id, sender, message) 
        VALUES (?, 'imam', ?)
    ")->execute([$_POST['question_id'], $_POST['message']]);

    $pdo->prepare("
        UPDATE imam_questions 
        SET status='answered' 
        WHERE id=? AND status='pending'
    ")->execute([$_POST['question_id']]);

    header("Location: admin_ask_imam.php?replied=1#q".$_POST['question_id']);
    exit;
}

/* -------------------------------------------
   LOAD QUESTIONS + MESSAGES
------------------------------------------- */
$statusFilter = $_GET['status'] ?? 'all';
$where = "";
$params = [];

if (in_array($statusFilter, ['pending','answered','closed'])) {
    $where = "WHERE status=?";
    $params[] = $statusFilter;
}

$stmt = $pdo->prepare("SELECT * FROM imam_questions $where ORDER BY created_at DESC");
$stmt->execute($params);
$questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* Messages */
$messagesByQ = [];
if ($questions) {
    $ids = array_column($questions, 'id');
    $in = implode(",", array_fill(0, count($ids), "?"));

    $msgStmt = $pdo->prepare("
        SELECT * FROM imam_messages 
        WHERE question_id IN ($in)
        ORDER BY created_at ASC
    ");
    $msgStmt->execute($ids);

    foreach ($msgStmt->fetchAll(PDO::FETCH_ASSOC) as $m) {
        $messagesByQ[$m['question_id']][] = $m;
    }
}

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Ask the Imam | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.message-box { background:#fff; border:1px solid #ddd; padding:12px; border-radius:8px; margin-bottom:8px; }
.msg-imam { background:#e9f7ec; border-color:#b7dfc2; }
pre { white-space:pre-wrap; margin:0; }
</style>
</head>

<body>
<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">
<h3 class="mb-4">🕌 Manage Ask the Imam</h3>

<?php
if(isset($_GET['saved'])) echo "<div class='alert alert-success'>✅ Header Saved.</div>";
if(isset($_GET['bio_saved'])) echo "<div class='alert alert-success'>✅ Imam Bio Saved.</div>";
if(isset($_GET['updated'])) echo "<div class='alert alert-success'>✅ Status Updated.</div>";
if(isset($_GET['deleted'])) echo "<div class='alert alert-danger'>❌ Deleted.</div>";
if(isset($_GET['replied'])) echo "<div class='alert alert-success'>📨 Reply Sent.</div>";
?>

<!-- ✅ PAGE HEADER SETTINGS -->
<div class="card p-4 mb-4">
  <h5 class="mb-3">🖼️ Page Header</h5>
  <form method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_settings">

    <label class="fw-bold">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-3" 
           value="<?= htmlspecialchars($set['page_title']) ?>">

    <label class="fw-bold">Page Subtitle</label>
    <textarea name="page_subtitle" class="form-control mb-3"><?= htmlspecialchars($set['page_subtitle']) ?></textarea>

    <label class="fw-bold">Header Image</label>
    <input type="file" name="bg_image" class="form-control mb-2">
    <img src="../<?= $set['bg_image'] ?>" style="max-width:200px;border-radius:8px">

    <button class="btn btn-primary mt-3">Save Header</button>
  </form>
</div>

<!-- ✅ IMAM BIO SECTION -->
<div class="card p-4 mb-4" id="bio">
  <h5 class="mb-3">👤 Imam Bio</h5>

  <form method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_bio">

    <label class="fw-bold">Imam Name</label>
    <input type="text" name="imam_name" class="form-control mb-3"
           value="<?= htmlspecialchars($bio['imam_name']) ?>">

    <label class="fw-bold">Imam Image</label>
    <input type="file" name="imam_image" class="form-control mb-2">
    <img src="../<?= $bio['imam_image'] ?>" width="150" class="rounded-circle mt-2">

    <label class="fw-bold mt-3">Appointment Email</label>
    <input type="text" name="appointment_email" class="form-control mb-3"
           value="<?= htmlspecialchars($bio['appointment_email']) ?>">

    <label class="fw-bold">Question Email</label>
    <input type="text" name="question_email" class="form-control mb-3"
           value="<?= htmlspecialchars($bio['question_email']) ?>">

    <button class="btn btn-primary">Save Bio</button>
  </form>
</div>

<!-- ✅ BIO PARAGRAPHS -->
<div class="card p-4 mb-4">
  <h5 class="mb-3">📄 Imam Biography Paragraphs</h5>

  <!-- Add new -->
  <form method="POST" class="mb-3">
    <input type="hidden" name="action" value="add_para">
    <textarea name="para_text" class="form-control mb-2" rows="3" placeholder="Write paragraph..." required></textarea>
    <button class="btn btn-secondary btn-sm">Add Paragraph</button>
  </form>

  <!-- List existing -->
  <?php foreach ($paras as $p): ?>
    <div class="border rounded p-3 mb-2 bg-white">
      <form method="POST" class="d-flex gap-2">
        <input type="hidden" name="action" value="update_para">
        <input type="hidden" name="id" value="<?= $p['id'] ?>">

        <textarea name="para_text" class="form-control" rows="2"><?= htmlspecialchars($p['para_text']) ?></textarea>

        <button class="btn btn-success btn-sm">Update</button>

        <button class="btn btn-danger btn-sm"
                onclick="return confirm('Delete paragraph?')"
                name="action" value="delete_para">
          Delete
        </button>
      </form>
    </div>
  <?php endforeach; ?>
</div>

<!-- ✅ QUESTION THREADS -->
<?php foreach ($questions as $q): ?>
<div id="q<?= $q['id'] ?>" class="card p-4 mb-4 shadow-sm">

  <div class="d-flex justify-content-between">
    <div>
      <h5><?= htmlspecialchars($q['full_name']) ?></h5>
      <small class="text-muted"><?= $q['created_at'] ?></small><br>
      <?php if($q['email']) echo "<small>Email: {$q['email']}</small><br>"; ?>
      <?php if($q['phone']) echo "<small>Phone: {$q['phone']}</small>"; ?>
    </div>

    <div>
      <!-- ✅ Update Status -->
      <form method="POST" class="d-inline">
        <input type="hidden" name="action" value="update_status">
        <input type="hidden" name="question_id" value="<?= $q['id'] ?>">

        <select name="status" class="form-select form-select-sm d-inline-block" style="width:140px;">
          <option value="pending"  <?= $q['status']=='pending'?'selected':'' ?>>Pending</option>
          <option value="answered" <?= $q['status']=='answered'?'selected':'' ?>>Answered</option>
          <option value="closed"   <?= $q['status']=='closed'?'selected':'' ?>>Closed</option>
        </select>

        <button class="btn btn-success btn-sm">Save</button>
      </form>

      <!-- ✅ Delete -->
      <form method="POST" class="d-inline" onsubmit="return confirm('Delete this question?');">
        <input type="hidden" name="action" value="delete_question">
        <input type="hidden" name="question_id" value="<?= $q['id'] ?>">
        <button class="btn btn-danger btn-sm">Delete</button>
      </form>
    </div>
  </div>

  <hr>

  <div class="message-box">
    <h6 class="fw-bold mb-2">Question:</h6>
    <pre><?= htmlspecialchars($q['question']) ?></pre>
  </div>

  <!-- ✅ THREAD -->
  <?php if (!empty($messagesByQ[$q['id']])): ?>
    <?php foreach ($messagesByQ[$q['id']] as $m): ?>
      <div class="message-box <?= $m['sender']=='imam'?'msg-imam':'' ?>">
        <div class="small text-muted mb-1">
            <?= $m['sender']=='imam'?'Imam':'User' ?> • <?= $m['created_at'] ?>
        </div>
        <pre><?= htmlspecialchars($m['message']) ?></pre>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

  <!-- ✅ REPLY -->
  <form method="POST" class="mt-3">
    <input type="hidden" name="action" value="add_reply">
    <input type="hidden" name="question_id" value="<?= $q['id'] ?>">

    <textarea name="message" rows="3" class="form-control mb-2" placeholder="Write reply..." required></textarea>
    <button class="btn btn-primary btn-sm">Send Reply</button>
  </form>

</div>
<?php endforeach; ?>

</div>
</div>

</body>
</html>
