<?php
ob_start();
require_once "db.php";

$settings = $pdo->query("SELECT * FROM converts_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

$sections = $pdo->query("SELECT * FROM converts_sections ORDER BY position")->fetchAll(PDO::FETCH_ASSOC);

$paraStmt = $pdo->query("SELECT * FROM converts_paragraphs ORDER BY position");
$paras = [];
foreach ($paraStmt as $p) {
    $paras[$p['section_id']][] = $p;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Converts Page | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; border-bottom:1px solid #2f343a; text-decoration:none; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; }
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3>🕌 Manage Converts Committee Page</h3>

<?php if(isset($_GET['saved'])): ?>
  <div class="alert alert-success">✅ Saved successfully</div>
<?php endif; ?>

<!-- ✅ PAGE HEADER SETTINGS -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Page Header</div>

  <form action="save_converts.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_header">

    <label class="fw-bold">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-2"
           value="<?= htmlspecialchars($settings['page_title']) ?>">

    <label class="fw-bold">Page Subtitle</label>
    <input type="text" name="page_subtitle" class="form-control mb-2"
           value="<?= htmlspecialchars($settings['page_subtitle']) ?>">

    <label class="fw-bold">Background Image</label>
    <input type="file" name="bg_image" class="form-control mb-2">

    <?php if(!empty($settings['bg_image'])): ?>
      <img src="../<?= $settings['bg_image'] ?>" style="max-width:220px;" class="rounded mt-2">
    <?php endif; ?>

    <button class="btn btn-primary mt-2">Save Header</button>
  </form>
</div>

<!-- ✅ ADD SECTION -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">➕ Add Section</div>

  <form action="save_converts.php" method="POST">
    <input type="hidden" name="action" value="add_section">

    <div class="row g-3">
      <div class="col-md-6">
        <label class="fw-bold">Section Title</label>
        <input type="text" name="section_title" class="form-control" required>
      </div>
      <div class="col-md-3">
        <label class="fw-bold">Style</label>
        <select name="style" class="form-select">
          <option value="default">Default</option>
          <option value="green">Green</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="fw-bold">Position</label>
        <input type="number" name="position" class="form-control" value="100">
      </div>
    </div>

    <button class="btn btn-success mt-3">Add Section</button>
  </form>
</div>

<!-- ✅ SECTION LIST -->
<?php foreach ($sections as $s): ?>
<div class="card p-4 shadow-sm mb-4 section-card">

  <div class="d-flex justify-content-between">
    <div>
      <div class="section-title"><?= htmlspecialchars($s['section_title']) ?></div>
      <span class="badge bg-secondary"><?= $s['style'] ?></span>
      <span class="badge bg-dark">pos: <?= $s['position'] ?></span>
    </div>

    <form action="save_converts.php" method="POST" onsubmit="return confirm('Delete this section?');">
      <input type="hidden" name="action" value="delete_section">
      <input type="hidden" name="id" value="<?= $s['id'] ?>">
      <button class="btn btn-danger btn-sm">Delete</button>
    </form>
  </div>

  <!-- ✅ ADD PARAGRAPH -->
  <form action="save_converts.php" method="POST" class="mt-3">
    <input type="hidden" name="action" value="add_para">
    <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

    <div class="row g-2">
      <div class="col-md-3">
        <label class="fw-bold">Type</label>
        <select name="type" class="form-select">
          <option value="heading">Heading</option>
          <option value="paragraph" selected>Paragraph</option>
          <option value="li">List Item</option>
          <option value="html">Raw HTML</option>
        </select>
      </div>

      <div class="col-md-3">
        <label class="fw-bold">Position</label>
        <input type="number" name="position" class="form-control" value="100">
      </div>
    </div>

    <label class="fw-bold mt-2">Text</label>
    <textarea name="para_text" class="form-control mb-2" rows="3"></textarea>

    <button class="btn btn-secondary btn-sm">Add Item</button>
  </form>

  <!-- ✅ LIST PARAGRAPHS -->
  <?php if (!empty($paras[$s['id']])): ?>
    <hr>
    <?php foreach ($paras[$s['id']] as $p): ?>
      <div class="bg-white border rounded p-3 mb-2">
        <form action="save_converts.php" method="POST">
          <input type="hidden" name="action" value="update_para">
          <input type="hidden" name="id" value="<?= $p['id'] ?>">

          <div class="row g-2">
            <div class="col-md-3">
              <label class="fw-bold">Type</label>
              <select name="type" class="form-select">
                <option value="heading" <?= $p['type']=='heading'?'selected':'' ?>>Heading</option>
                <option value="paragraph" <?= $p['type']=='paragraph'?'selected':'' ?>>Paragraph</option>
                <option value="li" <?= $p['type']=='li'?'selected':'' ?>>List Item</option>
                <option value="html" <?= $p['type']=='html'?'selected':'' ?>>Raw HTML</option>
              </select>
            </div>

            <div class="col-md-3">
              <label class="fw-bold">Position</label>
              <input type="number" name="position" class="form-control" value="<?= $p['position'] ?>">
            </div>
          </div>

          <label class="fw-bold mt-2">Text</label>
          <textarea name="para_text" class="form-control mb-2" rows="3"><?= htmlspecialchars($p['para_text']) ?></textarea>

          <button class="btn btn-success btn-sm">Update</button>

          <button formaction="save_converts.php" name="action" value="delete_para"
                  class="btn btn-danger btn-sm float-end"
                  onclick="return confirm('Delete?')">Delete</button>
        </form>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

</div>
<?php endforeach; ?>

</div>
</div>
</body>
</html>
