<?php
ob_start();
require_once "db.php";

/*****************************************************
 ✅ AUTO-CREATE TABLES (Fix missing table errors)
*****************************************************/
$pdo->exec("
CREATE TABLE IF NOT EXISTS iaos_funerals_settings (
    id INT PRIMARY KEY,
    page_title VARCHAR(255) NOT NULL,
    page_subtitle TEXT NOT NULL,
    bg_image VARCHAR(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

$pdo->exec("
CREATE TABLE IF NOT EXISTS iaos_funerals_sections (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    style ENUM('green','white') NOT NULL DEFAULT 'green',
    position INT NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

$pdo->exec("
CREATE TABLE IF NOT EXISTS iaos_funerals_paragraphs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    section_id INT NOT NULL,
    para_text TEXT NOT NULL,
    position INT NOT NULL DEFAULT 0,
    FOREIGN KEY (section_id) REFERENCES iaos_funerals_sections(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

/*****************************************************
 ✅ LOAD / INITIALIZE GLOBAL HEADER SETTINGS
*****************************************************/
$set = $pdo->query("SELECT * FROM iaos_funerals_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

if (!$set) {
    $pdo->prepare("
        INSERT INTO iaos_funerals_settings (id, page_title, page_subtitle, bg_image)
        VALUES (1, 'Funeral & Burial Services',
        '“…Verily, unto Allah do we belong and, verily, unto Him we shall return.” (Qur’an 2:156)',
        'images/banner4.jpg')
    ")->execute();

    $set = $pdo->query("SELECT * FROM iaos_funerals_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

/*****************************************************
 ✅ LOAD SECTIONS + PARAGRAPHS
*****************************************************/
$sections = $pdo->query("SELECT * FROM iaos_funerals_sections ORDER BY position ASC, id ASC")
                ->fetchAll(PDO::FETCH_ASSOC);

$parasBySection = [];

if ($sections) {
    $sectionIds = array_column($sections, 'id');
    $in = implode(',', array_fill(0, count($sectionIds), '?'));

    $stmt = $pdo->prepare("
        SELECT * FROM iaos_funerals_paragraphs
        WHERE section_id IN ($in)
        ORDER BY position ASC, id ASC
    ");
    $stmt->execute($sectionIds);

    foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $p) {
        $parasBySection[$p['section_id']][] = $p;
    }
}

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Funeral & Burial | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; margin-bottom:15px; }
.small-note { font-size:.875rem; color:#6c757d; }
.badge-pill { border-radius: 50rem; }
</style>
</head>

<body>
<div class="admin-wrapper">

  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">⚙️ Manage Funeral & Burial Page</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <!-- ✅ GLOBAL HEADER -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🖼️ Page Header (Global)</div>

      <form action="save_funerals.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="save_settings">

        <label class="fw-bold mb-1">Page Title</label>
        <input type="text" name="page_title" class="form-control mb-3"
               value="<?= htmlspecialchars($set['page_title']) ?>" required>

        <label class="fw-bold mb-1">Page Subtitle</label>
        <textarea name="page_subtitle" class="form-control mb-3" required><?= htmlspecialchars($set['page_subtitle']) ?></textarea>

        <label class="fw-bold mb-1">Header Background Image</label>
        <input type="file" name="bg_image" class="form-control mb-2" accept="image/*">
        <div class="small-note mb-2">If omitted, current background remains.</div>

        <?php if(!empty($set['bg_image'])): ?>
          <img src="../<?= htmlspecialchars($set['bg_image']) ?>" class="rounded"
               style="max-width:240px; object-fit:cover;">
        <?php endif; ?>

        <button class="btn btn-primary mt-3">Save Header</button>
      </form>
    </div>

    <!-- ✅ ADD NEW SECTION -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">➕ Add Section (Heading)</div>

      <form action="save_funerals.php" method="POST" class="row g-2">
        <input type="hidden" name="action" value="add_section">

        <div class="col-md-6">
          <label class="fw-bold mb-1">Section Title</label>
          <input type="text" name="title" class="form-control" placeholder="e.g., What Services Are Provided" required>
        </div>

        <div class="col-md-4">
          <label class="fw-bold mb-1">Style</label>
          <div class="d-flex align-items-center gap-3">

            <div class="form-check">
              <input class="form-check-input" type="radio" name="style" value="green" checked>
              <label class="form-check-label">Green (dark)</label>
            </div>

            <div class="form-check">
              <input class="form-check-input" type="radio" name="style" value="white">
              <label class="form-check-label">White (bg-light)</label>
            </div>

          </div>
        </div>

        <div class="col-md-2 d-flex align-items-end">
          <button class="btn btn-success w-100">Add</button>
        </div>
      </form>
    </div>

    <!-- ✅ SECTION LIST -->
    <?php foreach ($sections as $s): ?>
      <div class="card p-4 shadow-sm mb-4 section-card">

        <div class="d-flex justify-content-between align-items-center mb-3">

          <div>
            <div class="section-title mb-1">📘 <?= htmlspecialchars($s['title']) ?></div>

            <span class="badge bg-<?= $s['style']==='white' ? 'secondary' : 'success' ?> badge-pill">
              <?= $s['style']==='white' ? 'White (bg-light)' : 'Green (dark)' ?>
            </span>
          </div>

          <div class="d-flex gap-2">

            <!-- ✅ UPDATE SECTION -->
            <form action="save_funerals.php" method="POST" class="d-flex gap-2">
              <input type="hidden" name="action" value="update_section">
              <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

              <input type="text" name="title" class="form-control"
                     value="<?= htmlspecialchars($s['title']) ?>" required>

              <select name="style" class="form-select" style="max-width:180px">
                <option value="green" <?= $s['style']==='green'?'selected':'' ?>>Green (dark)</option>
                <option value="white" <?= $s['style']==='white'?'selected':'' ?>>White (bg-light)</option>
              </select>

              <button class="btn btn-success btn-sm">Update</button>
            </form>

            <!-- ✅ DELETE SECTION -->
            <form action="save_funerals.php" method="POST"
                  onsubmit="return confirm('Delete this section and all its paragraphs?');">

              <input type="hidden" name="action" value="delete_section">
              <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

              <button class="btn btn-danger btn-sm">Delete</button>
            </form>

          </div>
        </div>

        <!-- ✅ ADD PARAGRAPH -->
        <div class="bg-white border rounded p-3 mb-3">
          <div class="fw-bold mb-2">➕ Add Information Text</div>

          <form action="save_funerals.php" method="POST" class="d-grid gap-2">
            <input type="hidden" name="action" value="add_paragraph">
            <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

            <textarea name="para_text" class="form-control" rows="3"
                      placeholder="Write information text..." required></textarea>

            <button class="btn btn-secondary btn-sm" style="width:120px">Add Text</button>
          </form>
        </div>

        <!-- ✅ EXISTING PARAGRAPHS -->
        <?php foreach (($parasBySection[$s['id']] ?? []) as $p): ?>
          <div class="bg-white border rounded p-3 mb-2">

            <form action="save_funerals.php" method="POST" class="d-flex gap-2">
              <input type="hidden" name="action" value="update_paragraph">
              <input type="hidden" name="para_id" value="<?= $p['id'] ?>">

              <textarea name="para_text" class="form-control" rows="2" required><?= htmlspecialchars($p['para_text']) ?></textarea>

              <button class="btn btn-success btn-sm">Update</button>

              <button formaction="save_funerals.php" name="action" value="delete_paragraph"
                      onclick="return confirm('Delete this paragraph?')"
                      class="btn btn-danger btn-sm">Delete</button>
            </form>

          </div>
        <?php endforeach; ?>

      </div>
    <?php endforeach; ?>

  </div>
</div>
</body>
</html>
