<?php
ob_start();
require_once "db.php";

$settings = $pdo->query("SELECT * FROM marriage_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$sections = $pdo->query("SELECT * FROM marriage_sections ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras_stmt = $pdo->query("SELECT * FROM marriage_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($paras_stmt as $p) { $paras[$p['section_id']][] = $p; }

$officials = $pdo->query("SELECT * FROM marriage_officials ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Marriage & Nikkah | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }
.help { font-size:12px; color:#6c757d; }
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>
  <div class="admin-content">

    <h3 class="mb-4">⚙️ Manage Marriage & Nikkah Page</h3>
    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <!-- PAGE HEADER -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🖼️ Page Header</div>
      <form action="save_marriage.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="update_header">

        <label class="fw-bold mb-1">Page Title</label>
        <input type="text" name="page_title" class="form-control mb-2" value="<?= htmlspecialchars($settings['page_title']??'') ?>" required>

        <label class="fw-bold mb-1">Page Subtitle</label>
        <textarea name="page_subtitle" class="form-control mb-2" rows="3" required><?= htmlspecialchars($settings['page_subtitle']??'') ?></textarea>

        <label class="fw-bold mb-1">Background Image (stores as images/...; uploads to ../images)</label>
        <input type="file" name="bg_image" class="form-control mb-2" accept="image/*">
        <?php if (!empty($settings['bg_image'])): ?>
          <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" class="rounded mt-2" style="max-width:240px;object-fit:cover;">
        <?php endif; ?>

        <button class="btn btn-primary mt-2">Save Header</button>
      </form>
    </div>

    <!-- ADD SECTION -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">➕ Add New Heading</div>
      <form action="save_marriage.php" method="POST">
        <input type="hidden" name="action" value="add_section">

        <label class="fw-bold mb-1">Heading Title</label>
        <input type="text" name="section_title" class="form-control mb-2" required>

        <label class="fw-bold mb-1">Heading Style</label>
        <select name="style" class="form-control mb-2" required>
          <option value="green">Green (white text)</option>
          <option value="default">Plain</option>
        </select>
        <div class="help mb-2">Green headings will render with your “greet-title greet-title-in text-white” look.</div>

        <button class="btn btn-success">Add Heading</button>
      </form>
    </div>

    <!-- LIST SECTIONS -->
    <?php foreach ($sections as $s): ?>
      <div class="card p-4 shadow-sm mb-4 section-card">
        <div class="d-flex justify-content-between align-items-start mb-3">
          <div>
            <div class="section-title">📘 <?= htmlspecialchars($s['section_title']) ?></div>
            <div class="help">Style: <?= htmlspecialchars($s['style']) ?></div>
          </div>
          <div class="d-flex gap-2">
            <form action="save_marriage.php" method="POST" class="d-inline">
              <input type="hidden" name="action" value="update_section">
              <input type="hidden" name="id" value="<?= $s['id'] ?>">
              <div class="input-group">
                <input type="text" name="section_title" value="<?= htmlspecialchars($s['section_title']) ?>" class="form-control" placeholder="Heading">
                <select name="style" class="form-select">
                  <option value="green" <?= $s['style']=='green'?'selected':'' ?>>Green</option>
                  <option value="default" <?= $s['style']=='default'?'selected':'' ?>>Plain</option>
                </select>
                <button class="btn btn-success btn-sm">Save</button>
              </div>
            </form>
            <form action="save_marriage.php" method="POST" onsubmit="return confirm('Delete this heading and all its paragraphs?');">
              <input type="hidden" name="action" value="delete_section">
              <input type="hidden" name="id" value="<?= $s['id'] ?>">
              <button class="btn btn-danger btn-sm"><i class="bi bi-trash"></i></button>
            </form>
          </div>
        </div>

        <!-- Add paragraph under this heading -->
        <form action="save_marriage.php" method="POST" class="mb-3">
          <input type="hidden" name="action" value="add_para">
          <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

          <label class="fw-bold mb-1">Add Text</label>
          <textarea name="para_text" class="form-control mb-2" placeholder="Paragraph or list item..." required></textarea>

          <label class="fw-bold mb-1">Type</label>
          <select name="type" class="form-control mb-2">
            <option value="paragraph">Paragraph</option>
            <option value="li">List Item</option>
            <option value="html">Raw HTML Block</option>
          </select>

          <button class="btn btn-secondary btn-sm">Add</button>
        </form>

        <!-- List all paras -->
        <?php if (!empty($paras[$s['id']])): ?>
          <?php foreach ($paras[$s['id']] as $p): ?>
            <div class="bg-white border rounded p-3 mb-2">
              <form action="save_marriage.php" method="POST">
                <input type="hidden" name="action" value="update_para">
                <input type="hidden" name="id" value="<?= $p['id'] ?>">

                <label class="fw-bold mb-1">Type</label>
                <select name="type" class="form-control mb-2">
                  <option value="paragraph" <?= $p['type']=='paragraph'?'selected':'' ?>>Paragraph</option>
                  <option value="li" <?= $p['type']=='li'?'selected':'' ?>>List Item</option>
                  <option value="html" <?= $p['type']=='html'?'selected':'' ?>>Raw HTML</option>
                </select>

                <textarea name="para_text" class="form-control mb-2" rows="3" required><?= htmlspecialchars($p['para_text']) ?></textarea>

                <button class="btn btn-success btn-sm">Update</button>
                <button formaction="save_marriage.php" name="action" value="delete_para"
                        onclick="return confirm('Delete this item?')"
                        class="btn btn-danger btn-sm float-end">Delete</button>
              </form>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>

      </div>
    <?php endforeach; ?>

    <!-- OFFICIALS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">👥 Officials</div>

      <form action="save_marriage.php" method="POST" class="mb-3">
        <input type="hidden" name="action" value="add_official">
        <div class="row g-2">
          <div class="col-md-6">
            <input type="text" name="name" class="form-control" placeholder="Name" required>
          </div>
          <div class="col-md-6">
            <input type="text" name="phone" class="form-control" placeholder="Phone eg. (H): 306-585-0090">
          </div>
        </div>
        <button class="btn btn-success btn-sm mt-2">Add Official</button>
      </form>

      <?php foreach ($officials as $o): ?>
        <div class="bg-white border rounded p-3 mb-2">
          <form action="save_marriage.php" method="POST" class="row g-2">
            <input type="hidden" name="action" value="update_official">
            <input type="hidden" name="id" value="<?= $o['id'] ?>">
            <div class="col-md-5">
              <input type="text" name="name" value="<?= htmlspecialchars($o['name']) ?>" class="form-control">
            </div>
            <div class="col-md-5">
              <input type="text" name="phone" value="<?= htmlspecialchars($o['phone']) ?>" class="form-control">
            </div>
            <div class="col-md-2 d-flex gap-2">
              <button class="btn btn-success btn-sm w-100">Save</button>
              <button formaction="save_marriage.php" name="action" value="delete_official"
                      onclick="return confirm('Delete official?')"
                      class="btn btn-danger btn-sm w-100">Delete</button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>
    </div>

  </div>
</div>
</body>
</html>
