<?php
ob_start();
require_once "db.php";

/* UPDATE STATUS */
if (isset($_POST['update_status'])) {
    $stmt = $pdo->prepare("
        UPDATE iaos_rizq_applications 
        SET status=? 
        WHERE id=?
    ");
    $stmt->execute([
        $_POST['status'],
        (int)$_POST['id']
    ]);
    header("Location: admin_rizq_app.php?saved=1");
    exit;
}

/* DELETE APPLICATION */
if (isset($_POST['delete_app'])) {
    $stmt = $pdo->prepare("
        DELETE FROM iaos_rizq_applications 
        WHERE id=?
    ");
    $stmt->execute([ (int)$_POST['id'] ]);
    header("Location: admin_rizq_app.php?deleted=1");
    exit;
}

/* FETCH APPLICATIONS */
$apps = $pdo->query("
    SELECT * FROM iaos_rizq_applications
    ORDER BY id DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Rizq Applications | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
/* ===== EXACT SAME CSS AS REFERENCE ===== */
body { background:#f5f6fa; }

.admin-wrapper {
  display:flex;
  min-height:100vh;
}

.admin-sidebar {
  width:250px;
  background:#212529;
  color:#fff;
}

.admin-sidebar a {
  color:#ccc;
  padding:12px 20px;
  display:block;
  text-decoration:none;
  border-bottom:1px solid #2f343a;
}

.admin-sidebar a:hover,
.admin-sidebar a.active {
  background:#0d6efd;
  color:#fff;
}

.admin-content {
  flex-grow:1;
  padding:30px;
}

.section-card {
  border-radius:10px;
}

.section-title {
  font-weight:700;
  font-size:1.2rem;
  margin-bottom:12px;
}

/* STATUS BADGES */
.badge-pending { background:#6c757d; }
.badge-processing { background:#0dcaf0; }
.badge-approved { background:#198754; }
.badge-delivered { background:#fd7e14; }
</style>
</head>

<body>
<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">📋 Rizq Relief Applications</h3>

<?php if(isset($_GET['saved'])): ?>
  <div class="alert alert-success">✅ Status updated successfully</div>
<?php endif; ?>

<?php if(isset($_GET['deleted'])): ?>
  <div class="alert alert-danger">🗑 Application deleted</div>
<?php endif; ?>

<div class="card p-4 shadow-sm section-card">

<div class="section-title">Applications List</div>

<div class="table-responsive">
<table class="table table-bordered align-middle mb-0">

<thead class="table-dark text-center">
<tr>
  <th>ID</th>
  <th>Applicant</th>
  <th>Contact</th>
  <th>Family</th>
  <th>Status</th>
  <th>Documents</th>
  <th>Actions</th>
</tr>
</thead>

<tbody>

<?php if(empty($apps)): ?>
<tr>
  <td colspan="7" class="text-center text-muted py-4">
    No applications found.
  </td>
</tr>
<?php endif; ?>

<?php foreach ($apps as $a): ?>
<tr>

<td class="text-center fw-bold"><?= $a['id'] ?></td>

<td>
  <strong><?= htmlspecialchars($a['first_name'].' '.$a['last_name']) ?></strong><br>
  <small class="text-muted"><?= htmlspecialchars($a['city']) ?></small>
</td>

<td>
  📞 <?= htmlspecialchars($a['mobile_phone']) ?><br>
  ✉️ <?= htmlspecialchars($a['email']) ?><br><br>
  Additional Information:<br>
  
  <?= htmlspecialchars($a['additional_information']) ?>
</td>

<td class="text-center">
  👨 <?= (int)$a['adults_18_plus'] ?><br>
  👧 <?= (int)$a['children_12_17'] ?><br>
  👶 <?= (int)$a['children_0_11'] ?>
</td>

<td class="text-center">
  <span class="badge badge-<?= htmlspecialchars($a['status']) ?>">
    <?= ucfirst($a['status']) ?>
  </span>
</td>

<td class="text-center">
  <?php if($a['immigration_doc']): ?>
    <a href="../<?= $a['immigration_doc'] ?>" target="_blank">Immigration</a><br>
  <?php endif; ?>
  <?php if($a['bank_statement']): ?>
    <a href="../<?= $a['bank_statement'] ?>" target="_blank">Bank</a><br>
  <?php endif; ?>
  <?php if($a['rental_mortgage_doc']): ?>
    <a href="../<?= $a['rental_mortgage_doc'] ?>" target="_blank">Housing</a>
  <?php endif; ?>
</td>

<td style="min-width:160px">

<!-- UPDATE STATUS -->
<form method="POST" class="mb-2">
  <input type="hidden" name="id" value="<?= $a['id'] ?>">
  <select name="status" class="form-select form-select-sm mb-1">
    <option value="pending" <?= $a['status']=='pending'?'selected':'' ?>>Pending</option>
    <option value="processing" <?= $a['status']=='processing'?'selected':'' ?>>Processing</option>
    <option value="approved" <?= $a['status']=='approved'?'selected':'' ?>>Approved</option>
    <option value="delivered" <?= $a['status']=='delivered'?'selected':'' ?>>Delivered</option>
  </select>
  <button name="update_status" class="btn btn-success btn-sm w-100">
    Update
  </button>
</form>

<!-- DELETE -->
<form method="POST" onsubmit="return confirm('Delete this application?');">
  <input type="hidden" name="id" value="<?= $a['id'] ?>">
  <button name="delete_app" class="btn btn-danger btn-sm w-100">
    Delete
  </button>
</form>

</td>

</tr>
<?php endforeach; ?>

</tbody>
</table>
</div>

</div>

</div>
</div>
</body>
</html>
