<?php
ob_start();
require_once "db.php";

if(isset($_POST['save_heading'])){
    $heading = trim($_POST['heading_text']);
    $sub = trim($_POST['sub_text']);

    $pdo->prepare("UPDATE contact_heading SET heading_text=?, sub_text=? WHERE id=1")
        ->execute([$heading, $sub]);

    header("Location: manage_contact_heading.php?saved=1");
    exit;
}

$row = $pdo->query("SELECT heading_text, sub_text FROM contact_heading WHERE id=1")->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Contact Heading | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

    <h3 class="mb-4">📝 Manage Contact Page Heading</h3>

    <?php if(isset($_GET['saved'])): ?>
        <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <form method="POST" class="card p-4 shadow-sm" style="max-width:600px;">
        <label class="fw-bold mb-1">Heading Text</label>
        <input type="text" name="heading_text" class="form-control mb-3"
               value="<?= htmlspecialchars($row['heading_text']) ?>" required>

        <label class="fw-bold mb-1">Sub Text</label>
        <textarea name="sub_text" class="form-control mb-3" rows="3" required><?= htmlspecialchars($row['sub_text']) ?></textarea>

        <button name="save_heading" class="btn btn-primary">Save Changes</button>
    </form>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
