<?php
ob_start();
require_once "db.php";

// Update text/images
if ($_SERVER['REQUEST_METHOD']=='POST' && isset($_POST['sections'])) {
  foreach($_POST['sections'] as $k=>$v){
    $pdo->prepare("UPDATE footer_sections SET content=? WHERE section_key=?")->execute([$v,$k]);
  }
  foreach($_FILES as $k=>$f){
    if($f['error']==UPLOAD_ERR_OK){
      $name=basename($f['name']); move_uploaded_file($f['tmp_name'],"../images/$name");
      $pdo->prepare("UPDATE footer_sections SET content=? WHERE section_key=?")->execute(["images/$name",$k]);
    }
  }
  header("Location: manage_footer_full.php?saved=1");exit;
}

// Add / update / delete links
if(isset($_POST['add_link'])){
  $pdo->prepare("INSERT INTO footer_links(category,title,url,icon,position)VALUES(?,?,?,?,?)")
      ->execute([$_POST['category'],$_POST['title'],$_POST['url'],$_POST['icon'],$_POST['position']]);
  header("Location: manage_footer_full.php");exit;
}
if(isset($_POST['update_link'])){
  $pdo->prepare("UPDATE footer_links SET category=?,title=?,url=?,icon=?,position=? WHERE id=?")
      ->execute([$_POST['category'],$_POST['title'],$_POST['url'],$_POST['icon'],$_POST['position'],$_POST['id']]);
  header("Location: manage_footer_full.php?saved=1");exit;
}
if(isset($_GET['delete'])){
  $pdo->prepare("DELETE FROM footer_links WHERE id=?")->execute([$_GET['delete']]);
  header("Location: manage_footer_full.php");exit;
}

$sections=$pdo->query("SELECT * FROM footer_sections ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
$links=$pdo->query("SELECT * FROM footer_links ORDER BY category,position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Footer | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<style>
body {background:#f5f6fa;}
.admin-wrapper {display:flex;min-height:100vh;}
.admin-sidebar {width:250px;background:#212529;color:#fff;}
.admin-sidebar a {color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover {background:#0d6efd;color:#fff;}
.admin-content {flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">⚙️ Manage Full Footer</h3>
    <?php if(isset($_GET['saved'])): ?><div class="alert alert-success">✅ Saved!</div><?php endif;?>

    <!-- Footer texts/images -->
    <form method="POST" enctype="multipart/form-data" class="card p-4 mb-5">
      <h5>Footer Texts, Images & Links</h5>
      <div class="row g-3">
        <?php foreach($sections as $s): ?>
          <div class="col-md-6">
            <label class="form-label"><?= htmlspecialchars($s['label']) ?></label>
            <?php if($s['type']=='textarea'): ?>
              <textarea name="sections[<?= $s['section_key']?>]" class="form-control"><?= htmlspecialchars($s['content'])?></textarea>
            <?php elseif($s['type']=='image'): ?>
              <input type="file" name="<?= $s['section_key']?>" class="form-control mb-2">
              <?php if($s['content']): ?><img src="../<?= $s['content']?>" style="max-width:120px"><?php endif;?>
            <?php else: ?>
              <input type="<?= $s['type']=='link'?'url':'text'?>" name="sections[<?= $s['section_key']?>]" class="form-control" value="<?= htmlspecialchars($s['content'])?>">
            <?php endif;?>
          </div>
        <?php endforeach;?>
      </div>
      <button class="btn btn-primary mt-3">💾 Save</button>
    </form>

    <!-- Footer links -->
    <h5>Footer Links</h5>
    <form method="POST" class="card p-3 mb-4">
      <div class="row g-2">
        <div class="col-md-2"><select name="category" class="form-select"><option value="quick_links">Quick Links</option><option value="resources">Resources</option><option value="social">Social</option></select></div>
        <div class="col-md-3"><input name="title" class="form-control" placeholder="Title"></div>
        <div class="col-md-3"><input name="url" class="form-control" placeholder="URL"></div>
        <div class="col-md-2"><input name="icon" class="form-control" placeholder="Icon"></div>
        <div class="col-md-1"><input name="position" class="form-control" type="number" value="1"></div>
        <div class="col-md-1"><button name="add_link" class="btn btn-success w-100">Add</button></div>
      </div>
    </form>

    <table class="table table-bordered table-striped align-middle">
      <thead class="table-dark"><tr><th>ID</th><th>Category</th><th>Title</th><th>URL</th><th>Icon</th><th>Pos</th><th width="150">Action</th></tr></thead>
      <tbody>
        <?php foreach($links as $l): ?>
        <tr>
          <td><?= $l['id']?></td><td><?= ucfirst(str_replace('_',' ',$l['category']))?></td>
          <td><?= htmlspecialchars($l['title'])?></td><td><?= htmlspecialchars($l['url'])?></td>
          <td><?= htmlspecialchars($l['icon'])?></td><td><?= $l['position']?></td>
          <td>
            <button type="button" class="btn btn-sm btn-primary editLinkBtn"
              data-id="<?= $l['id']?>" data-category="<?= $l['category']?>" data-title="<?= htmlspecialchars($l['title'])?>"
              data-url="<?= htmlspecialchars($l['url'])?>" data-icon="<?= htmlspecialchars($l['icon'])?>" data-position="<?= $l['position']?>">Edit</button>
            <a href="?delete=<?= $l['id']?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this link?')">Del</a>
          </td>
        </tr>
        <?php endforeach;?>
      </tbody>
    </table>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editLinkModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header"><h5>Edit Footer Link</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body">
          <input type="hidden" name="id" id="editLinkId">
          <div class="mb-3"><label>Category</label><select name="category" id="editLinkCategory" class="form-select"><option value="quick_links">Quick Links</option><option value="resources">Resources</option><option value="social">Social</option></select></div>
          <div class="mb-3"><label>Title</label><input name="title" id="editLinkTitle" class="form-control"></div>
          <div class="mb-3"><label>URL</label><input name="url" id="editLinkURL" class="form-control"></div>
          <div class="mb-3"><label>Icon</label><input name="icon" id="editLinkIcon" class="form-control"></div>
          <div class="mb-3"><label>Position</label><input name="position" id="editLinkPosition" class="form-control" type="number"></div>
        </div>
        <div class="modal-footer"><button name="update_link" class="btn btn-primary">Save</button><button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button></div>
      </form>
    </div>
  </div>
</div>

<script>
document.querySelectorAll('.editLinkBtn').forEach(b=>{
 b.onclick=()=>{
  editLinkId.value=b.dataset.id;
  editLinkCategory.value=b.dataset.category;
  editLinkTitle.value=b.dataset.title;
  editLinkURL.value=b.dataset.url;
  editLinkIcon.value=b.dataset.icon;
  editLinkPosition.value=b.dataset.position;
  new bootstrap.Modal(editLinkModal).show();
 }
});
</script>
</body>
</html>
