<?php
ob_start();
require_once "db.php";

// ✅ Add mosque
if (isset($_POST['add'])) {
  $stmt = $pdo->prepare("INSERT INTO jummah_mosques (mosque_name, map_url, jummah_time) VALUES (?, ?, ?)");
  $stmt->execute([$_POST['mosque_name'], $_POST['map_url'], $_POST['jummah_time']]);
  header("Location: manage_jummah_mosques.php?saved=1");
  exit;
}

// ✅ Update mosque
if (isset($_POST['update'])) {
  $stmt = $pdo->prepare("
    UPDATE jummah_mosques 
    SET mosque_name=?, map_url=?, jummah_time=? 
    WHERE id=?
  ");
  $stmt->execute([
    $_POST['mosque_name'],
    $_POST['map_url'],
    $_POST['jummah_time'],
    $_POST['id']
  ]);
  header("Location: manage_jummah_mosques.php?saved=1");
  exit;
}

// ✅ Delete mosque
if (isset($_GET['delete'])) {
  $pdo->prepare("DELETE FROM jummah_mosques WHERE id=?")->execute([$_GET['delete']]);
  header("Location: manage_jummah_mosques.php");
  exit;
}

// ✅ Get list
$list = $pdo->query("SELECT * FROM jummah_mosques ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Jummah Mosque Timings | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">🕌 Manage Jummah Mosque Timings</h3>

    <?php if(isset($_GET['saved'])): ?>
    <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <!-- ✅ Add new mosque -->
    <form method="POST" class="card p-4 mb-4 shadow-sm">
      <div class="row g-2 align-items-center">

        <div class="col-md-4">
          <label class="form-label">Mosque Name</label>
          <input type="text" name="mosque_name" class="form-control" required>
        </div>

        <div class="col-md-4">
          <label class="form-label">Google Maps URL</label>
          <input type="text" name="map_url" class="form-control">
        </div>

        <div class="col-md-2">
          <label class="form-label">Jummah Time</label>
          <input type="text" name="jummah_time" class="form-control" placeholder="01:15 PM" required>
        </div>

        <div class="col-md-2 d-flex align-items-end">
          <button type="submit" name="add" class="btn btn-success w-100">Add</button>
        </div>
      </div>
    </form>

    <!-- ✅ List Table -->
    <table class="table table-bordered table-striped align-middle shadow-sm">
      <thead class="table-dark">
        <tr>
          <th>ID</th>
          <th>Mosque Name</th>
          <th>URL</th>
          <th>Jummah Time</th>
          <th width="150">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($list as $row): ?>
        <tr>
          <td><?= $row['id'] ?></td>
          <td><?= htmlspecialchars($row['mosque_name']) ?></td>
          <td><?= htmlspecialchars($row['map_url']) ?></td>
          <td><?= $row['jummah_time'] ?></td>
          <td>
            <button class="btn btn-sm btn-primary editBtn"
              data-id="<?= $row['id'] ?>"
              data-mosque="<?= htmlspecialchars($row['mosque_name']) ?>"
              data-url="<?= htmlspecialchars($row['map_url']) ?>"
              data-time="<?= $row['jummah_time'] ?>"
            >Edit</button>

            <a href="?delete=<?= $row['id'] ?>" 
               class="btn btn-sm btn-danger"
               onclick="return confirm('Delete this mosque?')">Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

  </div>
</div>

<!-- ✅ Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <form method="POST">
        <div class="modal-header">
          <h5 class="modal-title">Edit Mosque</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <input type="hidden" name="id" id="editId">

          <div class="mb-3">
            <label class="form-label">Mosque Name</label>
            <input type="text" name="mosque_name" id="editMosque" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Google Maps URL</label>
            <input type="text" name="map_url" id="editUrl" class="form-control">
          </div>

          <div class="mb-3">
            <label class="form-label">Jummah Time</label>
            <input type="text" name="jummah_time" id="editTime" class="form-control" required>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" name="update" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>

      </form>

    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.querySelectorAll('.editBtn').forEach(btn=>{
  btn.addEventListener('click', ()=>{
    document.getElementById('editId').value = btn.dataset.id;
    document.getElementById('editMosque').value = btn.dataset.mosque;
    document.getElementById('editUrl').value = btn.dataset.url;
    document.getElementById('editTime').value = btn.dataset.time;
    new bootstrap.Modal(document.getElementById('editModal')).show();
  });
});
</script>

</body>
</html>
