<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

/* =====================================================
   IMAGE UPLOADER
===================================================== */
function upload_image($field, $diskDir="../uploads", $publicPrefix="uploads") {
  if (empty($_FILES[$field]['name'])) return null;
  if (!is_dir($diskDir)) { @mkdir($diskDir, 0775, true); }

  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;

  $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$field]['name']);
  $fullPath = rtrim($diskDir, "/") . "/" . $filename;

  if (!move_uploaded_file($_FILES[$field]['tmp_name'], $fullPath)) return null;

  return rtrim($publicPrefix, "/") . "/" . $filename;
}

/* =====================================================
   GLOBAL SETTINGS
===================================================== */
if ($action === 'save_settings') {

  $title    = $_POST['page_title'] ?? '';
  $subtitle = $_POST['page_subtitle'] ?? '';

  $old_bg = $pdo->query("SELECT bg_image FROM iaos_careers_settings WHERE id=1")->fetchColumn();
  $bg = $old_bg ?: 'images/banner3.jpg';

  $new = upload_image('bg_image', '../uploads', 'uploads');
  if ($new) $bg = $new;

  $pdo->prepare("
      UPDATE iaos_careers_settings
      SET page_title=?, page_subtitle=?, bg_image=?
      WHERE id=1
    ")->execute([$title, $subtitle, $bg]);

  header("Location: admin_careers.php?saved=1");
  exit;
}

/* =====================================================
   JOBS
===================================================== */
if ($action === 'add_job') {

  $h        = $_POST['intro_heading'] ?? '';
  $txt      = $_POST['intro_text'] ?? '';
  $email    = $_POST['apply_email'] ?? '';
  $deadline = $_POST['apply_deadline'] ?? '';

  $pdo->prepare("
      INSERT INTO iaos_careers_jobs (intro_heading, intro_text, apply_email, apply_deadline, position)
      VALUES (?,?,?,?,?)
    ")->execute([$h, $txt, $email, $deadline, time()]);

  $newId = $pdo->lastInsertId();
  header("Location: admin_careers.php?id=$newId&saved=1");
  exit;
}

if ($action === 'save_job_intro') {

  $job_id   = (int)($_POST['job_id'] ?? 0);
  $h        = $_POST['intro_heading'] ?? '';
  $txt      = $_POST['intro_text'] ?? '';
  $email    = $_POST['apply_email'] ?? '';
  $deadline = $_POST['apply_deadline'] ?? '';

  $pdo->prepare("
      UPDATE iaos_careers_jobs
      SET intro_heading=?, intro_text=?, apply_email=?, apply_deadline=?
      WHERE id=?
    ")->execute([$h, $txt, $email, $deadline, $job_id]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

if ($action === 'delete_job') {

  $job_id = (int)($_POST['job_id'] ?? 0);

  $pdo->prepare("DELETE FROM iaos_careers_jobs WHERE id=?")->execute([$job_id]);

  header("Location: admin_careers.php?saved=1");
  exit;
}

/* =====================================================
   REQUIREMENTS
===================================================== */
if ($action === 'add_requirement') {

  $job_id = (int)($_POST['job_id'] ?? 0);
  $text   = $_POST['item_text'] ?? '';

  $pdo->prepare("
      INSERT INTO iaos_careers_requirements (job_id, item_text, position)
      VALUES (?,?,?)
    ")->execute([$job_id, $text, time()]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

if ($action === 'update_requirement') {

  $req_id = (int)($_POST['req_id'] ?? 0);
  $job_id = (int)($_POST['job_id'] ?? 0);
  $text   = $_POST['item_text'] ?? '';

  $pdo->prepare("
      UPDATE iaos_careers_requirements
      SET item_text=?
      WHERE id=?
    ")->execute([$text, $req_id]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

if ($action === 'delete_requirement') {

  $req_id = (int)($_POST['req_id'] ?? 0);
  $job_id = (int)($_POST['job_id'] ?? 0);

  $pdo->prepare("DELETE FROM iaos_careers_requirements WHERE id=?")->execute([$req_id]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

/* =====================================================
   HEADINGS
===================================================== */
if ($action === 'add_heading') {

  $job_id = (int)($_POST['job_id'] ?? 0);
  $text   = $_POST['heading_text'] ?? '';

  $pdo->prepare("
      INSERT INTO iaos_careers_headings (job_id, heading_text, position)
      VALUES (?,?,?)
    ")->execute([$job_id, $text, time()]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

if ($action === 'delete_heading') {

  $heading_id = (int)($_POST['heading_id'] ?? 0);
  $job_id     = (int)($_POST['job_id'] ?? 0);

  $pdo->prepare("DELETE FROM iaos_careers_headings WHERE id=?")->execute([$heading_id]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

/* =====================================================
   PARAGRAPHS
===================================================== */
if ($action === 'add_paragraph') {

  $job_id     = (int)($_POST['job_id'] ?? 0);
  $heading_id = (int)($_POST['heading_id'] ?? 0);
  $text       = $_POST['para_text'] ?? '';

  $pdo->prepare("
      INSERT INTO iaos_careers_paragraphs (job_id, heading_id, para_text, position)
      VALUES (?,?,?,?)
    ")->execute([$job_id, $heading_id, $text, time()]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

if ($action === 'update_paragraph') {

  $para_id = (int)($_POST['para_id'] ?? 0);
  $job_id  = (int)($_POST['job_id'] ?? 0);
  $text    = $_POST['para_text'] ?? '';

  $pdo->prepare("
      UPDATE iaos_careers_paragraphs
      SET para_text=?
      WHERE id=?
    ")->execute([$text, $para_id]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

if ($action === 'delete_paragraph') {

  $para_id = (int)($_POST['para_id'] ?? 0);
  $job_id  = (int)($_POST['job_id'] ?? 0);

  $pdo->prepare("DELETE FROM iaos_careers_paragraphs WHERE id=?")->execute([$para_id]);

  header("Location: admin_careers.php?id=$job_id&saved=1");
  exit;
}

/* fallback */
header("Location: admin_careers.php");
exit;
?>
