<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

function store_image($fileKey) {
  if (!empty($_FILES[$fileKey]['name'])) {
    $safe = time() . "_" . preg_replace('/[^A-Za-z0-9._-]/','_', $_FILES[$fileKey]['name']);
    $diskPath = "../images/" . $safe;     // physical
    $dbPath   = "images/" . $safe;        // stored path
    if (move_uploaded_file($_FILES[$fileKey]['tmp_name'], $diskPath)) {
      return $dbPath;
    }
  }
  return null;
}

/* HEADER */
if ($action === 'save_header') {
  $title = $_POST['page_title'] ?? '';
  $subtitle = $_POST['page_subtitle'] ?? '';

  $old = $GLOBALS['pdo']->query("SELECT bg_image FROM financial_page_settings WHERE id=1")->fetchColumn();
  $image = $old;

  $newImg = store_image('bg_image');
  if ($newImg) $image = $newImg;

  $stmt = $GLOBALS['pdo']->prepare("INSERT INTO financial_page_settings (id, page_title, page_subtitle, bg_image)
    VALUES (1,?,?,?) ON DUPLICATE KEY UPDATE page_title=VALUES(page_title), page_subtitle=VALUES(page_subtitle), bg_image=VALUES(bg_image)");
  $stmt->execute([$title, $subtitle, $image]);

  header("Location: admin_financial.php?saved=1");
  exit;
}

/* SECTIONS */
if ($action === 'add_section') {
  $stmt = $pdo->prepare("INSERT INTO financial_sections (section_title, style, position) VALUES (?,?,?)");
  $stmt->execute([$_POST['section_title'], $_POST['style'], (int)$_POST['position']]);
  header("Location: admin_financial.php?saved=1"); exit;
}
if ($action === 'delete_section') {
  $stmt = $pdo->prepare("DELETE FROM financial_sections WHERE id=?");
  $stmt->execute([ (int)$_POST['id'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}

/* PARAGRAPHS */
if ($action === 'add_para') {
  $stmt = $pdo->prepare("INSERT INTO financial_paragraphs (section_id, type, para_text, position) VALUES (?,?,?,?)");
  $stmt->execute([ (int)$_POST['section_id'], $_POST['type'], $_POST['para_text'], (int)$_POST['position'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}
if ($action === 'update_para') {
  $stmt = $pdo->prepare("UPDATE financial_paragraphs SET type=?, para_text=?, position=? WHERE id=?");
  $stmt->execute([ $_POST['type'], $_POST['para_text'], (int)$_POST['position'], (int)$_POST['id'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}
if ($action === 'delete_para') {
  $stmt = $pdo->prepare("DELETE FROM financial_paragraphs WHERE id=?");
  $stmt->execute([ (int)$_POST['id'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}

/* LIMITS */
if ($action === 'add_limit') {
  $stmt = $pdo->prepare("INSERT INTO financial_limits (need, max_limit, position) VALUES (?,?,?)");
  $stmt->execute([ $_POST['need'], $_POST['max_limit'], (int)$_POST['position'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}
if ($action === 'update_limit') {
  $stmt = $pdo->prepare("UPDATE financial_limits SET need=?, max_limit=?, position=? WHERE id=?");
  $stmt->execute([ $_POST['need'], $_POST['max_limit'], (int)$_POST['position'], (int)$_POST['id'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}
if ($action === 'delete_limit') {
  $stmt = $pdo->prepare("DELETE FROM financial_limits WHERE id=?");
  $stmt->execute([ (int)$_POST['id'] ]);
  header("Location: admin_financial.php?saved=1"); exit;
}

header("Location: admin_financial.php");
