<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

function upload_image($field, $diskDir="../uploads", $publicPrefix="uploads") {
  if (empty($_FILES[$field]['name'])) return null;
  if (!is_dir($diskDir)) { @mkdir($diskDir, 0775, true); }
  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;
  $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$field]['name']);
  $fullPath = rtrim($diskDir, "/") . "/" . $filename;
  if (!move_uploaded_file($_FILES[$field]['tmp_name'], $fullPath)) return null;
  return rtrim($publicPrefix, "/") . "/" . $filename; // no ../ in DB
}

/* ---------- SETTINGS ---------- */
if ($action === 'save_settings') {
  $title = $_POST['page_title'] ?? '';
  $subtitle = $_POST['page_subtitle'] ?? '';

  $old_bg = $pdo->query("SELECT bg_image FROM iaos_funerals_settings WHERE id=1")->fetchColumn();
  $bg = $old_bg ?: 'images/banner4.jpg';
  $new = upload_image('bg_image', '../uploads', 'uploads');
  if ($new) $bg = $new;

  $pdo->prepare("UPDATE iaos_funerals_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1")
      ->execute([$title, $subtitle, $bg]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

/* ---------- SECTIONS ---------- */
if ($action === 'add_section') {
  $title = $_POST['title'] ?? '';
  $style = $_POST['style'] ?? 'green';
  $pdo->prepare("INSERT INTO iaos_funerals_sections (title, style, position) VALUES (?,?,?)")
      ->execute([$title, $style, time()]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

if ($action === 'update_section') {
  $id = (int)($_POST['section_id'] ?? 0);
  $title = $_POST['title'] ?? '';
  $style = $_POST['style'] ?? 'green';
  $pdo->prepare("UPDATE iaos_funerals_sections SET title=?, style=? WHERE id=?")
      ->execute([$title, $style, $id]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

if ($action === 'delete_section') {
  $id = (int)($_POST['section_id'] ?? 0);
  $pdo->prepare("DELETE FROM iaos_funerals_sections WHERE id=?")->execute([$id]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

/* ---------- PARAGRAPHS ---------- */
if ($action === 'add_paragraph') {
  $section_id = (int)($_POST['section_id'] ?? 0);
  $txt = $_POST['para_text'] ?? '';
  // ensure FK exists
  $exists = $pdo->prepare("SELECT id FROM iaos_funerals_sections WHERE id=?");
  $exists->execute([$section_id]);
  if (!$exists->fetchColumn()) {
    header("Location: admin_funerals.php?saved=0"); exit;
  }
  $pdo->prepare("INSERT INTO iaos_funerals_paragraphs (section_id, para_text, position) VALUES (?,?,?)")
      ->execute([$section_id, $txt, time()]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

if ($action === 'update_paragraph') {
  $para_id = (int)($_POST['para_id'] ?? 0);
  $txt = $_POST['para_text'] ?? '';
  $pdo->prepare("UPDATE iaos_funerals_paragraphs SET para_text=? WHERE id=?")
      ->execute([$txt, $para_id]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

if ($action === 'delete_paragraph') {
  $para_id = (int)($_POST['para_id'] ?? 0);
  $pdo->prepare("DELETE FROM iaos_funerals_paragraphs WHERE id=?")->execute([$para_id]);
  header("Location: admin_funerals.php?saved=1"); exit;
}

/* fallback */
header("Location: admin_funerals.php");
