<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

/* Upload Helper */
function upload_image($field, $dir="../uploads", $public="uploads") {
  if (empty($_FILES[$field]['name'])) return null;
  if (!is_dir($dir)) mkdir($dir,0775,true);

  $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
  if (!in_array($ext,['jpg','jpeg','png','webp'])) return null;

  $name = time() . "_" . preg_replace("/[^a-zA-Z0-9\._-]/","_",$_FILES[$field]['name']);
  $path = "$dir/$name";
  move_uploaded_file($_FILES[$field]['tmp_name'], $path);

  return "$public/$name";
}

/* ---------- SAVE GLOBAL SETTINGS ---------- */
if ($action === 'save_settings') {
  $title    = $_POST['page_title'];
  $subtitle = $_POST['page_subtitle'];

  $old = $pdo->query("SELECT bg_image FROM iaos_news_settings WHERE id=1")->fetchColumn();
  $bg  = $old;
  $new = upload_image("bg_image", "../uploads", "uploads");

  if ($new) $bg = $new;

  $pdo->prepare("UPDATE iaos_news_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1")
      ->execute([$title,$subtitle,$bg]);

  header("Location: admin_news.php?saved=1"); exit;
}

/* ---------- ADD POST ---------- */
if ($action === 'add_post') {
  $h = $_POST['intro_heading'];
  $t = $_POST['intro_text'];
  $d = $_POST['publish_date'];

  $pdo->prepare("INSERT INTO iaos_news_posts (intro_heading,intro_text,publish_date,position)
                 VALUES (?,?,?,?)")->execute([$h,$t,$d,time()]);

  $id = $pdo->lastInsertId();
  header("Location: admin_news.php?id=$id&saved=1"); exit;
}

/* ---------- UPDATE POST ---------- */
if ($action === 'save_post_intro') {
  $id = $_POST['post_id'];
  $h = $_POST['intro_heading'];
  $t = $_POST['intro_text'];
  $d = $_POST['publish_date'];

  $pdo->prepare("UPDATE iaos_news_posts
                 SET intro_heading=?, intro_text=?, publish_date=? WHERE id=?")
      ->execute([$h,$t,$d,$id]);

  header("Location: admin_news.php?id=$id&saved=1"); exit;
}

/* ---------- DELETE POST ---------- */
if ($action === 'delete_post') {
  $id = $_POST['post_id'];
  $pdo->prepare("DELETE FROM iaos_news_posts WHERE id=?")->execute([$id]);
  header("Location: admin_news.php?saved=1"); exit;
}

/* ---------- ADD PARAGRAPH ---------- */
if ($action === 'add_paragraph') {
  $postId = $_POST['post_id'];
  $txt = $_POST['para_text'];

  $pdo->prepare("INSERT INTO iaos_news_paragraphs (post_id,para_text,position)
                 VALUES (?,?,?)")->execute([$postId,$txt,time()]);

  header("Location: admin_news.php?id=$postId&saved=1"); exit;
}

/* ---------- UPDATE PARAGRAPH ---------- */
if ($action === 'update_paragraph') {
  $paraId = $_POST['para_id'];
  $postId = $_POST['post_id'];
  $txt = $_POST['para_text'];

  $pdo->prepare("UPDATE iaos_news_paragraphs SET para_text=? WHERE id=?")
      ->execute([$txt,$paraId]);

  header("Location: admin_news.php?id=$postId&saved=1"); exit;
}

/* ---------- DELETE PARAGRAPH ---------- */
if ($action === 'delete_paragraph') {
  $paraId = $_POST['para_id'];
  $postId = $_POST['post_id'];

  $pdo->prepare("DELETE FROM iaos_news_paragraphs WHERE id=?")->execute([$paraId]);

  header("Location: admin_news.php?id=$postId&saved=1"); exit;
}

/* fallback */
header("Location: admin_news.php");
