<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

/* --------------------- HELPERS --------------------- */
function upload_pdf($field, $dir = "../uploads/policies") {
    if (empty($_FILES[$field]['name'])) return null;

    if (!is_dir($dir)) { @mkdir($dir, 0775, true); }

    $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
    if ($ext !== 'pdf') return null;

    $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$field]['name']);
    $full = "$dir/$filename";

    move_uploaded_file($_FILES[$field]['tmp_name'], $full);

    return $filename; // store only file_name in DB
}

function upload_image($field, $dir = "../uploads") {
    if (empty($_FILES[$field]['name'])) return null;

    // Ensure upload folder exists
    if (!is_dir($dir)) { @mkdir($dir, 0775, true); }

    // Validate extension
    $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;

    // Clean + generate unique filename
    $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$field]['name']);

    // Full path for saving
    $full_path = "$dir/$filename";

    // Move file to uploads
    move_uploaded_file($_FILES[$field]['tmp_name'], $full_path);

    // ✅ SAVE ONLY FILENAME IN DB
    return $filename;
}


/* --------------------- SETTINGS --------------------- */
if ($action === "save_settings") {
    $title = $_POST['page_title'] ?? '';
    $subtitle = $_POST['page_subtitle'] ?? '';

    $old = $pdo->query("SELECT bg_image FROM iaos_policies_settings WHERE id=1")->fetchColumn();
    $bg = $old ?: "images/banner4.jpg";

    $newbg = upload_image("bg_image");
    if ($newbg) $bg = $newbg;

    $pdo->prepare("UPDATE iaos_policies_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1")
        ->execute([$title, $subtitle, $bg]);

    header("Location: admin_policies.php?saved=1");
    exit;
}


/* --------------------- ABOUT HEADING --------------------- */
if ($action === "save_about_heading") {
    $txt = $_POST['about_heading'] ?? "";
    $pdo->prepare("UPDATE iaos_policies_settings SET about_heading=? WHERE id=1")
        ->execute([$txt]);

    header("Location: admin_policies.php?saved=1");
    exit;
}


/* --------------------- ABOUT PARAGRAPHS --------------------- */
if ($action === "add_about_paragraph") {
    $txt = $_POST['para_text'] ?? '';
    $pdo->prepare("INSERT INTO iaos_policies_about_paragraphs (para_text, position) VALUES (?, ?)")
        ->execute([$txt, time()]);

    header("Location: admin_policies.php?saved=1");
    exit;
}

if ($action === "update_about_paragraph") {
    $id = (int)($_POST['id']);
    $txt = $_POST['para_text'] ?? "";

    $pdo->prepare("UPDATE iaos_policies_about_paragraphs SET para_text=? WHERE id=?")
        ->execute([$txt, $id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}

if ($action === "delete_about_paragraph") {
    $id = (int)($_POST['id']);

    $pdo->prepare("DELETE FROM iaos_policies_about_paragraphs WHERE id=?")
        ->execute([$id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}


/* --------------------- ADD HEADING --------------------- */
if ($action === "add_heading") {
    $txt = $_POST['heading_text'] ?? '';

    $pdo->prepare("INSERT INTO iaos_policies_headings (heading_text, position) VALUES (?, ?)")
        ->execute([$txt, time()]);

    header("Location: admin_policies.php?saved=1");
    exit;
}


/* --------------------- DELETE HEADING --------------------- */
if ($action === "delete_heading") {
    $id = (int)($_POST['id']);

    $pdo->prepare("DELETE FROM iaos_policies_paragraphs WHERE heading_id=?")->execute([$id]);
    $pdo->prepare("DELETE FROM iaos_policies_headings WHERE id=?")->execute([$id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}


/* --------------------- PARAGRAPHS --------------------- */
if ($action === "add_paragraph") {
    $hid = (int)($_POST['heading_id']);
    $txt = $_POST['para_text'] ?? '';

    $pdo->prepare("INSERT INTO iaos_policies_paragraphs (heading_id, para_text, position) VALUES (?, ?, ?)")
        ->execute([$hid, $txt, time()]);

    header("Location: admin_policies.php?saved=1");
    exit;
}

if ($action === "update_paragraph") {
    $id = (int)$_POST['id'];
    $txt = $_POST['para_text'] ?? '';

    $pdo->prepare("UPDATE iaos_policies_paragraphs SET para_text=? WHERE id=?")
        ->execute([$txt, $id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}

if ($action === "delete_paragraph") {
    $id = (int)$_POST['id'];

    $pdo->prepare("DELETE FROM iaos_policies_paragraphs WHERE id=?")
        ->execute([$id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}


/* --------------------- FILES --------------------- */
if ($action === "add_file") {
    $title = $_POST['file_title'] ?? '';

    $filename = upload_pdf("file_pdf");

    if ($filename) {
        $pdo->prepare("INSERT INTO iaos_policies_files (file_title, file_name, position) VALUES (?, ?, ?)")
            ->execute([$title, $filename, time()]);
    }

    header("Location: admin_policies.php?saved=1");
    exit;
}

if ($action === "update_file") {
    $id = (int)$_POST['id'];
    $title = $_POST['file_title'] ?? '';

    $existing = $pdo->prepare("SELECT file_name FROM iaos_policies_files WHERE id=?");
    $existing->execute([$id]);
    $old = $existing->fetchColumn();

    $newfile = upload_pdf("file_pdf");

    $final = $newfile ?: $old;

    $pdo->prepare("UPDATE iaos_policies_files SET file_title=?, file_name=? WHERE id=?")
        ->execute([$title, $final, $id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}

if ($action === "delete_file") {
    $id = (int)$_POST['id'];

    $pdo->prepare("DELETE FROM iaos_policies_files WHERE id=?")
        ->execute([$id]);

    header("Location: admin_policies.php?saved=1");
    exit;
}

header("Location: admin_policies.php");
