<?php
require_once "admin_pannel/db.php";

// ✅ Fetch page header settings
$page = $pdo->query("SELECT * FROM community_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// ✅ Fetch intro settings (your correct table)
$intro = $pdo->query("SELECT * FROM community_intro_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// ✅ Fetch topics
$topics = $pdo->query("SELECT * FROM community_topics ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ✅ Fetch paragraphs
$para_stmt = $pdo->query("SELECT * FROM community_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras = [];
foreach ($para_stmt as $p) {

    if (empty($p['type'])) {
        $p['type'] = "paragraph"; // fallback
    }

    $p['type'] = strtolower($p['type']);

    $paras[$p['topic_id']][] = $p;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Community & Committees | IAOS Regina</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5"
         style="background:url('<?= htmlspecialchars($page['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($page['page_title']) ?></h1>
    <p class="lead"><?= htmlspecialchars($page['page_subtitle']) ?></p>
  </div>
</section>

<!-- ================= INTRODUCTION ================= -->
<section class="py-5">
  <div class="container-xl">

    <div class="text-center mb-5">

      <?php if (!empty($intro['download_file'])): ?>
        <a href="doc/<?= htmlspecialchars($intro['download_file']) ?>" class="btn-bylaw" download>
          <i class="bi bi-file-earmark-arrow-down me-2"></i>
          <?= htmlspecialchars($intro['download_text']) ?>
        </a>
      <?php endif; ?>

    </div>

    <p class="lead text-white">
      <?= nl2br(htmlspecialchars($intro['intro_paragraph'])) ?>
    </p>

  </div>
</section>

<!-- ================= COMMITTEES ================= -->
<section class="pb-5">
  <div class="container-xl">
    <div class="accordion" id="committeesAccordion">

      <?php foreach ($topics as $index => $t): ?>
      <div class="accordion-item">

        <h2 class="accordion-header" id="head<?= $t['id'] ?>">
          <button class="accordion-button <?= $index==0 ? '' : 'collapsed' ?>"
                  type="button"
                  data-bs-toggle="collapse"
                  data-bs-target="#topic<?= $t['id'] ?>">
            <?= htmlspecialchars($t['topic_title']) ?>
          </button>
        </h2>

        <div id="topic<?= $t['id'] ?>"
             class="accordion-collapse collapse <?= $index==0 ? 'show' : '' ?>"
             data-bs-parent="#committeesAccordion">

          <div class="accordion-body">

            <?php if (!empty($paras[$t['id']])): ?>

              <?php $ul_open = false; ?>

              <?php foreach ($paras[$t['id']] as $p): ?>

                <?php if ($p['type'] === 'heading'): ?>

                  <?php if ($ul_open) { echo "</ul>"; $ul_open = false; } ?>

                  <h5><?= htmlspecialchars($p['para_text']) ?></h5>

                <?php else: ?>

                  <?php if (!$ul_open) { echo "<ul>"; $ul_open = true; } ?>

                  <li><?= htmlspecialchars($p['para_text']) ?></li>

                <?php endif; ?>

              <?php endforeach; ?>

              <?php if ($ul_open) echo "</ul>"; ?>

            <?php endif; ?>

          </div>

        </div>

      </div>
      <?php endforeach; ?>

    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
