<?php
require_once "admin_pannel/db.php";

/* Header + Intro */
$page = $pdo->query("SELECT * FROM education_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$intro = $pdo->query("SELECT * FROM education_intro_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* Topics + paragraphs */
$topics = $pdo->query("SELECT * FROM education_topics ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);
$para_stmt = $pdo->query("SELECT * FROM education_paragraphs ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras = [];
foreach ($para_stmt as $p) {
  $t = strtolower($p['type'] ?: 'paragraph');
  $p['type'] = in_array($t,['heading','paragraph','li','html']) ? $t : 'paragraph';
  $paras[$p['topic_id']][] = $p;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($page['page_title'] ?? 'Education') ?> | IAOS Regina</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5"
         style="background:url('<?= htmlspecialchars($page['bg_image'] ?? 'images/banner3.jpg') ?>') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($page['page_title'] ?? 'Education') ?></h1>
    <p class="lead"><?= htmlspecialchars($page['page_subtitle'] ?? '') ?></p>
  </div>
</section>

<!-- INTRO -->
<section class="py-5">
  <div class="container-xl">
    <?php if (!empty($intro['download_file'])): ?>
      <div class="text-center mb-4">
        <a href="doc/<?= htmlspecialchars($intro['download_file']) ?>" class="btn-bylaw" download>
          <i class="bi bi-file-earmark-arrow-down me-2"></i>
          <?= htmlspecialchars($intro['download_text'] ?: 'Download') ?>
        </a>
      </div>
    <?php endif; ?>

    <?php if (!empty($intro['intro_paragraph'])): ?>
      <p class="lead text-white"><?= nl2br(htmlspecialchars($intro['intro_paragraph'])) ?></p>
    <?php endif; ?>
  </div>
</section>

<!-- PROGRAMS / TOPICS -->
<section class="pb-5">
  <div class="container-xl">
    <div class="accordion" id="eduAccordion">

      <?php foreach ($topics as $index => $t): ?>
        <div class="accordion-item">
          <h2 class="accordion-header" id="head<?= $t['id'] ?>">
            <button class="accordion-button <?= $index==0 ? '' : 'collapsed' ?>"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#topic<?= $t['id'] ?>">
              <?= htmlspecialchars($t['topic_title']) ?>
            </button>
          </h2>

          <div id="topic<?= $t['id'] ?>"
               class="accordion-collapse collapse <?= $index==0 ? 'hide' : '' ?>"
               data-bs-parent="#eduAccordion">

            <div class="accordion-body">
              <?php
                $items = $paras[$t['id']] ?? [];
                $ul_open = false;
                foreach ($items as $p) {
                  if ($p['type'] === 'heading') {
                    if ($ul_open) { echo '</ul>'; $ul_open = false; }
                    echo '<h5>'. htmlspecialchars($p['para_text']) .'</h5>';
                  } elseif ($p['type'] === 'li') {
                    if (!$ul_open) { echo '<ul>'; $ul_open = true; }
                    echo '<li>'. htmlspecialchars($p['para_text']) .'</li>';
                  } elseif ($p['type'] === 'html') {
                    if ($ul_open) { echo '</ul>'; $ul_open = false; }
                    echo $p['para_text']; // trusted admin
                  } else {
                    if ($ul_open) { echo '</ul>'; $ul_open = false; }
                    echo '<p>'. nl2br(htmlspecialchars($p['para_text'])) .'</p>';
                  }
                }
                if ($ul_open) echo '</ul>';
              ?>

              <?php if (!empty($t['show_admission_button'])): ?>
                <div class="text-center mt-3">
                  <button class="btn btn-success px-4"
                          data-bs-toggle="modal"
                          data-bs-target="#admitModal"
                          data-program="<?= htmlspecialchars($t['topic_title']) ?>">
                    Admission Now
                  </button>
                </div>
              <?php endif; ?>
            </div>

          </div>
        </div>
      <?php endforeach; ?>

    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Admission Modal (generic; program name injected) -->
<div class="modal fade" id="admitModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">
          Admission Form — <span id="admitProgram">Program</span>
        </h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <!-- You’ll replace/expand this form later -->
        <form>
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Full Name *</label>
              <input type="text" class="form-control" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Email *</label>
              <input type="email" class="form-control" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Phone *</label>
              <input type="text" class="form-control" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Preferred Start</label>
              <input type="date" class="form-control">
            </div>
            <div class="col-12">
              <label class="form-label">Notes</label>
              <textarea class="form-control" rows="3"></textarea>
            </div>
          </div>
          <div class="text-end mt-3">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button class="btn btn-success">Submit</button>
          </div>
        </form>
        <small class="text-muted d-block mt-2">(* This is a placeholder. You said you’ll provide the real form later.)</small>
      </div>
    </div>
  </div>
</div>

<script>
const admitModal = document.getElementById('admitModal');
admitModal.addEventListener('show.bs.modal', function (event) {
  const btn = event.relatedTarget;
  const program = btn?.getAttribute('data-program') || 'Program';
  document.getElementById('admitProgram').textContent = program;
});
</script>

<!-- Mobile donate button -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = (window.scrollY > lastScrollY) ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
