<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Full-Time Quran Hifz Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner4.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Full-Time Quran Hifz Program</h1>
    <p class="lead">Registration (2025 - 2026)</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">
    <div class="mb-5 text-white">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3">PROGRAM OVERVIEW</h3>
      <p>IAOS, Regina has been running the <strong>Full-Time Quran Hifz Program</strong> since 2016 very successfully. <strong>Alhamdulillah!</strong> 23 students have graduated (became Hafiz-ul-Quran) so far from this program under IAOS supervision.</p>

      <h5 class="fw-bold mt-4 text-success">Registration Information</h5>
      <ul>
        <li><strong>Age Limit:</strong> 7 years to 13 years (Boys only)</li>
        <li><strong>Pre-requisite:</strong> Able to read the Quran fluently. An assessment is required.</li>
        <li><strong>Class Hours:</strong> Monday–Thursday (8:30 AM – 3:00 PM) and Friday (8:30 AM – 12:30 PM)</li>
        <li><strong>Class Starts:</strong> Ongoing</li>
        <li><strong>Fees:</strong> $350/month and $250/month for siblings (via Bank EFT)</li>
      </ul>
    </div>

    <!-- ================= TERMS ACCORDION ================= -->
    <div class="accordion mb-5" id="termsAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#termsCollapse">
            Terms, Information & Regulations
          </button>
        </h2>
        <div id="termsCollapse" class="accordion-collapse collapse">
          <div class="accordion-body">
            <p><strong>Academic Session:</strong> Ongoing throughout the year (in-person at IAOS Masjid).</p>
            <p><strong>Registration:</strong> Based on availability; first-come, first-served.</p>
            <p><strong>Age of Admission:</strong> Minimum 7 years (boys only).</p>
            <p><strong>Payment:</strong> Via EFT only – provide a void cheque after approval.</p>
            <p><strong>Location:</strong> IAOS Masjid, 3273 Montague Street, Regina, SK</p>
            <p><strong>Note:</strong> Maintain 75 % attendance and bring Quran daily.</p>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= PAYMENT BUTTONS ================= -->
    <div class="text-center mb-5">
      <h5 class="text-white fw-bold mb-3">Payment Options</h5>
      <button class="btn btn-success px-4 py-2 me-2"><i class="bi bi-credit-card-2-front"></i> Payment 1st $350</button>
      <button class="btn btn-outline-success px-4 py-2"><i class="bi bi-credit-card"></i> Payment 2nd $250</button>
    </div>

    <!-- ================= UPDATED REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Full-Time Quran Hifz Program Registration Form</h4>
      <p class="text-center mb-4">Please fill out the mandatory information below. Fields marked with * are required.</p>

      <form>
        <div class="mb-3">
          <label>Email *</label>
          <input type="email" class="form-control" placeholder="e.g. tahirhafeez764@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Student’s Name *</label>
          <input type="text" class="form-control" placeholder="Full name as per Health Card or valid ID" required>
        </div>

        <div class="mb-3">
          <label>Date of Birth *</label>
          <input type="date" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Health Card Number *</label>
          <input type="text" class="form-control" placeholder="Enter 9-digit Health Card No." required>
        </div>

        <div class="mb-3">
          <label>Parent/Guardian Name *</label>
          <input type="text" class="form-control" placeholder="Full name as per Government ID" required>
        </div>

        <div class="mb-3">
          <label>Contact Phone Number *</label>
          <input type="text" class="form-control" placeholder="Home + Cell number" required>
        </div>

        <div class="mb-3">
          <label>Home Address *</label>
          <input type="text" class="form-control" placeholder="Street, City, Province, Postal Code" required>
        </div>

        <div class="mb-3">
          <label>Emergency Contact Person, Relationship & Phone *</label>
          <textarea class="form-control" rows="2" placeholder="e.g. Ali Khan, Father, 306-123-4567" required></textarea>
        </div>

        <div class="form-check mb-4">
          <input class="form-check-input" type="checkbox" id="copyResponses">
          <label class="form-check-label" for="copyResponses">
            Send me a copy of my responses
          </label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
