<?php
require_once "admin_pannel/db.php";

/* GLOBAL */
$set = $pdo->query("SELECT * FROM iaos_funerals_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* SECTIONS + PARAS */
$sections = $pdo->query("SELECT * FROM iaos_funerals_sections ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

$parasBySection = [];
if ($sections) {
  $ids = array_column($sections, 'id');
  $in = implode(',', array_fill(0, count($ids), '?'));
  $stmt = $pdo->prepare("SELECT * FROM iaos_funerals_paragraphs WHERE section_id IN ($in) ORDER BY position ASC, id ASC");
  $stmt->execute($ids);
  foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $p) {
    $parasBySection[$p['section_id']][] = $p;
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($set['page_title'] ?? 'Funeral & Burial Services') ?> | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('<?= htmlspecialchars($set['bg_image'] ?: "images/banner4.jpg") ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($set['page_title'] ?? 'Funeral & Burial Services') ?></h1>
    <p class="lead"><?= htmlspecialchars($set['page_subtitle'] ?? '“…Verily, unto Allah do we belong and, verily, unto Him we shall return.” (Qur’an 2:156)') ?></p>
  </div>
</section>

<!-- DYNAMIC SECTIONS (green: dark / white: bg-light) -->
<?php foreach ($sections as $s): 
  $isWhite = ($s['style'] === 'white');
?>
<section class="py-5 <?= $isWhite ? 'bg-light' : '' ?>">
  <div class="container-xl<?= $isWhite ? '' : ' text-white' ?>">
    <h3 class="greet-title greet-title-in <?= $isWhite ? '' : 'text-white' ?>">
      <?= htmlspecialchars($s['title']) ?>
    </h3>
    <br>
    <?php foreach (($parasBySection[$s['id']] ?? []) as $p): ?>
      <p class="<?= $isWhite ? '' : 'text-white' ?>"><?= nl2br(htmlspecialchars($p['para_text'])) ?></p>
    <?php endforeach; ?>
  </div>
</section>
<?php endforeach; ?>

<!-- ========== MULTI-STEP FUNERAL MEMBERSHIP FORM ========== -->
<section class="py-5">
  <div class="container-xl">
    <h2 class="greet-title greet-title-in text-white">Funeral & Burial Membership Form</h2>
	<br>
    <p class="mb-4 text-white">Please complete all 5 steps to register for the IAOS Funeral Membership Service.</p>

    <!-- Progress Bar -->
    <div class="progress-container">
      <div class="progress-bar-fill"></div>
    </div>

    <div class="text-center mb-4">
      <div class="step-indicator">
        <div class="step-circle active">1</div>
        <div class="step-circle">2</div>
        <div class="step-circle">3</div>
        <div class="step-circle">4</div>
        <div class="step-circle">5</div>
      </div>
    </div>

    <!-- ✅ Your original form is restored here -->
	<form id="multiStepForm" class="p-4 rounded-3 shadow-sm bg-white" method="POST" action="funeral-submit.php" enctype="multipart/form-data">
      <!-- STEP 1 -->
      <div class="form-step active">
        <h4 class="section-heading">Step 1 – Introduction</h4>
        <p>IAOS has established a sustainable program to ensure that every member is buried with dignity without financial strain. Please read the guidelines carefully before continuing.</p>
        <div class="text-end"><button type="button" class="btn btn-iaos next-step">Next</button></div>
      </div>

      <!-- STEP 2 -->
      <div class="form-step">
        <h4 class="section-heading">Step 2 – Fees & Terms and Conditions</h4>
        <ol>
          <li>Individual fee $100 (one-time non-refundable)</li>
          <li>Family fee $200 (one-time non-refundable)</li>
          <li>Burial fee $30–$50 shared among members</li>
          <li>Transportation covered up to 50 km from Masjid</li>
          <li>Outside Regina burial support up to $3000</li>
          <li>Membership subject to IAOS policy and revocation terms</li>
        </ol>
        <div class="form-check">
          <input class="form-check-input" type="radio" name="membership_type" value="Individual" required>
          <label class="form-check-label">Individual Membership — $100</label>
        </div>
        <div class="form-check mb-3">
          <input class="form-check-input" type="radio" name="membership_type" value="Family" required>
          <label class="form-check-label">Family Membership — $200</label>
        </div>
        <div class="d-flex justify-content-between">
          <button type="button" class="btn btn-secondary prev-step">Previous</button>
          <button type="button" class="btn btn-iaos next-step">Next</button>
        </div>
      </div>

      <!-- STEP 3 -->
      <div class="form-step">
        <h4 class="section-heading">Step 3 – Applicant Information</h4>
        <div class="row g-3">
          <div class="col-md-6"><label class="form-label">Full Name *</label><input type="text" class="form-control" name="full_name" required></div>
          <div class="col-md-6"><label class="form-label">Phone Number *</label><input type="text" class="form-control" name="phone" required></div>
          <div class="col-md-6"><label class="form-label">Email Address *</label><input type="email" class="form-control" name="email" required></div>
          <div class="col-md-6"><label class="form-label">Current Address *</label><input type="text" class="form-control" name="address" required></div>
          <div class="col-md-4"><label class="form-label">City *</label><input type="text" class="form-control" name="city" required></div>
          <div class="col-md-4"><label class="form-label">Province *</label><input type="text" class="form-control" name="province" required></div>
          <div class="col-md-4"><label class="form-label">Postal Code *</label><input type="text" class="form-control" name="postal_code" required></div>
          <div class="col-md-6"><label class="form-label">WhatsApp #</label><input type="text" class="form-control" name="whatsapp"></div>
          <div class="col-md-6">
            <label class="form-label">Address Type</label>
            <div class="form-check"><input class="form-check-input" type="radio" name="address_option" value="Same As Above"><label class="form-check-label">Same As Above</label></div>
            <div class="form-check"><input class="form-check-input" type="radio" name="address_option" value="Other"><label class="form-check-label">Other</label></div>
          </div>
        </div>
        <div class="d-flex justify-content-between mt-4">
          <button type="button" class="btn btn-secondary prev-step">Previous</button>
          <button type="button" class="btn btn-iaos next-step">Next</button>
        </div>
      </div>

      <!-- STEP 4 -->
      <div class="form-step">
        <h4 class="section-heading">Step 4 – Spouse & Family Information</h4>
        <p class="small">If applying for family membership, list names and relationships below.</p>
        <textarea class="form-control mb-3" name="family_members" rows="3" placeholder="e.g. Fatima (Spouse), Ali (Father)…"></textarea>
        <div class="row g-3">
          <div class="col-md-6"><label class="form-label">Family Phone </label><input type="text" class="form-control" name="family_phone"></div>
          <div class="col-md-6"><label class="form-label">Family Email </label><input type="email" class="form-control" name="family_email"></div>
          <div class="col-md-6"><label class="form-label">Family Address</label><input type="text" class="form-control" name="family_address"></div>
          <div class="col-md-6"><label class="form-label">City</label><input type="text" class="form-control" name="family_city"></div>
        </div>
        <div class="d-flex justify-content-between mt-4">
          <button type="button" class="btn btn-secondary prev-step">Previous</button>
          <button type="button" class="btn btn-iaos next-step">Next</button>
        </div>
      </div>

      <!-- STEP 5 -->
      <div class="form-step">
        <h4 class="section-heading">Step 5 – Declarations</h4>
        <div class="mb-3">
          <label>I am a Muslim *</label><br>
          <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="is_muslim" value="Yes" required><label class="form-check-label">Yes</label></div>
          <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="is_muslim" value="No"><label class="form-check-label">No</label></div>
        </div>
        <div class="mb-3">
          <label>I will abide by the IAOS Constitution and By-Laws *</label><br>
          <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="abide_laws" value="Yes" required><label class="form-check-label">Yes</label></div>
          <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="abide_laws" value="No"><label class="form-check-label">No</label></div>
        </div>
        <div class="mb-3 form-check">
          <input class="form-check-input" type="checkbox" name="agree_terms" required>
          <label class="form-check-label">I agree to the fees, terms, and conditions mentioned above.</label>
        </div>
        <div class="mb-3"><label>Date *</label><input type="date" class="form-control" name="date" required></div>
        <div class="d-flex justify-content-between">
          <button type="button" class="btn btn-secondary prev-step">Previous</button>
          <button type="submit" class="btn btn-iaos">Submit</button>
        </div>
      </div>
    </form>
  </div>
</section>
    <?php /* Paste your original full 5-step form here exactly as in your code */ ?>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
const steps=document.querySelectorAll('.form-step');
const nextBtns=document.querySelectorAll('.next-step');
const prevBtns=document.querySelectorAll('.prev-step');
const circles=document.querySelectorAll('.step-circle');
const progressBar=document.querySelector('.progress-bar-fill');
let currentStep=0;

function updateStep(dir,e){
  if(e) e.preventDefault(); // stop jump
  steps[currentStep].classList.remove('active');
  circles[currentStep].classList.remove('active');
  currentStep+=dir;
  if(currentStep<0) currentStep=0;
  if(currentStep>=steps.length) currentStep=steps.length-1;
  steps[currentStep].classList.add('active');
  circles[currentStep].classList.add('active');
  progressBar.style.width=(currentStep/(steps.length-1))*100+"%";
}

nextBtns.forEach(b=>b.addEventListener('click',e=>updateStep(1,e)));
prevBtns.forEach(b=>b.addEventListener('click',e=>updateStep(-1,e)));

const carouselEl=document.querySelector('#funeralCarousel');
if(carouselEl){ new bootstrap.Carousel(carouselEl,{interval:4000,ride:'carousel'}); }
</script>


</body>
</html>
