<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Halaqahs Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner4.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Weekly Halaqahs Program</h1>
    <p class="lead">IAOS Regina — Building Faith, Knowledge, and Community</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM OVERVIEW</h3>
      <p>The <strong>Halaqahs Program</strong> at IAOS Regina is a weekly educational and spiritual gathering designed for brothers, sisters, and youth. The purpose is to increase Islamic knowledge, strengthen Iman (faith), and connect the community through reflection, discussion, and remembrance of Allah (SWT).</p>

      <h5 class="fw-bold text-success mt-4">Program Objectives:</h5>
      <ul>
        <li>To develop a stronger connection with Allah through reflection on the Quran and Sunnah.</li>
        <li>To encourage discussion, questions, and personal growth in faith and character.</li>
        <li>To provide a comfortable environment for learning, sharing, and seeking guidance.</li>
        <li>To build bonds within the Muslim community through collective learning.</li>
      </ul>

      <h5 class="fw-bold text-success mt-4">Program Details:</h5>
      <ul>
        <li><strong>Academic Session:</strong> Ongoing (Weekly)</li>
        <li><strong>Days:</strong> Every Friday Evening</li>
        <li><strong>Time:</strong> After Maghrib Salah</li>
        <li><strong>Location:</strong> IAOS Masjid, 3273 Montague Street, Regina, SK</li>
        <li><strong>Separate Sessions:</strong> Brothers & Sisters (held in different areas)</li>
        <li><strong>Language:</strong> English (with occasional Arabic references)</li>
        <li><strong>Instructor:</strong> Imam & Guest Scholars</li>
        <li><strong>Fees:</strong> Free (open to all community members)</li>
      </ul>

      <p class="mt-3">Each session focuses on practical topics such as Tafseer of Quran, Hadith understanding, purification of the heart, family ethics, and community responsibilities — all grounded in authentic Islamic teachings.</p>
    </div>


<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
