<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Membership | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">

  <style>
    .membership-card {
      background: #f8f9fa;
      border-radius: 12px;
      padding: 25px;
      text-align: center;
      transition: all 0.3s ease;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      cursor: pointer;
    }
    .membership-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }
    .membership-card h5 {
      font-weight: 700;
      color: #0f5132;
    }
    .membership-card button {
      background-color: #0f5132;
      color: white;
      border-radius: 50px;
      padding: 6px 20px;
      border: none;
      transition: 0.3s;
    }
    .membership-card button:hover {
      background-color: #198754;
    }
    .download-btn {
      background-color: #0f5132;
      color: #fff;
      border-radius: 50px;
      padding: 10px 25px;
      border: none;
      transition: 0.3s;
    }
    .download-btn:hover {
      background-color: #198754;
      color: #fff;
    }
    .membership-form {
      display: none; /* Hidden until clicked */
    }
  </style>
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- ================= NAVBAR ================= -->
<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner4.jpg') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Become a Member of IAOS</h1>
    <p class="lead">Support your community — join IAOS and earn rewards from Allah SWT.</p>
  </div>
</section>

<!-- ================= INTRO ================= -->
<section class="py-5">
  <div class="container-xl text-white">
    <div class="mb-5">
      <h3 class="greet-title fw-bold mb-3 greet-title-in text-white">Purpose of Membership</h3>
      <p>
        The Islamic Association of Saskatchewan (IAOS) is the main Islamic organization in Regina, providing daily and Friday prayers, Taraweeh, Eid, education programs, youth activities, Iftar programs, and funeral services for over 30 years.
        Supporting IAOS through membership helps sustain these vital programs and maintain our facilities.
      </p>
    </div>
  </div>
</section>

<!-- ================= MEMBERSHIP OPTIONS ================= -->
<section class="py-3">
  <div class="container-xl">

    <!-- Desktop Grid (visible md and up) -->
    <div class="row g-4 justify-content-center d-none d-md-flex">
      <div class="col-md-6 col-sm-6">
        <div class="membership-card">
          <h5>Membership Renewal Form</h5>
          <p>Apply online or renew your membership with IAOS.</p>
          <button id="openMembershipForm"><i class="bi bi-person-lines-fill me-1"></i> Open Form</button>
        </div>
      </div>

      <div class="col-md-6 col-sm-6">
        <div class="membership-card">
          <h5>Pre-Authorized Payment Form</h5>
          <p>Set up automatic monthly or yearly payments.</p>
          <button id="openPreAuthorizedMembershipForm"><i class="bi bi-person-lines-fill me-1"></i> Open Form</button>
        </div>
      </div>
    </div>

    <!-- Mobile Slider (below md) -->
    <div id="membershipCarousel" class="carousel slide d-md-none" data-bs-ride="carousel">
      <div class="carousel-inner text-center">

        <!-- Slide 1 -->
        <div class="carousel-item active">
          <div class="membership-card mx-4">
            <h5>Membership Renewal Form</h5>
            <p>Apply online or renew your membership with IAOS.</p>
            <button id="openMembershipFormMobile"><i class="bi bi-person-lines-fill me-1"></i> Open Form</button>
          </div>
        </div>

        <!-- Slide 2 -->
        <div class="carousel-item">
          <div class="membership-card mx-4">
            <h5>Pre-Authorized Payment Form</h5>
            <p>Set up automatic monthly or yearly payments.</p>
            <button id="openPreAuthorizedMembershipFormMobile"><i class="bi bi-person-lines-fill me-1"></i> Open Form</button>
          </div>
        </div>

      </div>

      <!-- Controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#membershipCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#membershipCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
      </button>
    </div>

  </div>
</section>

<!-- ================= PRE-AUTHORIZED PAYMENT FORM ================= -->
<section class="py-5 bg-light">
  <div class="container-xl">
	<div class="row gy-3">
		<div class="col-md-4"></div>
        <div class="col-md-4">
          <a href="doc/IAOS-Constitution-1998.pdf" class="btn-policy" download>
            IAOS Constitution &amp; Bylaws
            <i class="bi bi-file-earmark-arrow-down"></i>
          </a>
        </div>
		<div class="col-md-4"></div>
	</div>
  </div>
</section>

<!-- ================= MEMBERSHIP FORM ================= -->
<section class="py-5 bg-light membership-form" id="membershipFormSection">
  <div class="container-xl">
    <div class="text-center mb-5">
      <h2 class="greet-title">Membership Application Form</h2>
      <p class="text-muted">In the Name of Allah, Most Gracious, Most Merciful</p>
      <p><strong>The Islamic Association of Saskatchewan, Regina Inc.</strong><br>3273 Montague Street, Regina, SK, S4S 1Z8<br>
      Phone: (306) 585-0090 | E-mail: iaos@iaosregina.com</p>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-10">
        <form class="p-4 rounded-3 shadow-sm bg-white" method="POST" action="membership-submit.php" enctype="multipart/form-data">
          <div class="row g-3">

            <div class="col-md-6">
              <label class="form-label fw-semibold">First Name</label>
              <input type="text" class="form-control" name="first_name" required>
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Last Name</label>
              <input type="text" class="form-control" name="last_name" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Address</label>
              <input type="text" class="form-control" name="address" placeholder="Street, City, Province, Postal Code" required>
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Home Telephone</label>
              <input type="text" class="form-control" name="home_phone">
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Work Telephone</label>
              <input type="text" class="form-control" name="work_phone">
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Email</label>
              <input type="email" class="form-control" name="email" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Spouse Name (if applicable)</label>
              <input type="text" class="form-control" name="spouse_name">
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Spouse Email</label>
              <input type="email" class="form-control" name="spouse_email">
            </div>

            <div class="col-12">
              <label class="form-label fw-semibold">Children (Name / Birth Date / Gender)</label>
              <textarea class="form-control" name="children" rows="2" placeholder="Example: Ahmed / 02-15 / M"></textarea>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Reference 1 (Name & Phone)</label>
              <input type="text" class="form-control" name="reference1">
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Reference 2 (Name & Phone)</label>
              <input type="text" class="form-control" name="reference2">
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Membership Type</label>
              <select class="form-select" name="membership_type" required>
                <option value="">Select...</option>
                <option value="Individual">Individual - $15/year + min. $15/month</option>
                <option value="Family">Family - $30/year + min. $30/month</option>
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Monthly Contribution</label>
              <input type="number" class="form-control" name="monthly_fee" placeholder="Enter amount per month" min="15">
            </div>

            <div class="col-12">
              <label class="form-label fw-semibold">Proof of Residency / Citizenship (upload image or PDF)</label>
              <input type="file" class="form-control" name="proof_file" accept="image/*,application/pdf" required>
            </div>

            <div class="col-12 mt-3">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="declaration" required>
                <label class="form-check-label">I confirm that I am a Muslim, over the age of 18, residing in Saskatchewan, and agree to abide by the IAOS Constitution and Bylaws.</label>
              </div>
            </div>

            <div class="col-12 text-center mt-4">
              <button type="submit" class="btn btn-success px-4 py-2 rounded-pill">
                <i class="bi bi-send me-1"></i> Submit Application
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ================= PRE-AUTHORIZED PAYMENT FORM ================= -->
<section class="py-5 bg-light membership-form" id="paymentFormSection" style="display:none;">
  <div class="container-xl">
    <div class="text-center mb-5">
      <h2 class="greet-title">Pre-Authorized Payment Form</h2>
      <p class="text-muted">In the Name of Allah, Most Gracious, Most Merciful</p>
      <p><strong>The Islamic Association of Saskatchewan, Regina Inc.</strong><br>
        3273 Montague Street, Regina, SK, S4S 1Z8<br>
        Phone: (306) 585-0090 | E-mail: iaos@iaosregina.com
      </p>
      <p class="small text-muted">
        Please fill out this form to authorize direct electronic deduction of monthly maintenance and yearly membership fees.
        Monthly fees will be deducted on the <strong>20th of each month</strong>, and annual fees on <strong>September 20th</strong>.
      </p>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-10">
        <form class="p-4 rounded-3 shadow-sm bg-white" method="POST" action="payment-submit.php" enctype="multipart/form-data">
          <div class="row g-3">

            <div class="col-md-6">
              <label class="form-label fw-semibold">Payor Name</label>
              <input type="text" class="form-control" name="payor_name" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Address</label>
              <input type="text" class="form-control" name="address" required placeholder="Street, City, Province, Postal Code">
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Phone Number</label>
              <input type="text" class="form-control" name="phone">
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Email</label>
              <input type="email" class="form-control" name="email" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Membership Type</label>
              <select class="form-select" name="membership_type" required>
                <option value="">Select...</option>
                <option value="Individual">Individual - $15/year</option>
                <option value="Family">Family - $30/year</option>
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Monthly Maintenance Fee</label>
              <input type="number" class="form-control" name="monthly_fee" placeholder="Minimum $15 Individual / $30 Family" min="15" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Start Date (First Debit)</label>
              <input type="date" class="form-control" name="start_date" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Attach VOID Cheque / Proof Document</label>
              <input type="file" class="form-control" name="void_cheque" accept="image/*,application/pdf" required>
            </div>

            <div class="col-12">
              <label class="form-label fw-semibold">Authorization Acknowledgment</label>
              <textarea class="form-control" name="authorization_text" rows="4" readonly>
I authorize the Islamic Association of Saskatchewan, Regina Inc. to debit my account electronically for the monthly maintenance fee on the 20th of each month beginning on the above date, and an additional amount for the annual membership fee on September 20th each year. I have read, understood, and accepted the Terms and Conditions of the Pre-Authorized Payment Authorization.
              </textarea>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Signature of Payor</label>
              <input type="text" class="form-control" name="signature" placeholder="Type full name as signature" required>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Date</label>
              <input type="date" class="form-control" name="signed_date" required>
            </div>

            <div class="col-12 mt-3">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="confirm_terms" required>
                <label class="form-check-label">
                  I have read and agree to the <a href="pdf/Pre_Authorized_Payment_Terms.pdf" target="_blank">Terms & Conditions</a> of the Pre-Authorized Payment Authorization.
                </label>
              </div>
            </div>

            <div class="col-12 text-center mt-4">
              <button type="submit" class="btn btn-success px-4 py-2 rounded-pill">
                <i class="bi bi-send me-1"></i> Submit Authorization
              </button>
            </div>

          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<!-- ================= FOOTER ================= -->
<?php include 'footer.php'; ?>

<!-- ================= JS ================= -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  const membershipForm = document.getElementById("membershipFormSection");
  const paymentForm = document.getElementById("paymentFormSection");

  function showForm(formToShow) {
    membershipForm.style.display = "none";
    paymentForm.style.display = "none";
    formToShow.style.display = "block";
    formToShow.scrollIntoView({ behavior: "smooth" });
  }

  // Desktop buttons
  document.getElementById("openMembershipForm").addEventListener("click", () => showForm(membershipForm));
  document.getElementById("openPreAuthorizedMembershipForm").addEventListener("click", () => showForm(paymentForm));

  // Mobile buttons
  document.getElementById("openMembershipFormMobile").addEventListener("click", () => showForm(membershipForm));
  document.getElementById("openPreAuthorizedMembershipFormMobile").addEventListener("click", () => showForm(paymentForm));
</script>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');

window.addEventListener('scroll', () => {
  if (window.scrollY > lastScrollY) {
    donateBtn.style.opacity = '0';
  } else {
    donateBtn.style.opacity = '1';
  }
  lastScrollY = window.scrollY;
});
</script>

<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

</body>
</html>
