<?php
date_default_timezone_set("America/Regina");

/* ✅ PRAYER DB CONNECTION */
try {
    $pdoSalah = new PDO(
        "mysql:host=localhost;dbname=iaosr874_new;charset=utf8mb4",
        "iaosr874_newWeb",
        "kkrNvZVT57-ru3~]"
    );
    $pdoSalah->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    $pdoSalah = null;
}

/* ✅ helper formatter */
function fmt($t){
  return $t ? date("g:i A", strtotime($t)) : "—";
}

/* ✅ today row */
$todayRow = [];
$weekRows = [];

if($pdoSalah){
    $today = date("Y-m-d");

    $stmt = $pdoSalah->prepare("SELECT * FROM prayer_times WHERE prayer_date=? LIMIT 1");
    $stmt->execute([$today]);
    $todayRow = $stmt->fetch(PDO::FETCH_ASSOC);

    /* ✅ next 7 days */
    $stmt2 = $pdoSalah->prepare("
      SELECT prayer_date, hijri,
             fajar, zuhar, asar, magrib_begins, isha,
             jumah1, jumah2
      FROM prayer_times
      WHERE prayer_date >= CURDATE()
      ORDER BY prayer_date ASC
      LIMIT 7
    ");
    $stmt2->execute();
    $weekRows = $stmt2->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!-- Prayer Times Modal -->
<div class="modal fade" id="prayerModal" tabindex="-1" aria-labelledby="prayerModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content bg-light">

      <div class="modal-header bg-teal text-white d-flex justify-content-between align-items-center">
        <h5 class="modal-title" id="prayerModalLabel">Prayer Times</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">

        <!-- VIEW TOGGLE -->
        <div class="text-center mb-4">
          <div class="btn-group">
            <button class="btn btn-outline-success active" id="btnDaily">Daily</button>
            <button class="btn btn-outline-success" id="btnWeekly">Weekly</button>
          </div>
        </div>

        <!-- DAILY VIEW -->
        <div id="dailyView">
          <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
              <thead class="table-success">
                <tr>
                  <th>Date</th>
                  <th>Fajr</th>
                  <th>Dhuhr</th>
                  <th>Asr</th>
                  <th>Maghrib</th>
                  <th>Isha</th>
                  <th>Jumma</th>
                  <th>Jumma 2</th>
                  <th>Hijri</th>
                </tr>
              </thead>
              <tbody>
                <?php if (!empty($todayRow)): ?>
                  <?php $isFridayToday = (date('l', strtotime($todayRow['prayer_date'])) === 'Friday'); ?>
                  <tr>
                    <td><?= date('D, M j', strtotime($todayRow['prayer_date'])) ?></td>
                    <td><?= fmt($todayRow['fajar']) ?></td>
                    <td><?= fmt($todayRow['zuhar']) ?></td>
                    <td><?= fmt($todayRow['asar']) ?></td>
                    <td><?= fmt($todayRow['magrib_begins']) ?></td>
                    <td><?= fmt($todayRow['isha']) ?></td>
                    <td><?= $isFridayToday ? fmt($todayRow['jumah1']) : '-' ?></td>
                    <td><?= $isFridayToday ? fmt($todayRow['jumah2']) : '-' ?></td>
                    <td><?= htmlspecialchars($todayRow['hijri'] ?? '—') ?></td>
                  </tr>
                <?php else: ?>
                  <tr><td colspan="9">No data for today</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>

        <!-- WEEKLY VIEW -->
        <div id="weeklyView" class="d-none">
          <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
              <thead class="table-success">
                <tr>
                  <th>Day</th>
                  <th>Fajr</th>
                  <th>Dhuhr</th>
                  <th>Asr</th>
                  <th>Maghrib</th>
                  <th>Isha</th>
                  <th>Jumma</th>
                  <th>Jumma 2</th>
                  <th>Hijri</th>
                </tr>
              </thead>
              <tbody>
                <?php if(!empty($weekRows)): ?>
                  <?php foreach($weekRows as $r): ?>
                    <?php
                      $dayName  = date('l', strtotime($r['prayer_date']));
                      $isFriday = ($dayName === 'Friday');
                    ?>
                    <tr>
                      <td><?= date('D', strtotime($r['prayer_date'])) ?></td>
                      <td><?= fmt($r['fajar']) ?></td>
                      <td><?= fmt($r['zuhar']) ?></td>
                      <td><?= fmt($r['asar']) ?></td>
                      <td><?= fmt($r['magrib_begins']) ?></td>
                      <td><?= fmt($r['isha']) ?></td>
                      <td><?= $isFriday ? fmt($r['jumah1']) : '-' ?></td>
                      <td><?= $isFriday ? fmt($r['jumah2']) : '-' ?></td>
                      <td><?= htmlspecialchars($r['hijri'] ?? '—') ?></td>
                    </tr>
                  <?php endforeach; ?>
                <?php else: ?>
                  <tr><td colspan="9">No weekly data</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>

      </div>

      <div class="modal-footer">
        <small class="text-muted">All times are approximate and based on Regina local time.</small>
      </div>

    </div>
  </div>
</div>

<script>
/* ✅ Daily / Weekly Toggle */
document.addEventListener("DOMContentLoaded", function(){

  const btnDaily  = document.getElementById("btnDaily");
  const btnWeekly = document.getElementById("btnWeekly");
  const dailyView  = document.getElementById("dailyView");
  const weeklyView = document.getElementById("weeklyView");

  btnDaily.addEventListener("click", () => {
    btnDaily.classList.add("active");
    btnWeekly.classList.remove("active");
    dailyView.classList.remove("d-none");
    weeklyView.classList.add("d-none");
  });

  btnWeekly.addEventListener("click", () => {
    btnWeekly.classList.add("active");
    btnDaily.classList.remove("active");
    weeklyView.classList.remove("d-none");
    dailyView.classList.add("d-none");
  });

});
</script>
