<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Quran Learning Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner3.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Quran Learning Program</h1>
    <p class="lead">IAOS Regina — Quran Recitation, Tajweed, and Understanding for All Ages</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM OVERVIEW</h3>
      <p>The <strong>Quran Learning Program</strong> at IAOS Regina is a continuous educational initiative aimed at helping children, youth, and adults strengthen their relationship with the Holy Quran. Whether you are a beginner or wish to perfect your recitation, this program offers a structured path to learn at your own level and pace under qualified instructors.</p>

      <h5 class="fw-bold text-success mt-4">Program Objectives:</h5>
      <ul>
        <li>To teach accurate Quran recitation with proper pronunciation and Tajweed.</li>
        <li>To help students develop love for Quran reading and reflection.</li>
        <li>To introduce basic understanding (Tafseer) and context of selected Surahs.</li>
        <li>To encourage memorization of short Surahs and daily Duas.</li>
        <li>To strengthen Islamic identity through spiritual connection with the Quran.</li>
      </ul>

      <h5 class="fw-bold text-success mt-4">Program Details:</h5>
      <ul>
        <li><strong>Academic Session:</strong> Ongoing (Continuous Enrollment)</li>
        <li><strong>Days:</strong> Monday, Wednesday & Friday</li>
        <li><strong>Time:</strong> 6:00 PM – 8:00 PM</li>
        <li><strong>Location:</strong> IAOS Masjid, 3273 Montague Street, Regina, SK</li>
        <li><strong>Age Group:</strong> 6 years & above (Boys, Girls, and Adults)</li>
        <li><strong>Monthly Fees:</strong> $60 per student | $50 for siblings</li>
        <li><strong>Payment Method:</strong> EFT (Electronic Fund Transfer)</li>
      </ul>
    </div>

    <!-- ================= RULES ACCORDION ================= -->
    <div class="accordion mb-5" id="rulesAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRules">
            Rules and Regulations
          </button>
        </h2>
        <div id="collapseRules" class="accordion-collapse collapse">
          <div class="accordion-body">
            <p><strong>Attendance:</strong> Students must attend regularly and on time. Repeated absences without notice may affect progress.</p>
            <p><strong>Etiquette:</strong> Students must respect teachers and classmates, and maintain proper Islamic manners in class.</p>
            <p><strong>Dress Code:</strong> Modest attire is required. Boys should wear topi/head covering, and girls should wear hijab.</p>
            <p><strong>Study Materials:</strong> Each student must bring their own Quran, notebook, and pen. Sharing is discouraged.</p>
            <p><strong>Behavior:</strong> Disruptive behavior, talking during class, or disrespect will not be tolerated.</p>
            <p><strong>Safety:</strong> Parents should pick up children promptly after class hours. IAOS is not responsible for supervision after class ends.</p>
            <p><strong>Financial Assistance:</strong> Available on request for eligible families facing financial challenges.</p>
            <p><strong>Contact:</strong> <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a></p>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Quran Learning Program Registration Form</h4>
      <p class="text-center mb-4">Please fill out the required information. Fields marked with * are mandatory.</p>

      <form>
        <div class="mb-3">
          <label>Email Address *</label>
          <input type="email" class="form-control" placeholder="e.g. tahirhafeez764@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Full Name (Student) *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Parent/Guardian Name (if applicable)</label>
          <input type="text" class="form-control" placeholder="Leave blank if adult participant">
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Date of Birth *</label>
            <input type="date" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Gender *</label>
            <select class="form-select" required>
              <option value="">Select</option>
              <option>Male</option>
              <option>Female</option>
            </select>
          </div>
        </div>

        <div class="mb-3">
          <label>Contact Phone Number *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Home Address *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Emergency Contact (Name, Relationship & Phone) *</label>
          <textarea class="form-control" rows="2" placeholder="e.g. Ahmed Ali, Father, 306-555-7890" required></textarea>
        </div>

        <div class="mb-3">
          <label>Preferred Level *</label>
          <select class="form-select" required>
            <option value="">Select Level</option>
            <option>Beginner (Qaida / Basic Reading)</option>
            <option>Intermediate (Fluent Reading + Tajweed)</option>
            <option>Advanced (Quran Memorization / Tafseer)</option>
          </select>
        </div>

        <div class="mb-3">
          <label>Previous Quran Teacher / Institute (if any)</label>
          <input type="text" class="form-control" placeholder="Optional">
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" id="agreeRules" required>
          <label class="form-check-label" for="agreeRules">
            I certify that I have read the <a href="#collapseRules" data-bs-toggle="collapse" class="text-success fw-semibold text-decoration-none">rules and regulations</a> and will abide by them.
          </label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
