<?php
require_once "admin_pannel/db.php";

/* PAGE SETTINGS */
$settings = $pdo->query("SELECT * FROM iaos_rizq_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* SECTIONS */
$sections = $pdo->query("
  SELECT * FROM iaos_rizq_sections 
  ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);

/* PARAGRAPHS */
$paras_stmt = $pdo->query("
  SELECT * FROM iaos_rizq_paragraphs 
  ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);

$paras = [];
foreach ($paras_stmt as $p) {
  $paras[$p['section_id']][] = $p;
}

/* LIMITS */
$limits = $pdo->query("
  SELECT * FROM iaos_rizq_limits 
  ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);

function section_open($isLight = false) {
  echo $isLight ? '<section class="py-5 bg-light">' : '<section class="py-5">';
  echo '<div class="container-xl">';
}
function section_close() {
  echo '</div></section>';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />

<title>Rizq Relief & Financial Assistance | IAOS Regina</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="icon" type="image/png" href="images/fav.png">
<link rel="stylesheet" href="css/style.css">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5"
  style="background:url('<?= htmlspecialchars($settings['bg_image'] ?? 'images/banner_rizq.jpg') ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-3">
      <?= htmlspecialchars($settings['page_title'] ?? 'Rizq Relief & Financial Assistance') ?>
    </h1>
    <?php if (!empty($settings['page_subtitle'])): ?>
      <p class="lead fst-italic"><?= htmlspecialchars($settings['page_subtitle']) ?></p>
    <?php endif; ?>
  </div>
</section>

<?php
foreach ($sections as $s) {

  $isLight = ($s['style'] === 'default');
  section_open($isLight);

  $headingClass = ($s['style'] === 'green')
    ? 'greet-title greet-title-in text-white'
    : 'greet-title greet-title-in';

  echo '<h3 class="'.$headingClass.'">'.htmlspecialchars($s['section_title']).'</h3><br>';

  $items = $paras[$s['id']] ?? [];
  $ul_open = false;
  $textClass = $isLight ? '' : ' text-white';

  $showLimits = (
    trim($s['section_title']) === 'Types of Financial Assistance Provided'
    && !empty($limits)
  );

  foreach ($items as $p) {

    $type = $p['type'] ?? 'paragraph';

    if ($type === 'heading') {
      if ($ul_open) { echo '</ul>'; $ul_open = false; }
      echo '<h5 class="fw-bold'.$textClass.'">'.htmlspecialchars($p['para_text']).'</h5>';
    }
    elseif ($type === 'li') {
      if (!$ul_open) {
        echo $isLight ? '<ul>' : '<ul class="text-white">';
        $ul_open = true;
      }
      echo '<li>'.htmlspecialchars($p['para_text']).'</li>';
    }
    elseif ($type === 'html') {
      if ($ul_open) { echo '</ul>'; $ul_open = false; }
      echo $p['para_text'];
    }
    else {
      if ($ul_open) { echo '</ul>'; $ul_open = false; }
      echo '<p class="mb-3'.$textClass.'">'.htmlspecialchars($p['para_text']).'</p>';
    }
  }

  if ($ul_open) echo '</ul>';

  /* LIMIT TABLE */
  if ($showLimits) {
    echo '<div class="table-responsive mt-3">';
    echo '<table class="table table-bordered table-striped bg-light text-dark align-middle">';
    echo '<thead class="table-success text-center">
            <tr>
              <th>Type of Need</th>
              <th>Maximum Funding Limit per Application</th>
            </tr>
          </thead><tbody>';
    foreach ($limits as $r) {
      echo '<tr>
              <td>'.htmlspecialchars($r['need']).'</td>
              <td>'.htmlspecialchars($r['max_limit']).'</td>
            </tr>';
    }
    echo '</tbody></table></div>';
  }

  section_close();
}
?>

<!-- APPLY SECTION -->
<section class="py-5 bg-light">
<div class="container-xl">

  <div class="text-center mt-4">
    <button class="btn btn-success px-5 py-2"
      data-bs-toggle="collapse"
      data-bs-target="#takafulForm">
      <i class="bi bi-clipboard-check me-1"></i>
      Apply for Rizq Assistance
    </button>
  </div>

  <!-- FORM (STATIC FOR NOW) -->
<div class="collapse mt-5" id="takafulForm">
  <div class="card card-body shadow-sm border-0 mx-auto" style="max-width:900px;">

    <h4 class="mb-4 text-success">Food Hamper Support Application</h4>

    <form method="POST" action="submit_rizq_application.php" enctype="multipart/form-data">

      <!-- NAME -->
      <h6>Name *</h6>
      <div class="row g-3">
        <div class="col-md-6">
          <input type="text" name="first_name" class="form-control" placeholder="First Name" required>
        </div>
        <div class="col-md-6">
          <input type="text" name="last_name" class="form-control" placeholder="Last Name" required>
        </div>
      </div>

      <!-- CONTACT -->
      <div class="row g-3 mt-2">
        <div class="col-md-6">
          <label>Mobile Phone *</label>
          <input type="text" name="mobile_phone" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label>Email *</label>
          <input type="email" name="email" class="form-control" required>
        </div>
      </div>

      <!-- ADDRESS -->
      <h6 class="mt-4">Home Address *</h6>
      <input type="text" name="street_address" class="form-control mb-2" placeholder="Street Address" required>
      <input type="text" name="street_address_2" class="form-control mb-2" placeholder="Street Address Line 2">

      <div class="row g-3">
        <div class="col-md-4">
          <input type="text" name="city" class="form-control" placeholder="City" required>
        </div>
        <div class="col-md-4">
          <input type="text" name="province" class="form-control" placeholder="Province" required>
        </div>
        <div class="col-md-4">
          <input type="text" name="postal_code" class="form-control" placeholder="Postal Code" required>
        </div>
      </div>

      <!-- PERSONAL -->
      <div class="row g-3 mt-3">
        <div class="col-md-4">
          <label>Date of Birth *</label>
          <input type="date" name="birth_date" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label>Marital Status *</label>
          <select name="marital_status" class="form-select" required>
            <option value="">Please Select</option>
            <option>Single</option>
            <option>Married</option>
            <option>Divorced</option>
            <option>Widowed</option>
          </select>
        </div>
        <div class="col-md-4">
          <label>Gender *</label>
          <select name="gender" class="form-select" required>
            <option value="">Please Select</option>
            <option>Male</option>
            <option>Female</option>
          </select>
        </div>
      </div>

      <!-- FAMILY -->
      <h6 class="mt-4">Family Size</h6>
      <div class="row g-3">
        <div class="col-md-4">
          <label>Adults (18+)</label>
          <input type="number" name="adults_18_plus" class="form-control" value="0">
        </div>
        <div class="col-md-4">
          <label>Children (12–17)</label>
          <input type="number" name="children_12_17" class="form-control" value="0">
        </div>
        <div class="col-md-4">
          <label>Children (0–11)</label>
          <input type="number" name="children_0_11" class="form-control" value="0">
        </div>
      </div>

      <!-- FILE UPLOADS -->
      <h6 class="mt-4">Required Documents</h6>

      <label>A. Government ID / Immigration Status *</label>
      <input type="file" name="immigration_doc" class="form-control mb-3" required>

      <label>B. Last 3 months Bank Statement *</label>
      <input type="file" name="bank_statement" class="form-control mb-3" required>

      <label>C. Rental / Mortgage Document</label>
      <input type="file" name="rental_mortgage_doc" class="form-control mb-3">

      <!-- ADDITIONAL INFO -->
      <h6 class="mt-4">Additional Information *</h6>
      <textarea name="additional_information" class="form-control" rows="4" required></textarea>

      <!-- LIABILITY -->
      <h6 class="mt-4">Risk Relief Liability Release *</h6>
      <div class="form-check">
        <input class="form-check-input" type="radio" name="liability_accept" value="ACCEPT" required>
        <label class="form-check-label">I accept all the conditions</label>
      </div>
      <div class="form-check">
        <input class="form-check-input" type="radio" name="liability_accept" value="DECLINE">
        <label class="form-check-label">I do NOT accept all terms</label>
      </div>

      <label class="mt-2">Signature (Full Name)</label>
      <input type="text" name="signature_name" class="form-control" required>

      <!-- SUBMIT -->
      <p class="small text-muted mt-3">
        Completing this application does not guarantee registration for the program.
      </p>

      <button class="btn btn-success px-5 mt-3">Submit Application</button>

    </form>
  </div>
</div>

</div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
