<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Summer School and Summer Hifz 2025 | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner2.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Summer School & Hifz - 2025</h1>
    <p class="lead">IAOS Regina Summer Quran & Activity Program</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM INFORMATION</h3>
      <p>The Islamic Association of Saskatchewan, Regina, is pleased to announce its <strong>Summer School and Summer Hifz Program 2025</strong>. The program provides children with Islamic education, Quran recitation, and engaging activities in a nurturing environment.</p>

      <h5 class="fw-bold text-success mt-4">Regular Summer School (Boys & Girls)</h5>
      <p>The objective is to teach Quran and Islamic Studies while engaging students in fun, educational activities including:</p>
      <ul>
        <li>Seerah of Prophet Muhammad (peace be upon him)</li>
        <li>Salah, Hajj & Eid lessons</li>
        <li>Prophet stories</li>
        <li>Athaan, Nasheed & Speech competitions</li>
        <li>Posters, Calligraphy & Art activities</li>
        <li>Explanation / Tafseer of short Surahs</li>
        <li>Character building & manners</li>
      </ul>

      <h5 class="fw-bold text-success mt-4">Summer Quran Hifz Program (Boys only)</h5>
      <p>For boys focusing on Quran memorization and proper Tajweed. Includes:</p>
      <ul>
        <li>Quran memorization</li>
        <li>Learning Tajweed</li>
        <li>Islamic manners and discipline</li>
        <li>Outdoor activities</li>
      </ul>
    </div>

    <!-- ================= RULES ACCORDION ================= -->
    <div class="accordion mb-5" id="rulesAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRules">
            Rules and Regulations
          </button>
        </h2>
        <div id="collapseRules" class="accordion-collapse collapse">
          <div class="accordion-body">
            <p><strong>Registration Deadline:</strong> May 30, 2025 – June 22, 2025 (First come, first served)</p>
            <p><strong>Session Dates:</strong> July 7 – August 21, 2025</p>
            <p><strong>Age Limit:</strong> 6 – 16 years old (below 6 not accepted)</p>
            <p><strong>Class Schedule:</strong> Monday – Thursday, 10:00 AM – 1:30 PM</p>
            <p><strong>Fees:</strong> $160 (first child) / $140 (each additional)</p>
            <p><strong>Payment:</strong> Online after registration acceptance (link will be emailed)</p>

            <h6 class="fw-bold mt-4">Guidelines & Safety</h6>
            <ul>
              <li>Do not arrive more than 10 minutes early.</li>
              <li>Bring a snack and water bottle.</li>
              <li>Students must be picked up on time.</li>
              <li>Respectful behavior is mandatory; misbehavior may lead to expulsion.</li>
              <li>No toys, games, or electronics allowed.</li>
              <li>Dress modestly; boys wear topi, girls wear hijab.</li>
            </ul>

            <p class="mt-3"><strong>Contact:</strong> <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a></p>

            <h6 class="fw-bold mt-4">Achievement Methods:</h6>
            <ul>
              <li>Maintain punctuality and attendance.</li>
              <li>Prepare and revise lessons daily.</li>
              <li>Show respect and gratitude (“Jazakallah”, “Please”).</li>
              <li>Encourage peers and be truthful.</li>
              <li>Follow Islamic manners and classroom etiquette.</li>
            </ul>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Summer School & Hifz 2025 Registration Form</h4>
      <p class="text-center mb-4">Please fill out the required information. Fields marked with * are mandatory.</p>

      <form>
        <div class="mb-3">
          <label>Email Address *</label>
          <input type="email" class="form-control" placeholder="e.g. tahirhafeez764@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Student’s Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Parent/Guardian Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Date of Birth *</label>
            <input type="date" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Gender *</label>
            <select class="form-select" required>
              <option value="">Select</option>
              <option>Male</option>
              <option>Female</option>
            </select>
          </div>
        </div>

        <div class="mb-3">
          <label>Contact Phone Number (Home + Cell) *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Home Address *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Emergency Contact Person, Relationship, & Phone *</label>
          <textarea class="form-control" rows="2" placeholder="e.g. Ahmed Khan, Father, 306-555-7890" required></textarea>
        </div>

        <div class="mb-4">
          <label>Please choose one of the programs for your child: *</label>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="program" id="regularSchool" required>
            <label class="form-check-label" for="regularSchool">
              Regular Summer School (Boys & Girls)
            </label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="radio" name="program" id="summerHifz" required>
            <label class="form-check-label" for="summerHifz">
              Summer Quran Hifz Program (Only for Boys)
            </label>
          </div>
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" id="agreeRules" required>
          <label class="form-check-label" for="agreeRules">
            I certify that I have read the <a href="#collapseRules" data-bs-toggle="collapse" class="text-success fw-semibold text-decoration-none">rules and regulations</a> and will abide by them.
          </label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
