<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Community Support Partners | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner5.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Support & Partnerships</h1>
    <p class="lead">Partner with IAOS Regina — strengthen community, visibility, and faith</p>
  </div>
</section>

<!-- ================= WHY PARTNER ================= -->
<section class="about-section py-5 text-white">
  <div class="container-xl">
    <div class="mb-5">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3"> Why Partner With Us?</h3>
      <ul class="fs-5">
        <li>Reach hundreds of members and their families</li>
        <li>Increase your brand’s visibility</li>
        <li>Build goodwill and community trust</li>
      </ul>
    </div>

    <div class="mb-5">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3"> Supporting Local Businesses — Exclusive Member Discounts</h3>
      <p>We are proud to partner with trusted local businesses to support our community. As a paid member, you can enjoy special discounts and offers when you shop or use services from our supporting partners.</p>
      <ul>
        <li>Save money</li>
        <li>Support the local Muslim community</li>
        <li>Help local businesses grow</li>
      </ul>
    </div>

    <div class="mb-5">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3">For Mosque Members</h3>
      <p class="mb-4">
        View the discount percentage offered by each supporting business.  
        Show your membership card or number to claim your discount.  
        Discounts are available in-store, on mobile, and on the website.  
        <strong>📌 Only paid members of IAOS Regina are eligible for these offers.</strong>
      </p>

      <!-- Discount Table -->
      <div class="table-responsive">
        <table class="table table-bordered table-striped bg-white text-dark align-middle">
          <thead class="table-success text-center">
            <tr>
              <th>Business Name</th>
              <th>Category</th>
              <th>Discount</th>
              <th>Offer Details</th>
              <th>Location</th>
              <th>Contact</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>Example Store</td>
              <td>Restaurant</td>
              <td>10% OFF</td>
              <td>Dine-in only</td>
              <td>Regina</td>
              <td>306-xxx-xxxx</td>
            </tr>
            <tr>
              <td>Example Service</td>
              <td>Auto Repair</td>
              <td>15% OFF</td>
              <td>On all services</td>
              <td>Regina</td>
              <td>306-xxx-xxxx</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>

    <!-- ================= BUSINESS FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm text-dark">
      <h3 class="fw-bold text-success mb-3">Business Registration Form</h3>
      <p class="mb-4">Would you like to support the community and grow your business? When you register as a Supporting Business, your promotion will be displayed:</p>
      <ul>
        <li>On Mosque TV screens</li>
        <li>On our Mobile App / Website</li>
        <li>To all IAOS Regina members</li>
      </ul>

      <hr>

      <form>
        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Business Name *</label>
            <input type="text" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Contact Person *</label>
            <input type="text" class="form-control" required>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Phone Number *</label>
            <input type="text" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Email *</label>
            <input type="email" class="form-control" required>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Business Category *</label>
            <input type="text" class="form-control" placeholder="e.g. Restaurant, Retail, Service…" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Address *</label>
            <input type="text" class="form-control" required>
          </div>
        </div>

        <div class="mb-3">
          <label>Website or Social Media Link</label>
          <input type="text" class="form-control">
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Discount Offer *</label>
            <input type="text" class="form-control" placeholder="e.g. 10% off, Buy 1 Get 1" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Special Conditions (optional)</label>
            <input type="text" class="form-control">
          </div>
        </div>

        <p class="mt-3 small text-muted">✅ All businesses must be approved and registered with IAOS Regina before appearing on our website and TV.</p>

        <div class="text-center mt-4">
          <button type="submit" class="btn btn-success px-5 py-2">
            <i class="bi bi-send-fill me-2"></i>Submit Registration Form
          </button>
        </div>
      </form>
    </div>
  </div>
</section>

<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
