<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$status = "";
$debug  = "";

if($_SERVER['REQUEST_METHOD'] === 'POST'){

    $to = trim($_POST['to'] ?? '');

    if(!filter_var($to, FILTER_VALIDATE_EMAIL)){
        $status = "❌ Invalid email address.";
    } else {

        $fromEmail = "testuser@iaosregina.com";  // ✅ your domain email
        $fromName  = "IAOS Regina";

        $subject = "✅ IAOS Regina Email Test (" . date("Y-m-d H:i:s") . ")";
        
        $body = "Hello!\n\n";
        $body .= "This is a test email sent from your hosting using PHP mail().\n";
        $body .= "If you receive it in Gmail, your email sending is working ✅\n\n";
        $body .= "Time: " . date("Y-m-d H:i:s") . "\n";
        $body .= "Regards,\nIAOS Regina\n";

        // ✅ Important headers
        $headers  = "From: {$fromName} <{$fromEmail}>\r\n";
        $headers .= "Reply-To: {$fromEmail}\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";

        $sent = mail($to, $subject, $body, $headers);

        if($sent){
            $status = "✅ Email Sent Successfully to: <b>" . htmlspecialchars($to) . "</b>";
        } else {
            $status = "❌ Email Failed. Your server mail() is not working.";
        }

        // Small debug
        $debug = "From: {$fromEmail}\nTo: {$to}\nSubject: {$subject}\n";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>IAOS Regina SMTP Test</title>
    <style>
        body{font-family:Arial;background:#f4f6f8;padding:30px;}
        .box{max-width:600px;margin:auto;background:#fff;padding:20px;border-radius:10px;box-shadow:0 5px 15px rgba(0,0,0,0.08);}
        input,button{width:100%;padding:12px;margin-top:10px;border-radius:8px;border:1px solid #ddd;}
        button{background:#0b7b4c;color:#fff;font-weight:bold;border:none;cursor:pointer;}
        button:hover{background:#09653e;}
        .status{margin-top:15px;padding:12px;border-radius:8px;}
        .ok{background:#d1f7d6;color:#0f5132;}
        .bad{background:#f8d7da;color:#842029;}
        pre{background:#f0f0f0;padding:12px;border-radius:8px;white-space:pre-wrap;}
    </style>
</head>
<body>

<div class="box">
    <h2>IAOS Regina Email Test (cPanel mail())</h2>

    <form method="POST">
        <label><b>Send To Email</b></label>
        <input type="email" name="to" placeholder="example@gmail.com" required>
        <button type="submit">Send Test Email</button>
    </form>

    <?php if($status): ?>
        <div class="status <?= (strpos($status,'✅') !== false ? 'ok' : 'bad') ?>">
            <?= $status ?>
        </div>
        <h4>Debug</h4>
        <pre><?= htmlspecialchars($debug) ?></pre>
    <?php endif; ?>

    <hr>
    <p><b>✅ Note:</b> Your email <b>testuser@iaosregina.com</b> can be opened inside Gmail, but Gmail is NOT your SMTP.</p>
</div>

</body>
</html>
