<?php
ob_start();
require_once "db.php"; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Book Appointment with Imam | IAOS</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {background:linear-gradient(135deg,#052c07,#0f5132);min-height:100vh;font-family:'Segoe UI',sans-serif;display:flex;justify-content:center;align-items:center;}
    .card {width:100%;max-width:720px;border-radius:18px;overflow:hidden;}
    .card-header {background:#198754;color:#fff;text-align:center;}
    .form-control,.form-select {border-radius:10px;}
  </style>
</head>

<body>
<div class="card shadow-lg">
  <div class="card-header py-4">
    <h4><i class="bi bi-calendar-check me-2"></i> Book Appointment with Imam</h4>
    <small>Submit your appointment request</small>
  </div>

  <div class="card-body bg-dark text-light p-4">
    <div id="responseMessage"></div>

    <form id="appointmentForm" autocomplete="off">
      <div class="mb-3">
        <label class="form-label"><i class="bi bi-person-fill me-1"></i> Full Name</label>
        <input type="text" name="full_name" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label"><i class="bi bi-envelope-fill me-1"></i> Email</label>
        <input type="email" name="email" class="form-control">
      </div>

      <div class="mb-3">
        <label class="form-label"><i class="bi bi-telephone-fill me-1"></i> Phone</label>
        <input type="text" name="phone" class="form-control">
      </div>

      <div class="mb-3">
        <label class="form-label"><i class="bi bi-bookmark-star-fill me-1"></i> Topic</label>
        <input type="text" name="topic" class="form-control" placeholder="e.g. Marriage counselling, Fiqh question..." required>
      </div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label"><i class="bi bi-calendar-date-fill me-1"></i> Date</label>
          <input type="date" name="appointment_date" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label"><i class="bi bi-clock-fill me-1"></i> Time</label>
          <input type="time" name="appointment_time" class="form-control" required>
        </div>
      </div>

      <div class="mb-3">
        <label class="form-label"><i class="bi bi-chat-text-fill me-1"></i> Notes (optional)</label>
        <textarea name="notes" rows="3" class="form-control"></textarea>
      </div>

      <button type="submit" class="btn btn-success w-100 py-2 fs-5" id="submitBtn">
        <i class="bi bi-send-fill me-1"></i> Submit Appointment
      </button>
    </form>
  </div>

  <div class="card-footer bg-success text-center text-white py-2">
    <small>© <?= date('Y') ?> IAOS — All Rights Reserved</small>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// ✅ AJAX Form Submit
document.getElementById("appointmentForm").addEventListener("submit", function(e){
  e.preventDefault();
  const form = this;
  const btn = document.getElementById("submitBtn");
  btn.disabled = true;
  btn.innerHTML = '<i class="bi bi-hourglass-split"></i> Booking...';

  fetch("ajax_book_appointment.php", {
    method: "POST",
    body: new FormData(form)
  })
  .then(res => res.json())
  .then(data => {
    if(data.status === "success"){
      form.reset();
      document.getElementById("responseMessage").innerHTML = 
        '<div class="alert alert-success text-center">'+data.message+'</div>';
    } else {
      document.getElementById("responseMessage").innerHTML = 
        '<div class="alert alert-danger text-center">'+data.message+'</div>';
    }
    btn.disabled = false;
    btn.innerHTML = '<i class="bi bi-send-fill me-1"></i> Submit Appointment';
  })
  .catch(err => {
    console.error(err);
    document.getElementById("responseMessage").innerHTML =
      '<div class="alert alert-danger text-center">Something went wrong.</div>';
    btn.disabled = false;
    btn.innerHTML = '<i class="bi bi-send-fill me-1"></i> Submit Appointment';
  });
});
</script>
</body>
</html>
