<?php 
ob_start();
include "layout.php"; 

session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK: Allow only admin OR newsletterController (C is capital)
if (!isset($_SESSION['role']) ||
    (strtolower($_SESSION['role']) !== 'admin' && $_SESSION['role'] !== 'newsletterController')) {
  header("Location: index.php");
  exit;
}

?>

<div class="container-fluid" style="margin-top:50px;">
  <h3 class="mb-4"><i class="bi bi-grid-fill"></i> Dashboard Overview</h3>

  <div class="row quick-links">

    <?php if ($role === 'imamController'): ?>
      <!-- ðŸ‘³ Imam Controller: show ONLY this card -->
      <div class="col-md-4 mb-4">
        <a href="imam_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-person-vcard-fill display-5 text-success"></i>
            <h5 class="mt-3 text-white">Imam Controller</h5>
            <p class="text-white-50 mb-0">Review and answer community questions</p>
          </div>
        </a>
      </div>

    <?php else: ?>
      <!-- ðŸ‘‘ All other roles (Admin included) -->
      
      <!-- Salah Controller -->
      <div class="col-md-4 mb-4">
        <a href="edit_salah.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-moon-stars-fill display-5 text-warning"></i>
            <h5 class="mt-3 text-white">Salah Timings</h5>
            <p class="text-white-50 mb-0">Update and manage daily prayer schedules</p>
          </div>
        </a>
      </div>

      <!-- Add User (Admin only) -->
      <?php if ($role === 'admin'): ?>
      <div class="col-md-4 mb-4">
        <a href="user_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-person-lines-fill display-5 text-info"></i>
            <h5 class="mt-3 text-white">User Management</h5>
            <p class="text-white-50 mb-0">Add, edit, and manage system users</p>
          </div>
        </a>
      </div>
      <?php endif; ?>

      <!-- Event Controller -->
      <div class="col-md-4 mb-4">
        <a href="event_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-calendar2-event-fill display-5 text-success"></i>
            <h5 class="mt-3 text-white">Event Controller</h5>
            <p class="text-white-50 mb-0">Create and organize community events</p>
          </div>
        </a>
      </div>

      <!-- Finance Controller -->
      <div class="col-md-4 mb-4">
        <a href="finance_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-currency-exchange display-5 text-warning"></i>
            <h5 class="mt-3 text-white">Finance Controller</h5>
            <p class="text-white-50 mb-0">Track donations, payments, and budgets</p>
          </div>
        </a>
      </div>

      <!-- Member Controller -->
      <div class="col-md-4 mb-4">
        <a href="members_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-people-fill display-5 text-primary"></i>
            <h5 class="mt-3 text-white">Member Controller</h5>
            <p class="text-white-50 mb-0">Manage members and volunteer records</p>
          </div>
        </a>
      </div>

      <!-- Imam Controller (visible to Admin as well) -->
      <div class="col-md-4 mb-4">
        <a href="imam_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-person-vcard-fill display-5 text-success"></i>
            <h5 class="mt-3 text-white">Imam Controller</h5>
            <p class="text-white-50 mb-0">Review and answer community questions</p>
          </div>
        </a>
      </div>

      <!-- Education Controller -->
      <div class="col-md-4 mb-4">
        <a href="education_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-mortarboard-fill display-5 text-info"></i>
            <h5 class="mt-3 text-white">Education Controller</h5>
            <p class="text-white-50 mb-0">Manage programs, courses, and pricing</p>
          </div>
        </a>
      </div>

      <!-- Student Registration -->
      <div class="col-md-4 mb-4">
        <a href="student_registration.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-person-lines-fill display-5 text-warning"></i>
            <h5 class="mt-3 text-white">Student Registration</h5>
            <p class="text-white-50 mb-0">Enroll students and track their payments</p>
          </div>
        </a>
      </div>

      <!-- Donation Controller -->
      <div class="col-md-4 mb-4">
        <a href="donation_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-heart-fill display-5 text-danger"></i>
            <h5 class="mt-3 text-white">Donation Controller</h5>
            <p class="text-white-50 mb-0">Monitor and manage Zakat & Sadaqah donations</p>
          </div>
        </a>
      </div>

      <!-- Website Editor -->
      <div class="col-md-4 mb-4">
        <a href="web/admin_pannel/manage_menu.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-brush-fill display-5 text-danger"></i>
            <h5 class="mt-3 text-white">Website Editor</h5>
            <p class="text-white-50 mb-0">Edit homepage, banners, and announcements</p>
          </div>
        </a>
      </div>

      <!-- Ads Controller -->
      <div class="col-md-4 mb-4">
        <a href="#" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-megaphone-fill display-5 text-info"></i>
            <h5 class="mt-3 text-white">Ads Controller</h5>
            <p class="text-white-50 mb-0">Manage sponsor banners and ad placements</p>
          </div>
        </a>
      </div>

      <!-- Services Controller -->
      <div class="col-md-4 mb-4">
        <a href="services_controller.php" class="text-decoration-none text-white">
          <div class="card p-4 text-center">
            <i class="bi bi-tools display-5 text-light"></i>
            <h5 class="mt-3 text-white">Services Controller</h5>
            <p class="text-white-50 mb-0">Handle mosque services and operations</p>
          </div>
        </a>
      </div>

    <?php endif; ?>
  </div>
</div>

</div></body></html>
