<?php
ob_start();
include "layout.php";
require_once "db.php";

session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK: Allow only admin OR newsletterController (C is capital)
if (!isset($_SESSION['role']) ||
    (strtolower($_SESSION['role']) !== 'admin')) {
  header("Location: index.php");
  exit;
}

$pdo = get_db();

// ✅ Add or Update Program
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $name = trim($_POST['program_name']);
    $desc = trim($_POST['short_description']);
    $weekly = (float)$_POST['amount_weekly'];
    $monthly = (float)$_POST['amount_monthly'];

    if ($id) {
        // Update
        $stmt = $pdo->prepare("UPDATE education_programs SET program_name=?, short_description=?, amount_weekly=?, amount_monthly=? WHERE id=?");
        $stmt->execute([$name, $desc, $weekly, $monthly, $id]);
        $msg = "<div class='alert alert-success mt-3'>✅ Program updated successfully!</div>";
    } else {
        // Insert
        $stmt = $pdo->prepare("INSERT INTO education_programs (program_name, short_description, amount_weekly, amount_monthly) VALUES (?, ?, ?, ?)");
        $stmt->execute([$name, $desc, $weekly, $monthly]);
        $msg = "<div class='alert alert-success mt-3'>✅ New program added successfully!</div>";
    }
}

// ✅ Delete Program
if (isset($_GET['delete'])) {
    $stmt = $pdo->prepare("DELETE FROM education_programs WHERE id=?");
    $stmt->execute([$_GET['delete']]);
    $msg = "<div class='alert alert-danger mt-3'>🗑️ Program deleted successfully!</div>";
}

// ✅ Fetch all programs
$programs = $pdo->query("SELECT * FROM education_programs ORDER BY created_at DESC")->fetchAll();
?>

<div class="container-fluid mt-5">
  <h3><i class="bi bi-mortarboard-fill"></i> Education Controller – Manage Programs</h3>
  <?= $msg ?? '' ?>

  <!-- ✅ Add / Update Program Form -->
  <div class="card mt-3 p-4 shadow-sm">
    <h5 class="text-white"><i class="bi bi-plus-circle-fill text-success"></i> Add / Update Program</h5>
    <form method="post" id="programForm" class="row g-3">
      <input type="hidden" name="id" id="programId">
      <div class="col-md-4">
        <label class="form-label text-white">Program Name</label>
        <input type="text" class="form-control" name="program_name" id="programName" required>
      </div>
      <div class="col-md-8">
        <label class="form-label">Short Description</label>
        <input type="text" class="form-control" name="short_description" id="shortDescription">
      </div>
      <div class="col-md-3">
        <label class="form-label text-white">Weekly Amount (CAD)</label>
        <input type="number" step="0.01" class="form-control" name="amount_weekly" id="amountWeekly" required>
      </div>
      <div class="col-md-3">
        <label class="form-label text-white">Monthly Amount (CAD)</label>
        <input type="number" step="0.01" class="form-control" name="amount_monthly" id="amountMonthly" required>
      </div>
      <div class="col-md-12 text-end mt-3">
        <button class="btn btn-success"><i class="bi bi-save-fill"></i> Save Program</button>
        <button type="reset" class="btn btn-secondary"><i class="bi bi-arrow-repeat"></i> Reset</button>
      </div>
    </form>
  </div>

  <!-- ✅ Program List -->
  <div class="row mt-4">
    <?php if ($programs): ?>
      <?php foreach ($programs as $p): ?>
      <div class="col-md-4 mb-4">
        <div class="card h-100 shadow-sm border-success">
          <div class="card-body">
            <h5 class="card-title text-warning"><i class="bi bi-book-fill"></i> <?= htmlspecialchars($p['program_name']) ?></h5>
            <p class="card-text text-white"><?= nl2br(htmlspecialchars($p['short_description'])) ?></p>
            <p class="text-danger"><b>Weekly:</b> CAD <?= number_format($p['amount_weekly'], 2) ?><br>
               <b>Monthly:</b> CAD <?= number_format($p['amount_monthly'], 2) ?></p>
          </div>
          <div class="card-footer bg-light text-end">
            <button class="btn btn-sm btn-warning" onclick="editProgram(<?= $p['id'] ?>, '<?= htmlspecialchars(addslashes($p['program_name'])) ?>', '<?= htmlspecialchars(addslashes($p['short_description'])) ?>', <?= $p['amount_weekly'] ?>, <?= $p['amount_monthly'] ?>)">
              <i class="bi bi-pencil-square"></i> Edit
            </button>
            <a href="?delete=<?= $p['id'] ?>" onclick="return confirm('Are you sure you want to delete this program?')" class="btn btn-sm btn-danger">
              <i class="bi bi-trash-fill"></i> Delete
            </a>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p class="text-center mt-4 text-muted">No programs added yet.</p>
    <?php endif; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function editProgram(id, name, desc, weekly, monthly) {
  document.getElementById('programId').value = id;
  document.getElementById('programName').value = name;
  document.getElementById('shortDescription').value = desc;
  document.getElementById('amountWeekly').value = weekly;
  document.getElementById('amountMonthly').value = monthly;
  window.scrollTo({top:0, behavior:'smooth'});
}
</script>
