<?php
ob_start();
include "layout.php";
require_once "db.php";

session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK: Allow only admin OR newsletterController (C is capital)
if (!isset($_SESSION['role']) ||
    (strtolower($_SESSION['role']) !== 'admin')) {
  header("Location: index.php");
  exit;
}

$pdo = get_db();
$filterMonth   = $_GET['month'] ?? '';
$filterCategory = $_GET['category'] ?? '';

// --- Handle Add Expense ---
$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['add_expense'])) {
  $name = trim($_POST['expense_name']);
  $category = trim($_POST['category']);
  $desc = trim($_POST['description']);
  $amount = (float)$_POST['amount'];
  $date = $_POST['expense_date'];

  $stmt = $pdo->prepare("INSERT INTO expenses (expense_name, category, description, amount, expense_date)
                         VALUES (?, ?, ?, ?, ?)");
  $stmt->execute([$name,$category,$desc,$amount,$date]);
  $message = "âœ… Expense added successfully!";
}

// --- Handle Edit Expense ---
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['edit_expense'])) {
  $id = (int)$_POST['id'];
  $name = trim($_POST['expense_name']);
  $category = trim($_POST['category']);
  $desc = trim($_POST['description']);
  $amount = (float)$_POST['amount'];
  $date = $_POST['expense_date'];

  $stmt = $pdo->prepare("UPDATE expenses SET expense_name=?,category=?,description=?,amount=?,expense_date=? WHERE id=?");
  $stmt->execute([$name,$category,$desc,$amount,$date,$id]);
  $message = "âœ… Expense updated successfully!";
}

// --- Handle Delete Expense ---
if (isset($_GET['delete'])) {
  $id = (int)$_GET['delete'];
  $pdo->prepare("DELETE FROM expenses WHERE id=?")->execute([$id]);
  header("Location: expense_controller.php?status=deleted");
  exit;
}

// --- Fetch Categories ---
$cats = $pdo->query("SELECT DISTINCT category FROM expenses ORDER BY category")->fetchAll(PDO::FETCH_COLUMN);

// --- Build Filter Query ---
$where = "WHERE 1=1";
$params = [];
if ($filterMonth) { $where .= " AND DATE_FORMAT(expense_date,'%Y-%m')=?"; $params[] = $filterMonth; }
if ($filterCategory) { $where .= " AND category=?"; $params[] = $filterCategory; }

$stmt = $pdo->prepare("SELECT * FROM expenses $where ORDER BY expense_date DESC");
$stmt->execute($params);
$expenses = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Expense Controller</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#064635;color:white;padding:20px;font-family:sans-serif;}
.card{background:rgba(255,255,255,0.1);border:none;border-radius:15px;padding:20px;}
.table td,.table th{vertical-align:middle;color:white;}
</style>
</head>
<body>
<div class="container-fluid" style="margin-top:50px;">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3><i class="bi bi-receipt-cutoff"></i> Expense Controller</h3>
    <a href="finance_controller.php" class="btn btn-light"><i class="bi bi-arrow-left"></i> Back to Finance</a>
  </div>

  <?php if($message): ?><div class="alert alert-info"><?= $message ?></div><?php endif; ?>
  <?php if(isset($_GET['status']) && $_GET['status']=='deleted'): ?><div class="alert alert-success">ðŸ—‘ Expense deleted successfully.</div><?php endif; ?>

  <!-- ADD EXPENSE FORM -->
  <div class="card mb-4">
    <h5><i class="bi bi-plus-circle"></i> Add New Expense</h5>
    <form method="POST" class="row g-2">
      <div class="col-md-3"><input type="text" name="expense_name" class="form-control" placeholder="Expense Name" required></div>
      <div class="col-md-2"><input type="text" name="category" class="form-control" placeholder="Category" required></div>
      <div class="col-md-2"><input type="number" step="0.01" name="amount" class="form-control" placeholder="Amount (CAD)" required></div>
      <div class="col-md-2"><input type="date" name="expense_date" class="form-control" value="<?= date('Y-m-d') ?>"></div>
      <div class="col-md-2"><input type="text" name="description" class="form-control" placeholder="Notes"></div>
      <div class="col-md-1"><button class="btn btn-success w-100" name="add_expense"><i class="bi bi-save"></i></button></div>
    </form>
  </div>

  <!-- FILTERS -->
  <div class="card mb-4">
    <form method="GET" class="row align-items-end">
      <div class="col-md-3">
        <label>Filter by Month</label>
        <input type="month" name="month" value="<?= htmlspecialchars($filterMonth) ?>" class="form-control">
      </div>
      <div class="col-md-3">
        <label>Category</label>
        <select name="category" class="form-select">
          <option value="">All</option>
          <?php foreach($cats as $c): ?>
            <option value="<?= htmlspecialchars($c) ?>" <?= $c==$filterCategory?'selected':'' ?>><?= htmlspecialchars($c) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <button class="btn btn-light mt-3"><i class="bi bi-search"></i> Filter</button>
      </div>
    </form>
  </div>

  <!-- EXPENSE TABLE -->
  <div class="card">
    <h5><i class="bi bi-table"></i> Expense Records</h5>
    <?php if($expenses): ?>
      <div class="table-responsive">
        <table class="table table-striped text-center align-middle">
          <thead class="table-dark">
            <tr><th>Date</th><th>Name</th><th>Category</th><th>Description</th><th>Amount (CAD)</th><th>Actions</th></tr>
          </thead>
          <tbody>
            <?php foreach($expenses as $e): ?>
              <tr>
                <form method="POST">
                  <td><input type="date" name="expense_date" class="form-control text-dark bg-light border-0 text-center" value="<?= $e['expense_date'] ?>"></td>
                  <td><input type="text" name="expense_name" class="form-control text-dark bg-light border-0 text-center" value="<?= htmlspecialchars($e['expense_name']) ?>"></td>
                  <td><input type="text" name="category" class="form-control text-dark bg-light border-0 text-center" value="<?= htmlspecialchars($e['category']) ?>"></td>
                  <td><input type="text" name="description" class="form-control text-dark bg-light border-0 text-center" value="<?= htmlspecialchars($e['description']) ?>"></td>
                  <td><input type="number" step="0.01" name="amount" class="form-control text-dark bg-light border-0 text-center" value="<?= htmlspecialchars($e['amount']) ?>"></td>
                  <td>
                    <input type="hidden" name="id" value="<?= $e['id'] ?>">
                    <button class="btn btn-warning btn-sm" name="edit_expense"><i class="bi bi-pencil"></i></button>
                    <a href="?delete=<?= $e['id'] ?>" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="bi bi-trash"></i></a>
                  </td>
                </form>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php else: ?>
      <p class="text-center text-light mb-0">No expenses found for the selected filters.</p>
    <?php endif; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
