<?php
ob_start();
require_once "db.php";

$pdo = get_db();
$questionId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$stmt = $pdo->prepare("SELECT * FROM imam_chat WHERE question_id=? ORDER BY created_at ASC");
$stmt->execute([$questionId]);
$messages = $stmt->fetchAll();

if (!$messages) {
    echo "<p class='text-center text-secondary mt-3'>No messages yet. Start the conversation below.</p>";
    exit;
}

foreach ($messages as $msg) {
    $class = $msg['sender'] === 'imam' ? 'msg-imam' : 'msg-user';
    $icon  = $msg['sender'] === 'imam' ? '<i class="bi bi-person-fill text-warning"></i> Imam' : '<i class="bi bi-person-fill"></i> You';
    echo "<div class='$class'><small>$icon</small><br>" . nl2br(htmlspecialchars($msg['message'])) . "</div>";
}
?>
