<?php
ob_start();
include "layout.php";
require_once "db.php";

session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK: Allow only admin OR newsletterController (C is capital)
if (!isset($_SESSION['role']) ||
    (strtolower($_SESSION['role']) !== 'admin')) {
  header("Location: index.php");
  exit;
}
$pdo = get_db();
$message = "";

// --------------- ADD NEW MEMBER ---------------
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST['action'] === 'add') {
    $first = trim($_POST['first_name']);
    $last = trim($_POST['last_name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']);
    $type = $_POST['member_type'];
    $amount = (float)$_POST['membership_amount'];
    $perks = trim($_POST['perks']);
    $can_vote = isset($_POST['can_vote']) ? 1 : 0;

    try {
        $stmt = $pdo->prepare("INSERT INTO members 
            (first_name, last_name, email, phone, address, member_type, membership_amount, perks, can_vote)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$first, $last, $email, $phone, $address, $type, $amount, $perks, $can_vote]);
        $message = "✅ Member added successfully!";
    } catch (PDOException $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}

// --------------- UPDATE MEMBERS ---------------
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST['action'] === 'update') {
    for ($i = 0; $i < count($_POST['id']); $i++) {
        $id = $_POST['id'][$i];
        $first = $_POST['first_name'][$i];
        $last = $_POST['last_name'][$i];
        $email = $_POST['email'][$i];
        $phone = $_POST['phone'][$i];
        $address = $_POST['address'][$i];
        $type = $_POST['member_type'][$i];
        $amount = (float)$_POST['membership_amount'][$i];
        $perks = $_POST['perks'][$i];
        $vote = isset($_POST['can_vote'][$i]) ? 1 : 0;
        $status = $_POST['status'][$i];

        $stmt = $pdo->prepare("UPDATE members SET 
            first_name=?, last_name=?, email=?, phone=?, address=?, 
            member_type=?, membership_amount=?, perks=?, can_vote=?, status=? 
            WHERE id=?");
        $stmt->execute([$first, $last, $email, $phone, $address, $type, $amount, $perks, $vote, $status, $id]);
    }
    header("Location: members_controller.php?status=success");
    exit;
}

// --------------- DELETE MEMBER ---------------
if (isset($_POST['delete_id']) && is_numeric($_POST['delete_id'])) {
    $deleteId = (int)$_POST['delete_id'];
    $pdo->prepare("DELETE FROM members WHERE id=?")->execute([$deleteId]);
    header("Location: members_controller.php?deleted=1");
    exit;
}

// --------------- FETCH MEMBERS ---------------
$stmt = $pdo->query("SELECT * FROM members ORDER BY id DESC");
$members = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Members Controller</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
body { background:#064635; color:white; padding:20px; font-family:sans-serif; }
.card { background:rgba(255,255,255,0.1); border:none; border-radius:15px; padding:20px; }
.form-control, .form-select { background:rgba(255,255,255,0.9); color:black; border:none; text-align:center; }
.btn-light { color:#064635; font-weight:600; }
.btn-warning { background:#f4c542; border:none; color:#064635; font-weight:600; }
</style>
</head>
<body>

<div class="container-fluid" style="margin-top:50px;">
  <h3 class="mb-4 text-white"><i class="bi bi-people"></i> Members Controller</h3>

  <?php if(isset($_GET['status']) && $_GET['status']=='success'): ?>
    <div class="alert alert-success">✅ Members updated successfully!</div>
  <?php elseif(isset($_GET['deleted'])): ?>
    <div class="alert alert-info">🗑️ Member deleted successfully!</div>
  <?php elseif($message): ?>
    <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>

  <!-- ADD MEMBER -->
  <div class="card mb-4">
    <h5 class="text-white"><i class="bi bi-person-plus"></i> Add New Member</h5>
    <form method="POST">
      <input type="hidden" name="action" value="add">
      <div class="row mb-2">
        <div class="col-md-3"><input class="form-control" name="first_name" placeholder="First Name" required></div>
        <div class="col-md-3"><input class="form-control" name="last_name" placeholder="Last Name" required></div>
        <div class="col-md-3"><input class="form-control" name="email" placeholder="Email" required></div>
        <div class="col-md-3"><input class="form-control" name="phone" placeholder="Phone"></div>
      </div>
      <div class="row mb-2">
        <div class="col-md-4"><input class="form-control" name="address" placeholder="Address"></div>
        <div class="col-md-2">
          <select name="member_type" class="form-select">
            <option value="paid">Paid</option>
            <option value="free">Free</option>
            <option value="volunteer">Volunteer</option>
          </select>
        </div>
        <div class="col-md-2"><input type="number" step="0.01" class="form-control" name="membership_amount" placeholder="Amount (CAD)"></div>
        <div class="col-md-3"><input class="form-control" name="perks" placeholder="Perks"></div>
        <div class="col-md-1 text-center">
          <label class="form-check-label small text-white">Can Vote</label>
          <input type="checkbox" name="can_vote" class="form-check-input mt-2">
        </div>
      </div>
      <button class="btn btn-light w-100"><i class="bi bi-check2-circle"></i> Add Member</button>
    </form>
  </div>

  <!-- EDIT MEMBERS -->
  <div class="card p-3 shadow">
    <form method="POST">
      <input type="hidden" name="action" value="update">
      <div class="table-responsive">
        <table class="table table-striped text-center align-middle">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>First</th>
              <th>Last</th>
              <th>Email</th>
              <th>Phone</th>
              <th>Address</th>
              <th>Type</th>
              <th>Amount</th>
              <th>Perks</th>
              <th>Vote</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($members as $m): ?>
              <tr>
                <td><?= htmlspecialchars($m['id']) ?></td>
                <td><input class="form-control text-dark" name="first_name[]" value="<?= htmlspecialchars($m['first_name']) ?>" style="width:100%;"></td>
                <td><input class="form-control text-dark" name="last_name[]" value="<?= htmlspecialchars($m['last_name']) ?>" style="width:100%;"></td>
                <td><input class="form-control text-dark" name="email[]" value="<?= htmlspecialchars($m['email']) ?>" style="width:100%;"></td>
                <td><input class="form-control text-dark" name="phone[]" value="<?= htmlspecialchars($m['phone']) ?>" style="width:100%;"></td>
                <td><input class="form-control text-dark" name="address[]" value="<?= htmlspecialchars($m['address']) ?>" style="width:100%;"></td>
                <td>
                  <select name="member_type[]" class="form-select" style="width:100%;">
                    <option value="paid" <?= $m['member_type']=='paid'?'selected':'' ?>>Paid</option>
                    <option value="free" <?= $m['member_type']=='free'?'selected':'' ?>>Free</option>
                    <option value="volunteer" <?= $m['member_type']=='volunteer'?'selected':'' ?>>Volunteer</option>
                  </select>
                </td>
                <td><input type="number" step="0.01" class="form-control text-dark" name="membership_amount[]" value="<?= htmlspecialchars($m['membership_amount']) ?>" style="width:100%;"></td>
                <td><input class="form-control text-dark" name="perks[]" value="<?= htmlspecialchars($m['perks']) ?>" style="width:100%;"></td>
                <td><input type="checkbox" name="can_vote[<?= $m['id'] ?>]" <?= $m['can_vote']?'checked':'' ?> style="width:100%;"></td>
                <td>
                  <select name="status[]" class="form-select" style="width:100%;">
                    <option value="active" <?= $m['status']=='active'?'selected':'' ?>>Active</option>
                    <option value="inactive" <?= $m['status']=='inactive'?'selected':'' ?>>Inactive</option>
                  </select>
                </td>
                <td>
                  <button type="button" class="btn btn-danger btn-sm delete-btn" data-id="<?= $m['id'] ?>" data-name="<?= htmlspecialchars($m['first_name'].' '.$m['last_name']) ?>">
                    <i class="bi bi-trash"></i>
                  </button>
                </td>
                <input type="hidden" name="id[]" value="<?= htmlspecialchars($m['id']) ?>">
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="text-end">
        <button class="btn btn-warning mt-3"><i class="bi bi-save"></i> Save Changes</button>
      </div>
    </form>
  </div>
</div>

<!-- Hidden Delete Form -->
<form method="POST" id="deleteForm" style="display:none;">
  <input type="hidden" name="delete_id" id="delete_id">
</form>

<script>
document.querySelectorAll(".delete-btn").forEach(btn => {
  btn.addEventListener("click", function() {
    const id = this.dataset.id;
    const name = this.dataset.name;
    Swal.fire({
      title: `Delete member "${name}"?`,
      text: "This action cannot be undone!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6",
      confirmButtonText: "Yes, delete it!",
      background: "#fff",
      color: "#064635"
    }).then((result) => {
      if (result.isConfirmed) {
        document.getElementById("delete_id").value = id;
        document.getElementById("deleteForm").submit();
      }
    });
  });
});
</script>

</body>
</html>
