<?php
ob_start();
session_start();
require_once "db.php";


session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK: Allow only admin OR newsletterController (C is capital)
if (!isset($_SESSION['role']) ||
    (strtolower($_SESSION['role']) !== 'admin')) {
  header("Location: index.php");
  exit;
}

$pdo = get_db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $count = count($_POST['id']);
    $updated = 0;

    for ($i = 0; $i < $count; $i++) {
        $stmt = $pdo->prepare("
            UPDATE users 
            SET full_name = ?, username = ?, email = ?, password = ?, role = ?, status = ? 
            WHERE id = ?
        ");
        $stmt->execute([
            $_POST['full_name'][$i],
            $_POST['username'][$i],
            $_POST['email'][$i],
            $_POST['password'][$i],
            $_POST['role'][$i],
            $_POST['status'][$i],
            $_POST['id'][$i]
        ]);
        if ($stmt->rowCount() > 0) $updated++;
    }

    header("Location: edit_users.php?status=success&count=$updated");
    exit;
} else {
    header("Location: edit_users.php?error=nodata");
    exit;
}
