<?php
ob_start();
require_once "db.php"; // adjust path if needed

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// Fetch header settings
$settings = $pdo->query("SELECT * FROM about_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// Fetch headings
$headings = $pdo->query("SELECT * FROM about_headings ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// Fetch paragraphs
$paras_stmt = $pdo->query("SELECT * FROM about_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($paras_stmt as $p) {
    $paras[$p['heading_id']][] = $p;
}

// Fetch members
$members = $pdo->query("SELECT * FROM about_members ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// Fetch mosques
$mosques = $pdo->query("SELECT * FROM mosque_locations ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage About Us | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a {
    color:#ccc; padding:12px 20px; display:block;
    text-decoration:none; border-bottom:1px solid #2f343a;
}
.admin-sidebar a:hover, .admin-sidebar a.active {
    background:#0d6efd; color:#fff;
}
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title {
    font-weight:700; font-size:1.3rem; margin-bottom:15px;
}
.card-img-top {
    width: 100%;
    height: 200px;
    object-fit: cover;
}
</style>

</head>
<body>

<div class="admin-wrapper">

    <?php include "sidebar.php"; ?>

    <div class="admin-content">

        <!-- ✅ Page Title -->
        <h3 class="mb-4">Manage About Us Page</h3>
        
        <!-- ✅ SUCCESS MESSAGE -->
        <?php if(isset($_GET['saved'])): ?>
            <div class="alert alert-success">✅ Changes saved successfully!</div>
        <?php endif; ?>

        <!-- ✅ PAGE HEADER SETTINGS -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">🖼️ Page Header</div>

            <form action="save_about.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="update_header">

                <label class="fw-bold mb-1">Page Title</label>
                <input type="text" name="page_title" value="<?= $settings['page_title'] ?>" class="form-control mb-3" required>

                <label class="fw-bold mb-1">Page Subtitle</label>
                <textarea name="page_subtitle" class="form-control mb-3" required><?= $settings['page_subtitle'] ?></textarea>

                <label class="fw-bold mb-1">Background Image</label>
                <input type="file" name="bg_image" class="form-control mb-3">

                <?php if (!empty($settings['bg_image'])): ?>
                    <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" class="rounded mt-2" style="max-width:200px;object-fit:cover;">
                <?php endif; ?>

                <button class="btn btn-primary mt-3">Save Header</button>
            </form>
        </div>


        <!-- ✅ ADD NEW HEADING -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">➕ Add New Heading</div>

            <form action="save_about.php" method="POST">
                <input type="hidden" name="action" value="add_heading">

                <label class="fw-bold mb-1">Heading Title</label>
                <input type="text" name="heading_text" class="form-control mb-3" required>

                <button class="btn btn-success">Add Heading</button>
            </form>
        </div>


        <!-- ✅ EXISTING HEADINGS + PARAGRAPHS -->
        <?php foreach ($headings as $h): ?>
            <div class="card p-4 shadow-sm mb-4 section-card">

                <div class="d-flex justify-content-between mb-3">
                    <div class="section-title">📘 <?= htmlspecialchars($h['heading_text']) ?></div>

                    <form action="save_about.php" method="POST"
                        onsubmit="return confirm('Delete this heading?');">
                        <input type="hidden" name="action" value="delete_heading">
                        <input type="hidden" name="id" value="<?= $h['id'] ?>">
                        <button class="btn btn-danger btn-sm"><i class="bi bi-trash"></i></button>
                    </form>
                </div>

                <!-- ✅ Add paragraph -->
                <form action="save_about.php" method="POST" class="mb-3">
                    <input type="hidden" name="action" value="add_paragraph">
                    <input type="hidden" name="heading_id" value="<?= $h['id'] ?>">
                    <textarea name="paragraph_text" class="form-control mb-2" placeholder="New paragraph..." required></textarea>
                    <button class="btn btn-secondary btn-sm">Add Paragraph</button>
                </form>

                <!-- ✅ List paragraphs -->
                <?php if (!empty($paras[$h['id']])): ?>
                    <?php foreach ($paras[$h['id']] as $p): ?>
                        <div class="bg-white border rounded p-3 mb-2">

                            <form action="save_about.php" method="POST">
                                <input type="hidden" name="action" value="update_paragraph">
                                <input type="hidden" name="id" value="<?= $p['id'] ?>">

                                <textarea name="paragraph_text" class="form-control mb-2" required><?= htmlspecialchars($p['paragraph_text']) ?></textarea>

                                <button class="btn btn-success btn-sm">Update</button>

                                <button formaction="save_about.php" name="action" value="delete_paragraph"
                                        class="btn btn-danger btn-sm float-end"
                                        onclick="return confirm('Delete this paragraph?');">
                                    Delete
                                </button>
                            </form>

                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>

            </div>
        <?php endforeach; ?>


        <!-- ✅ BOARD MEMBERS -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">👥 Board Members</div>

            <!-- Add member -->
            <form action="save_about.php" method="POST" enctype="multipart/form-data" class="mb-4">
                <input type="hidden" name="action" value="add_member">

                <div class="row">
                    <div class="col-md-4">
                        <label class="fw-bold mb-1">Name</label>
                        <input type="text" name="name" class="form-control mb-2" required>
                    </div>
                    <div class="col-md-4">
                        <label class="fw-bold mb-1">Role</label>
                        <input type="text" name="role" class="form-control mb-2">
                    </div>
                    <div class="col-md-4">
                        <label class="fw-bold mb-1">Email</label>
                        <input type="email" name="email" class="form-control mb-2">
                    </div>
                </div>

                <label class="fw-bold mb-1">Bio</label>
                <textarea name="bio" class="form-control mb-2"></textarea>

                <label class="fw-bold mb-1">Picture</label>
                <input type="file" name="image" class="form-control mb-3" required>

                <button class="btn btn-primary">Add Member</button>
            </form>

            <!-- List members -->
            <div class="row">
                <?php foreach ($members as $m): ?>
                    <div class="col-md-4">
                        <div class="card shadow-sm mb-3">

                            <?php if (!empty($m['image'])): ?>
                                <img src="../<?= htmlspecialchars($m['image']) ?>" 
                                     class="card-img-top">
                            <?php endif; ?>

                            <div class="card-body">
                                <form action="save_about.php" method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="action" value="update_member">
                                    <input type="hidden" name="id" value="<?= $m['id'] ?>">

                                    <input type="text" name="name" class="form-control mb-2" value="<?= htmlspecialchars($m['name']) ?>">
                                    <input type="text" name="role" class="form-control mb-2" value="<?= htmlspecialchars($m['role']) ?>">
                                    <input type="email" name="email" class="form-control mb-2" value="<?= htmlspecialchars($m['email']) ?>">
                                    <textarea name="bio" class="form-control mb-2"><?= htmlspecialchars($m['bio']) ?></textarea>

                                    <input type="file" name="image" class="form-control mb-2">

                                    <button class="btn btn-success btn-sm">Update</button>

                                    <button formaction="save_about.php"
                                            name="action" value="delete_member"
                                            onclick="return confirm('Delete member?')"
                                            class="btn btn-danger btn-sm float-end">
                                        Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

        </div>


        <!-- ✅ MOSQUE LOCATIONS -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">🕌 Mosque Locations</div>

            <form action="save_about.php" method="POST" class="mb-4">
                <input type="hidden" name="action" value="add_mosque">

                <div class="row">
                    <div class="col-md-4">
                        <label class="fw-bold">Mosque Name</label>
                        <input type="text" name="mosque_name" class="form-control mb-2" required>
                    </div>

                    <div class="col-md-4">
                        <label class="fw-bold">Address</label>
                        <input type="text" name="address" class="form-control mb-2" required>
                    </div>

                    <div class="col-md-4">
                        <label class="fw-bold">Map Embed URL</label>
                        <input type="text" name="map_embed" class="form-control mb-2" required>
                    </div>
                </div>

                <button class="btn btn-primary">Add Mosque</button>
            </form>

            <div class="row">
                <?php foreach ($mosques as $m): ?>
                    <div class="col-md-6">
                        <div class="card mb-3 p-3 shadow-sm">
                            <form action="save_about.php" method="POST">
                                <input type="hidden" name="action" value="update_mosque">
                                <input type="hidden" name="id" value="<?= $m['id'] ?>">

                                <label class="fw-bold">Mosque Name</label>
                                <input type="text" name="mosque_name" class="form-control mb-2" value="<?= htmlspecialchars($m['mosque_name']) ?>">

                                <label class="fw-bold">Address</label>
                                <input type="text" name="address" class="form-control mb-2" value="<?= htmlspecialchars($m['address']) ?>">

                                <label class="fw-bold">Map Embed URL</label>
                                <textarea name="map_embed" class="form-control mb-2"><?= htmlspecialchars($m['map_embed']) ?></textarea>

                                <button class="btn btn-success btn-sm">Update</button>

                                <button formaction="save_about.php"
                                        name="action" value="delete_mosque"
                                        class="btn btn-danger btn-sm float-end"
                                        onclick="return confirm('Delete mosque?')">
                                    Delete
                                </button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

        </div>

    </div>
</div>

</body>
</html>
