<?php
ob_start();
require_once "db.php";
session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}

$settings = $pdo->query("SELECT * FROM business_support_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if(!$settings){
  $pdo->exec("INSERT INTO business_support_settings (id,page_title,page_subtitle,why_title,form_title) VALUES (1,'Support & Partnerships','', 'Why Partner With Us?','Business Registration Form')");
  $settings = $pdo->query("SELECT * FROM business_support_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

$whyBullets = $pdo->query("SELECT * FROM business_support_why_bullets ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$promoBullets = $pdo->query("SELECT * FROM business_support_promo_bullets ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Business Support | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }

/* ✅ sidebar same style */
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a{
  color:#ccc; padding:12px 20px; display:block;
  text-decoration:none; border-bottom:1px solid #2f343a;
}
.admin-sidebar a:hover, .admin-sidebar a.active{ background:#0d6efd; color:#fff; }

.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Business Support Page</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>
    <?php if(isset($_GET['deleted'])): ?>
      <div class="alert alert-warning">🗑️ Deleted successfully!</div>
    <?php endif; ?>
    <?php if(isset($_GET['err'])): ?>
      <div class="alert alert-danger">❌ Something went wrong!</div>
    <?php endif; ?>

    <!-- ✅ PAGE HEADER + MAIN TEXTS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🧩 Page Settings</div>

      <form action="save_business_support.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="update_settings">

        <div class="row g-2">
          <div class="col-md-6">
            <label class="fw-bold mb-1">Page Title</label>
            <input type="text" name="page_title" class="form-control" value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>" required>
          </div>
          <div class="col-md-6">
            <label class="fw-bold mb-1">Page Subtitle</label>
            <input type="text" name="page_subtitle" class="form-control" value="<?= htmlspecialchars($settings['page_subtitle'] ?? '') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold mb-1">Why Partner Title</label>
            <input type="text" name="why_title" class="form-control" value="<?= htmlspecialchars($settings['why_title'] ?? '') ?>" required>
          </div>
          <div class="col-md-6">
            <label class="fw-bold mb-1">Form Title</label>
            <input type="text" name="form_title" class="form-control" value="<?= htmlspecialchars($settings['form_title'] ?? '') ?>" required>
          </div>

          <div class="col-md-12">
            <label class="fw-bold mb-1">Form Intro Text</label>
            <textarea name="form_intro" class="form-control" rows="3"><?= htmlspecialchars($settings['form_intro'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="fw-bold mb-1">Promo Title</label>
            <input type="text" name="promo_title" class="form-control" value="<?= htmlspecialchars($settings['promo_title'] ?? '') ?>">
          </div>

          <div class="col-md-6">
            <label class="fw-bold mb-1">Success Message (AJAX)</label>
            <input type="text" name="success_message" class="form-control" value="<?= htmlspecialchars($settings['success_message'] ?? '') ?>">
          </div>

          <div class="col-md-12">
            <label class="fw-bold mb-1">Note Text (under form)</label>
            <textarea name="note_text" class="form-control" rows="2"><?= htmlspecialchars($settings['note_text'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="fw-bold mb-1">Background Image</label>
            <input type="file" name="bg_image" class="form-control">
            <?php if(!empty($settings['bg_image'])): ?>
              <div class="mt-2">
                <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" style="max-width:240px;border-radius:10px;object-fit:cover;">
              </div>
            <?php endif; ?>
          </div>
        </div>

        <button class="btn btn-primary mt-3">Save Settings</button>
      </form>
    </div>

    <!-- ✅ WHY BULLETS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">✔ Why Partner Bullets</div>

      <form action="save_business_support.php" method="POST" class="row g-2 mb-3">
        <input type="hidden" name="action" value="add_why_bullet">
        <div class="col-md-8">
          <input type="text" name="bullet_text" class="form-control" placeholder="Bullet text..." required>
        </div>
        <div class="col-md-2">
          <input type="number" name="position" class="form-control" placeholder="Pos" value="0">
        </div>
        <div class="col-md-2">
          <button class="btn btn-primary w-100">Add</button>
        </div>
      </form>

      <?php foreach($whyBullets as $b): ?>
        <div class="border rounded p-3 mb-2 bg-white">
          <form action="save_business_support.php" method="POST" class="row g-2 align-items-center">
            <input type="hidden" name="action" value="update_why_bullet">
            <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">

            <div class="col-md-8">
              <input type="text" name="bullet_text" class="form-control" value="<?= htmlspecialchars($b['bullet_text']) ?>" required>
            </div>
            <div class="col-md-2">
              <input type="number" name="position" class="form-control" value="<?= (int)$b['position'] ?>">
            </div>
            <div class="col-md-2 d-flex gap-2">
              <button class="btn btn-success w-50">Update</button>
              <button formaction="save_business_support.php" name="action" value="delete_why_bullet"
                      class="btn btn-danger w-50" onclick="return confirm('Delete this bullet?');">
                Delete
              </button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- ✅ PROMO BULLETS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">📌 Promo Bullets</div>

      <form action="save_business_support.php" method="POST" class="row g-2 mb-3">
        <input type="hidden" name="action" value="add_promo_bullet">
        <div class="col-md-8">
          <input type="text" name="bullet_text" class="form-control" placeholder="Bullet text..." required>
        </div>
        <div class="col-md-2">
          <input type="number" name="position" class="form-control" placeholder="Pos" value="0">
        </div>
        <div class="col-md-2">
          <button class="btn btn-primary w-100">Add</button>
        </div>
      </form>

      <?php foreach($promoBullets as $b): ?>
        <div class="border rounded p-3 mb-2 bg-white">
          <form action="save_business_support.php" method="POST" class="row g-2 align-items-center">
            <input type="hidden" name="action" value="update_promo_bullet">
            <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">

            <div class="col-md-8">
              <input type="text" name="bullet_text" class="form-control" value="<?= htmlspecialchars($b['bullet_text']) ?>" required>
            </div>
            <div class="col-md-2">
              <input type="number" name="position" class="form-control" value="<?= (int)$b['position'] ?>">
            </div>
            <div class="col-md-2 d-flex gap-2">
              <button class="btn btn-success w-50">Update</button>
              <button formaction="save_business_support.php" name="action" value="delete_promo_bullet"
                      class="btn btn-danger w-50" onclick="return confirm('Delete this bullet?');">
                Delete
              </button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>
    </div>

  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
