<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// ✅ Fetch header settings
$settings = $pdo->query("SELECT * FROM community_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// ✅ Fetch topics
$topics = $pdo->query("SELECT * FROM community_topics ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ✅ Fetch paragraphs
$para_stmt = $pdo->query("SELECT * FROM community_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($para_stmt as $p) {
    $paras[$p['topic_id']][] = $p;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Community & Committees | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }
</style>

</head>
<body>

<div class="admin-wrapper">

    <?php include "sidebar.php"; ?>

    <div class="admin-content">

        <h3 class="mb-4">Manage Community & Committees</h3>

        <?php if(isset($_GET['saved'])): ?>
            <div class="alert alert-success">✅ Changes saved successfully!</div>
        <?php endif; ?>


        <!-- ✅ PAGE HEADER SECTION -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">🖼️ Page Header</div>

            <form action="save_community.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="update_header">

                <label class="fw-bold mb-1">Page Title</label>
                <input type="text" name="page_title" class="form-control mb-3"
                       value="<?= htmlspecialchars($settings['page_title']) ?>" required>

                <label class="fw-bold mb-1">Page Subtitle</label>
                <textarea name="page_subtitle" class="form-control mb-3" required><?= htmlspecialchars($settings['page_subtitle']) ?></textarea>

                <label class="fw-bold mb-1">Background Image</label>
                <input type="file" name="bg_image" class="form-control mb-3">

                <img src="../<?= $settings['bg_image'] ?>" class="mt-2 rounded" style="max-width:200px">

                <button class="btn btn-primary mt-3">Save Header</button>
            </form>
        </div>
		
		<?php
			$intro = $pdo->query("SELECT * FROM community_intro_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
			?>
			<div class="card p-4 shadow-sm mb-4 section-card">
				<div class="section-title">📝 Introduction Section</div>

				<form action="save_community.php" method="POST" enctype="multipart/form-data">
					<input type="hidden" name="action" value="update_intro">

					<label class="fw-bold mb-1">Download Button Text</label>
					<input type="text" name="download_text" class="form-control mb-3"
						   value="<?= htmlspecialchars($intro['download_text']) ?>" required>

					<label class="fw-bold mb-1">Download File (PDF)</label>
					<input type="file" name="download_file" class="form-control mb-3">
					<p class="small">Current: <a href="../<?= $intro['download_file'] ?>" target="_blank"><?= $intro['download_file'] ?></a></p>

					<label class="fw-bold mb-1">Introduction Paragraph</label>
					<textarea name="intro_paragraph" class="form-control mb-3" rows="4" required><?= htmlspecialchars($intro['intro_paragraph']) ?></textarea>

					<button class="btn btn-primary">Save Introduction</button>
				</form>
			</div>



        <!-- ✅ ADD TOPIC -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">➕ Add New Topic</div>

            <form action="save_community.php" method="POST">
                <input type="hidden" name="action" value="add_topic">

                <label class="fw-bold mb-1">Topic Title</label>
                <input type="text" name="topic_title" class="form-control mb-3" required>

                <button class="btn btn-success">Add Topic</button>
            </form>
        </div>


        <!-- ✅ LIST TOPICS + PARAGRAPHS -->
        <?php foreach ($topics as $t): ?>
        <div class="card p-4 shadow-sm mb-4 section-card">

            <div class="d-flex justify-content-between mb-3">
                <div class="section-title"><?= htmlspecialchars($t['topic_title']) ?></div>

                <form action="save_community.php" method="POST"
                      onsubmit="return confirm('Delete this topic?');">
                    <input type="hidden" name="action" value="delete_topic">
                    <input type="hidden" name="id" value="<?= $t['id'] ?>">
                    <button class="btn btn-danger btn-sm"><i class="bi bi-trash"></i></button>
                </form>
            </div>

            <!-- ✅ Add paragraph OR heading -->
            <form action="save_community.php" method="POST" class="mb-3">
                <input type="hidden" name="action" value="add_para">
                <input type="hidden" name="topic_id" value="<?= $t['id'] ?>">

                <label class="fw-bold">Type</label>
                <select name="type" class="form-control mb-2" required>
                    <option value="">Select type</option>
                    <option value="heading">Heading</option>
                    <option value="paragraph">Paragraph</option>
                </select>

                <textarea name="para_text" class="form-control mb-2" placeholder="Text..." required></textarea>

                <button class="btn btn-secondary btn-sm">Add</button>
            </form>

            <!-- ✅ List paragraphs -->
            <?php if (!empty($paras[$t['id']])): ?>
                <?php foreach ($paras[$t['id']] as $p): ?>

                <?php  
                    // ✅ FIX: type fallback — prevents NULL showing heading
                    $type = $p['type'] ?: 'paragraph';
                ?>

                <div class="bg-white border rounded p-3 mb-2">

                    <form action="save_community.php" method="POST">
                        <input type="hidden" name="action" value="update_para">
                        <input type="hidden" name="id" value="<?= $p['id'] ?>">

                        <label class="fw-bold mb-1">Type</label>
                        <select name="type" class="form-control mb-2">
                            <option value="heading" <?= ($type=="heading")?"selected":"" ?>>Heading</option>
                            <option value="paragraph" <?= ($type=="paragraph")?"selected":"" ?>>Paragraph</option>
                        </select>

                        <textarea name="para_text" class="form-control mb-2" required><?= htmlspecialchars($p['para_text']) ?></textarea>

                        <button class="btn btn-success btn-sm">Update</button>

                        <button formaction="save_community.php"
                                name="action" value="delete_para"
                                class="btn btn-danger btn-sm float-end"
                                onclick="return confirm('Delete this paragraph?');">
                            Delete
                        </button>
                    </form>

                </div>
                <?php endforeach; ?>
            <?php endif; ?>

        </div>
        <?php endforeach; ?>

    </div>

</div>

</body>
</html>
