<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


/* ---------- FETCH SETTINGS ---------- */
$set = $pdo->query("SELECT * FROM iaos_contact_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
if (!$set) {
  $pdo->exec("INSERT INTO iaos_contact_settings (id,page_title,page_subtitle,bg_image,intro_heading,intro_text)
              VALUES (1,'Contact Us',
              'We’d love to hear from you — whether you have a question, feedback, or a request.',
              'images/banner5.jpg',
              'Contact',
              'The Islamic Association of Saskatchewan (IAOS) welcomes all inquiries from the community and beyond. Whether you’re looking to learn about Islam, book our facilities, volunteer for an event, or reach out for media or relief-related matters — we’re here to assist you. Please select the relevant category below to get in touch with the right team.')");
  $set = $pdo->query("SELECT * FROM iaos_contact_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

/* ---------- FETCH CATEGORIES & LOCATIONS ---------- */
$cats = $pdo->query("SELECT * FROM iaos_contact_categories ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);
$locs = $pdo->query("SELECT * FROM iaos_contact_locations ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

function esc($s){ return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Contact | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;padding:12px 20px;display:block;text-decoration:none;border-bottom:1px solid #2f343a;}
.admin-sidebar a:hover,.admin-sidebar a.active{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
.section-card{border-radius:10px;}
.section-title{font-weight:700;font-size:1.2rem;margin-bottom:15px;}
.small-note{font-size:.875rem;color:#6c757d;}
</style>
</head>
<body>
<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Contact Page</h3>
    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <!-- GLOBAL HEADER -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🖼️ Page Header (Global)</div>
      <form action="save_contact.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="save_settings">

        <label class="fw-bold mb-1">Page Title</label>
        <input type="text" name="page_title" class="form-control mb-3" value="<?= esc($set['page_title']) ?>" required>

        <label class="fw-bold mb-1">Page Subtitle</label>
        <textarea name="page_subtitle" class="form-control mb-3" required><?= esc($set['page_subtitle']) ?></textarea>

        <label class="fw-bold mb-1">Header Background Image</label>
        <input type="file" name="bg_image" class="form-control mb-2" accept="image/*">
        <div class="small-note mb-2">If omitted, the current background remains.</div>
        <?php if(!empty($set['bg_image'])): ?>
          <img src="../<?= esc($set['bg_image']) ?>" class="rounded" style="max-width:240px;object-fit:cover;">
        <?php endif; ?>

        <button class="btn btn-primary mt-3">Save Header</button>
      </form>
    </div>

    <!-- INTRO -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">📝 Intro Block</div>
      <form action="save_contact.php" method="POST">
        <input type="hidden" name="action" value="save_intro">

        <label class="fw-bold mb-1">Intro Heading</label>
        <input type="text" name="intro_heading" class="form-control mb-2" value="<?= esc($set['intro_heading']) ?>" required>

        <label class="fw-bold mb-1">Intro Text</label>
        <textarea name="intro_text" class="form-control mb-2" rows="5" required><?= esc($set['intro_text']) ?></textarea>

        <button class="btn btn-primary">Save Intro</button>
      </form>
    </div>

    <!-- CATEGORIES (cards) -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">📚 Contact Categories (Cards/Slider)</div>

      <form action="save_contact.php" method="POST" class="row g-2 mb-3">
        <input type="hidden" name="action" value="add_category">
        <div class="col-md-4">
          <label class="fw-bold mb-1">Title</label>
          <input type="text" name="title" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="fw-bold mb-1">Description</label>
          <input type="text" name="description" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label class="fw-bold mb-1">Position</label>
          <input type="number" name="position" class="form-control" value="<?= time() ?>">
        </div>
        <div class="col-12">
          <button class="btn btn-success btn-sm">Add Category</button>
        </div>
      </form>

      <?php foreach($cats as $c): ?>
        <div class="bg-white border rounded p-3 mb-2">
          <form action="save_contact.php" method="POST" class="row g-2 align-items-end">
            <input type="hidden" name="action" value="update_category">
            <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">

            <div class="col-md-3">
              <label class="fw-bold mb-1">Title</label>
              <input type="text" name="title" class="form-control" value="<?= esc($c['title']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="fw-bold mb-1">Description</label>
              <input type="text" name="description" class="form-control" value="<?= esc($c['description']) ?>" required>
            </div>
            <div class="col-md-2">
              <label class="fw-bold mb-1">Position</label>
              <input type="number" name="position" class="form-control" value="<?= (int)$c['position'] ?>">
            </div>
            <div class="col-md-1">
              <label class="fw-bold mb-1">Active</label>
              <select name="is_active" class="form-select">
                <option value="1" <?= $c['is_active']?'selected':''; ?>>Yes</option>
                <option value="0" <?= !$c['is_active']?'selected':''; ?>>No</option>
              </select>
            </div>

            <div class="col-12 mt-2 d-flex gap-2">
              <button class="btn btn-success btn-sm">Update</button>
              <button formaction="save_contact.php" name="action" value="delete_category"
                      onclick="return confirm('Delete this category?')" class="btn btn-danger btn-sm">Delete</button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- LOCATIONS (maps) -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🗺️ Mosque Locations</div>

      <form action="save_contact.php" method="POST" class="row g-2 mb-3">
        <input type="hidden" name="action" value="add_location">
        <div class="col-md-3">
          <label class="fw-bold mb-1">Title</label>
          <input type="text" name="title" class="form-control" required>
        </div>
        <div class="col-md-5">
          <label class="fw-bold mb-1">Address</label>
          <input type="text" name="address" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label class="fw-bold mb-1">Map Query</label>
          <input type="text" name="map_query" class="form-control" placeholder="3273+Montague+St,+Regina,+SK" required>
        </div>
        <div class="col-md-2">
          <label class="fw-bold mb-1">Position</label>
          <input type="number" name="position" class="form-control" value="<?= time() ?>">
        </div>
        <div class="col-12">
          <button class="btn btn-success btn-sm">Add Location</button>
        </div>
      </form>

      <?php foreach($locs as $l): ?>
        <div class="bg-white border rounded p-3 mb-2">
          <form action="save_contact.php" method="POST" class="row g-2 align-items-end">
            <input type="hidden" name="action" value="update_location">
            <input type="hidden" name="id" value="<?= (int)$l['id'] ?>">

            <div class="col-md-3">
              <label class="fw-bold mb-1">Title</label>
              <input type="text" name="title" class="form-control" value="<?= esc($l['title']) ?>" required>
            </div>
            <div class="col-md-5">
              <label class="fw-bold mb-1">Address</label>
              <input type="text" name="address" class="form-control" value="<?= esc($l['address']) ?>" required>
            </div>
            <div class="col-md-2">
              <label class="fw-bold mb-1">Map Query</label>
              <input type="text" name="map_query" class="form-control" value="<?= esc($l['map_query']) ?>" required>
            </div>
            <div class="col-md-1">
              <label class="fw-bold mb-1">Position</label>
              <input type="number" name="position" class="form-control" value="<?= (int)$l['position'] ?>">
            </div>
            <div class="col-md-1">
              <label class="fw-bold mb-1">Active</label>
              <select name="is_active" class="form-select">
                <option value="1" <?= $l['is_active']?'selected':''; ?>>Yes</option>
                <option value="0" <?= !$l['is_active']?'selected':''; ?>>No</option>
              </select>
            </div>

            <div class="col-12 mt-2 d-flex gap-2">
              <button class="btn btn-success btn-sm">Update</button>
              <button formaction="save_contact.php" name="action" value="delete_location"
                      onclick="return confirm('Delete this location?')" class="btn btn-danger btn-sm">Delete</button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>
    </div>

  </div>
</div>
</body>
</html>
