<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


// Fetch page header
$header = $pdo->query("SELECT * FROM iaos_counselling_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// Fetch intro box
$intro = $pdo->query("SELECT * FROM iaos_counselling_intro ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

// Multi-language intro lines
$langs = $pdo->query("SELECT * FROM iaos_counselling_languages ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// Counsellors
$counsellors = $pdo->query("SELECT * FROM iaos_counsellors ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// Form text
$form = $pdo->query("SELECT * FROM iaos_counselling_form WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Counselling Page | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; border-bottom:1px solid #2f343a; text-decoration:none; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-size:1.3rem; font-weight:700; }
</style>
</head>

<body>
<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">Manage Counselling Page</h3>

<?php if(isset($_GET['saved'])): ?>
<div class="alert alert-success">✅ Saved successfully!</div>
<?php endif; ?>

<!-- ✅ PAGE HEADER -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Page Header</div>

  <form action="save_counselling.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_header">

    <label class="fw-bold">Page Title</label>
    <input type="text" class="form-control mb-2" name="page_title"
      value="<?= htmlspecialchars($header['page_title']) ?>">

    <label class="fw-bold">Page Subtitle</label>
    <textarea class="form-control mb-2" name="page_subtitle"><?= htmlspecialchars($header['page_subtitle']) ?></textarea>

    <label class="fw-bold">Background Image</label>
    <input type="file" class="form-control mb-2" name="bg_image">

    <?php if(!empty($header['bg_image'])): ?>
      <img src="../<?= $header['bg_image'] ?>" class="rounded mt-2" style="max-width:200px">
    <?php endif; ?>

    <button class="btn btn-primary mt-3">Save Header</button>
  </form>
</div>

<!-- ✅ INTRO SECTION -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📘 Intro Section</div>

  <form action="save_counselling.php" method="POST">
    <input type="hidden" name="action" value="save_intro">

    <label class="fw-bold">Intro Title</label>
    <input type="text" class="form-control mb-2" name="intro_title"
      value="<?= htmlspecialchars($intro[0]['title']) ?>">

    <label class="fw-bold">Intro Paragraph</label>
    <textarea class="form-control mb-2" name="intro_paragraph"><?= htmlspecialchars($intro[0]['paragraph']) ?></textarea>

    <label class="fw-bold">Heading Background</label>
    <select name="bg_color" class="form-control mb-2">
      <option value="white" <?= $intro[0]['bg_color']=="white"?"selected":"" ?>>White</option>
      <option value="green" <?= $intro[0]['bg_color']=="green"?"selected":"" ?>>Green</option>
    </select>

    <button class="btn btn-success mt-3">Save Intro</button>
  </form>
</div>

<!-- ✅ MULTI-LANGUAGE INTRO BOX -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🌍 Multi-Language Intro Box</div>

  <!-- Add new -->
  <form action="save_counselling.php" method="POST" class="mb-3">
    <input type="hidden" name="action" value="add_language">

    <label class="fw-bold">Language Title</label>
    <input type="text" name="lang_title" class="form-control mb-2" required>

    <label class="fw-bold">Language Text</label>
    <textarea name="lang_text" class="form-control mb-2" required></textarea>

    <button class="btn btn-secondary btn-sm">Add Language Paragraph</button>
  </form>

  <!-- Existing -->
  <?php foreach($langs as $l): ?>
    <div class="bg-white border p-3 rounded mb-2">
      <form action="save_counselling.php" method="POST">
        <input type="hidden" name="action" value="update_language">
        <input type="hidden" name="id" value="<?= $l['id'] ?>">

        <label class="fw-bold">Language Title</label>
        <input type="text" class="form-control mb-2"
          name="lang_title" value="<?= htmlspecialchars($l['lang_title']) ?>">

        <label class="fw-bold">Text</label>
        <textarea class="form-control mb-2"
          name="lang_text"><?= htmlspecialchars($l['lang_text']) ?></textarea>

        <button class="btn btn-success btn-sm">Update</button>

        <button class="btn btn-danger btn-sm float-end"
          formaction="save_counselling.php" name="action" value="delete_language"
          onclick="return confirm('Delete?')">Delete</button>
      </form>
    </div>
  <?php endforeach; ?>

</div>

<!-- ✅ COUNSELLORS -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">👤 Counsellors</div>

  <!-- ADD -->
  <form action="save_counselling.php" method="POST" class="mb-3">
    <input type="hidden" name="action" value="add_counsellor">

    <label class="fw-bold">Counsellor Name</label>
    <input type="text" name="name" class="form-control mb-2" required>

    <label class="fw-bold">Languages</label>
    <input type="text" name="languages" class="form-control mb-2">

    <button class="btn btn-secondary btn-sm">Add Counsellor</button>
  </form>

  <!-- EXISTING -->
  <?php foreach($counsellors as $c): ?>
  <div class="bg-white border p-3 rounded mb-2">
    <form action="save_counselling.php" method="POST">
      <input type="hidden" name="action" value="update_counsellor">
      <input type="hidden" name="id" value="<?= $c['id'] ?>">

      <label class="fw-bold">Name</label>
      <input class="form-control mb-2" name="name" value="<?= htmlspecialchars($c['name']) ?>">

      <label class="fw-bold">Languages</label>
      <input class="form-control mb-2" name="languages" value="<?= htmlspecialchars($c['languages']) ?>">

      <button class="btn btn-success btn-sm">Update</button>

      <button class="btn btn-danger btn-sm float-end"
        formaction="save_counselling.php" name="action" value="delete_counsellor"
        onclick="return confirm('Delete counsellor?')">Delete</button>
    </form>
  </div>
  <?php endforeach; ?>

</div>

<!-- ✅ CONTACT FORM SETTINGS -->
<div class="card p-4 shadow-sm section-card">
  <div class="section-title">📝 Contact Form Settings</div>

  <form action="save_counselling.php" method="POST">
    <input type="hidden" name="action" value="save_form">

    <label class="fw-bold">Form Heading</label>
    <input type="text" name="form_heading" class="form-control mb-2"
      value="<?= htmlspecialchars($form['form_heading']) ?>">

    <label class="fw-bold">Form Note (optional)</label>
    <textarea name="form_note" class="form-control mb-2"><?= htmlspecialchars($form['form_note']) ?></textarea>

    <button class="btn btn-primary mt-2">Save Form</button>
  </form>
</div>

</div>
</div>
</body>
</html>
