<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

/* ========== FETCH JOB ========== */
if ($id > 0) {
    $stm = $pdo->prepare("SELECT * FROM iaos_jobs WHERE id=?");
    $stm->execute([$id]);
    $job = $stm->fetch(PDO::FETCH_ASSOC);
} else {
    $job = [
        'title' => '',
        'subtitle' => '',
        'hero_image' => '',
        'apply_email' => '',
        'apply_deadline' => ''
    ];
}

/* ========== FETCH HEADINGS ========== */
$heads = [];
if ($id > 0) {
    $heads = $pdo->prepare("SELECT * FROM iaos_job_headings WHERE job_id=? ORDER BY position ASC");
    $heads->execute([$id]);
    $heads = $heads->fetchAll(PDO::FETCH_ASSOC);

    /* FETCH PARAGRAPHS */
    $pp = $pdo->prepare("SELECT * FROM iaos_job_paragraphs WHERE job_id=? ORDER BY position ASC");
    $pp->execute([$id]);
    $allPara = $pp->fetchAll(PDO::FETCH_ASSOC);
    $paras = [];
    foreach ($allPara as $p) {
        $paras[$p['heading_id']][] = $p;
    }

    /* FETCH REQUIREMENTS */
    $req = $pdo->prepare("SELECT * FROM iaos_job_requirements WHERE job_id=? ORDER BY position ASC");
    $req->execute([$id]);
    $requirements = $req->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title><?= $id ? 'Edit Job' : 'Add Job' ?> | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; }
</style>
</head>
<body>

<?php include "sidebar.php"; ?>

<div class="container py-4">

    <h2 class="fw-bold mb-4"><?= $id ? 'Edit Career Job' : 'Add New Career Job' ?></h2>

    <!-- ✅ BASIC JOB SETTINGS -->
    <div class="card p-4 shadow-sm section-card mb-4">
        <div class="section-title mb-3">Job Details</div>

        <form action="save_jobs.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="action" value="save_job">
            <input type="hidden" name="id" value="<?= $id ?>">

            <label class="fw-bold">Job Title</label>
            <input type="text" name="title" class="form-control mb-3" required value="<?= htmlspecialchars($job['title']) ?>">

            <label class="fw-bold">Subtitle</label>
            <textarea name="subtitle" class="form-control mb-3"><?= htmlspecialchars($job['subtitle']) ?></textarea>

            <label class="fw-bold">Apply Email</label>
            <input type="text" name="apply_email" class="form-control mb-3" value="<?= htmlspecialchars($job['apply_email']) ?>">

            <label class="fw-bold">Apply Deadline</label>
            <input type="text" name="apply_deadline" class="form-control mb-3" value="<?= htmlspecialchars($job['apply_deadline']) ?>">

            <label class="fw-bold">Hero Image</label>
            <input type="file" name="hero_image" class="form-control mb-2">
            <?php if ($job['hero_image']): ?>
                <img src="../<?= $job['hero_image'] ?>" style="max-width:250px;">
            <?php endif; ?>

            <button class="btn btn-primary mt-3">Save Job</button>
        </form>
    </div>

    <?php if ($id > 0): ?>

    <!-- ✅ ADD HEADING -->
    <div class="card p-4 shadow-sm section-card mb-4">
        <div class="section-title mb-3">➕ Add New Heading</div>

        <form action="save_jobs.php" method="POST">
            <input type="hidden" name="action" value="add_heading">
            <input type="hidden" name="job_id" value="<?= $id ?>">

            <label class="fw-bold">Heading Text</label>
            <input type="text" name="heading_text" class="form-control mb-2" required>

            <button class="btn btn-success">Add Heading</button>
        </form>
    </div>

    <!-- ✅ LIST HEADINGS + PARAGRAPHS -->
    <?php foreach ($heads as $h): ?>
        <div class="card p-4 shadow-sm section-card mb-4">

            <div class="d-flex justify-content-between mb-3">
                <div class="section-title"><?= htmlspecialchars($h['heading_text']) ?></div>

                <form action="save_jobs.php" method="POST" onsubmit="return confirm('Delete this heading and all its content?')">
                    <input type="hidden" name="action" value="delete_heading">
                    <input type="hidden" name="id" value="<?= $h['id'] ?>">
                    <button class="btn btn-danger btn-sm">Delete</button>
                </form>
            </div>

            <!-- ✅ ADD PARAGRAPH -->
            <form action="save_jobs.php" method="POST" class="mb-3">
                <input type="hidden" name="action" value="add_paragraph">
                <input type="hidden" name="job_id" value="<?= $id ?>">
                <input type="hidden" name="heading_id" value="<?= $h['id'] ?>">

                <label class="fw-bold">Add Paragraph</label>
                <textarea name="para_text" class="form-control mb-2" required></textarea>

                <button class="btn btn-secondary btn-sm">Add Paragraph</button>
            </form>

            <!-- ✅ LIST PARAGRAPHS -->
            <?php if (!empty($paras[$h['id']])): ?>
                <?php foreach ($paras[$h['id']] as $p): ?>
                    <div class="p-3 mb-2 border rounded bg-white">

                        <form action="save_jobs.php" method="POST">
                            <input type="hidden" name="action" value="update_paragraph">
                            <input type="hidden" name="id" value="<?= $p['id'] ?>">

                            <textarea name="para_text" class="form-control mb-2"><?= htmlspecialchars($p['para_text']) ?></textarea>

                            <button class="btn btn-success btn-sm">Update</button>

                            <button formaction="save_jobs.php" name="action" value="delete_paragraph"
                                onclick="return confirm('Delete this paragraph?')"
                                class="btn btn-danger btn-sm float-end">Delete</button>
                        </form>

                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

        </div>
    <?php endforeach; ?>


    <!-- ✅ REQUIREMENTS LIST -->
    <div class="card p-4 shadow-sm section-card mb-4">
        <div class="section-title mb-3">✅ Job Requirements</div>

        <!-- Add Requirement -->
        <form action="save_jobs.php" method="POST" class="mb-3">
            <input type="hidden" name="action" value="add_requirement">
            <input type="hidden" name="job_id" value="<?= $id ?>">

            <label class="fw-bold">Add Requirement</label>
            <input type="text" name="item_text" class="form-control mb-2" required>

            <button class="btn btn-secondary btn-sm">Add</button>
        </form>

        <!-- List Requirements -->
        <?php foreach ($requirements as $r): ?>
            <div class="p-2 bg-white mb-2 border rounded">
                <form action="save_jobs.php" method="POST">
                    <input type="hidden" name="action" value="update_requirement">
                    <input type="hidden" name="id" value="<?= $r['id'] ?>">

                    <input type="text" name="item_text" class="form-control mb-2" value="<?= htmlspecialchars($r['item_text']) ?>">

                    <button class="btn btn-success btn-sm">Update</button>

                    <button formaction="save_jobs.php" name="action" value="delete_requirement"
                        onclick="return confirm('Delete this requirement?')"
                        class="btn btn-danger btn-sm float-end">Delete</button>
                </form>
            </div>
        <?php endforeach; ?>

    </div>

    <?php endif; ?>

</div>

</body>
</html>
