<?php
ob_start();
require_once "db.php";

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


/* Load header + intro */
$settings = $pdo->query("SELECT * FROM education_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$intro = $pdo->query("SELECT * FROM education_intro_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* Load topics + paragraphs */
$topics = $pdo->query("SELECT * FROM education_topics ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);
$para_stmt = $pdo->query("SELECT * FROM education_paragraphs ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras = [];
foreach ($para_stmt as $p) { $paras[$p['topic_id']][] = $p; }
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Education | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.1rem; margin-bottom:12px; }
.badge-note { font-size:.75rem; }
.preview-img { max-width:220px; border-radius:8px; }
</style>
</head>
<body>
<div class="admin-wrapper">

  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Education Page</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully</div>
    <?php endif; ?>

    <!-- 🖼️ PAGE HEADER -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <h4 class="section-title">📝 Page Header</h4>

      <form action="save_education.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="save_header">

        <label class="fw-bold">Page Title</label>
        <input type="text" name="page_title" class="form-control mb-2"
               value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>">

        <label class="fw-bold">Page Subtitle</label>
        <input type="text" name="page_subtitle" class="form-control mb-2"
               value="<?= htmlspecialchars($settings['page_subtitle'] ?? '') ?>">

        <label class="fw-bold mb-1">Header Background Image</label>
        <input type="file" name="bg_image_file" class="form-control mb-2">
        <div class="form-text">Uploads go to <code>../images/</code>; path saved as <code>images/filename.jpg</code>.</div>

        <?php if (!empty($settings['bg_image'])): ?>
          <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" class="preview-img mt-2">
        <?php endif; ?>

        <button class="btn btn-primary mt-3">Save Header</button>
      </form>
    </div>

    <!-- 📄 INTRO BLOCK -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <h4 class="section-title">📄 Intro Block</h4>
      <form action="save_education.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="save_intro">

        <label class="fw-bold">Intro Paragraph</label>
        <textarea name="intro_paragraph" class="form-control mb-2" rows="4"><?= htmlspecialchars($intro['intro_paragraph'] ?? '') ?></textarea>

        <div class="row g-2">
          <div class="col-md-6">
            <label class="fw-bold">Download Button Text (optional)</label>
            <input type="text" name="download_text" class="form-control mb-2"
                   value="<?= htmlspecialchars($intro['download_text'] ?? '') ?>">
          </div>
          <div class="col-md-6">
            <label class="fw-bold">Upload File (optional)</label>
            <input type="file" name="download_file" class="form-control mb-2">
            <div class="form-text">Stored under <code>../doc/</code> as plain filename; link will be <code>doc/filename</code>.</div>
          </div>
        </div>

        <?php if (!empty($intro['download_file'])): ?>
          <div class="mt-2">
            Current file: <span class="badge bg-secondary"><?= htmlspecialchars($intro['download_file']) ?></span>
          </div>
        <?php endif; ?>

        <button class="btn btn-primary mt-2">Save Intro</button>
      </form>
    </div>

    <!-- ➕ ADD TOPIC -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <h4 class="section-title">➕ Add Program/Section (Topic)</h4>
      <form action="save_education.php" method="POST">
        <input type="hidden" name="action" value="add_topic">
        <div class="row g-2">
          <div class="col-md-6">
            <label class="fw-bold">Topic Title</label>
            <input type="text" name="topic_title" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label class="fw-bold">Position</label>
            <input type="number" name="position" class="form-control" value="100">
          </div>
          <div class="col-md-3">
            <label class="fw-bold">Admission Button?</label>
            <select name="show_admission_button" class="form-select">
              <option value="0">No</option>
              <option value="1">Yes</option>
            </select>
          </div>
        </div>
        <button class="btn btn-success mt-3">Add Topic</button>
      </form>
    </div>

    <!-- LIST TOPICS -->
    <?php foreach ($topics as $t): ?>
      <div class="card p-4 shadow-sm mb-4 section-card">
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <div class="section-title mb-1"><?= htmlspecialchars($t['topic_title']) ?></div>
            <span class="badge bg-dark me-2">pos: <?= (int)$t['position'] ?></span>
            <span class="badge <?= $t['show_admission_button'] ? 'bg-success' : 'bg-secondary' ?>">
              Admission Btn: <?= $t['show_admission_button'] ? 'ON' : 'OFF' ?>
            </span>
          </div>
          <form action="save_education.php" method="POST" onsubmit="return confirm('Delete this topic and all its items?');">
            <input type="hidden" name="action" value="delete_topic">
            <input type="hidden" name="id" value="<?= $t['id'] ?>">
            <button class="btn btn-danger btn-sm">Delete Topic</button>
          </form>
        </div>

        <!-- Update topic -->
        <form action="save_education.php" method="POST" class="mt-3">
          <input type="hidden" name="action" value="update_topic">
          <input type="hidden" name="id" value="<?= $t['id'] ?>">
          <div class="row g-2">
            <div class="col-md-6">
              <label class="fw-bold">Title</label>
              <input type="text" name="topic_title" class="form-control" value="<?= htmlspecialchars($t['topic_title']) ?>">
            </div>
            <div class="col-md-3">
              <label class="fw-bold">Position</label>
              <input type="number" name="position" class="form-control" value="<?= (int)$t['position'] ?>">
            </div>
            <div class="col-md-3">
              <label class="fw-bold">Admission Button</label>
              <select name="show_admission_button" class="form-select">
                <option value="0" <?= $t['show_admission_button']? '' : 'selected' ?>>No</option>
                <option value="1" <?= $t['show_admission_button']? 'selected' : '' ?>>Yes</option>
              </select>
            </div>
          </div>
          <button class="btn btn-primary btn-sm mt-2">Update Topic</button>
        </form>

        <!-- Add paragraph -->
        <form action="save_education.php" method="POST" class="mt-3">
          <input type="hidden" name="action" value="add_para">
          <input type="hidden" name="topic_id" value="<?= $t['id'] ?>">
          <div class="row g-2">
            <div class="col-md-3">
              <label class="fw-bold">Type</label>
              <select name="type" class="form-select" required>
                <option value="heading">Heading</option>
                <option value="paragraph" selected>Paragraph</option>
                <option value="li">List Item</option>
                <option value="html">Raw HTML</option>
              </select>
            </div>
            <div class="col-md-2">
              <label class="fw-bold">Position</label>
              <input type="number" name="position" class="form-control" value="100">
            </div>
          </div>
          <label class="fw-bold mt-2">Text</label>
          <textarea name="para_text" class="form-control mb-2" rows="3" placeholder="Enter text or HTML..."></textarea>
          <button class="btn btn-secondary btn-sm">Add Item</button>
        </form>

        <!-- Existing paragraphs -->
        <?php if (!empty($paras[$t['id']])): ?>
          <hr>
          <?php foreach ($paras[$t['id']] as $p): ?>
            <div class="bg-white border rounded p-3 mb-2">
              <form action="save_education.php" method="POST">
                <input type="hidden" name="action" value="update_para">
                <input type="hidden" name="id" value="<?= $p['id'] ?>">
                <div class="row g-2">
                  <div class="col-md-3">
                    <label class="fw-bold">Type</label>
                    <select name="type" class="form-select">
                      <option value="heading"   <?= $p['type']=='heading'?'selected':''; ?>>Heading</option>
                      <option value="paragraph" <?= $p['type']=='paragraph'?'selected':''; ?>>Paragraph</option>
                      <option value="li"        <?= $p['type']=='li'?'selected':''; ?>>List Item</option>
                      <option value="html"      <?= $p['type']=='html'?'selected':''; ?>>Raw HTML</option>
                    </select>
                  </div>
                  <div class="col-md-2">
                    <label class="fw-bold">Position</label>
                    <input type="number" name="position" class="form-control" value="<?= (int)$p['position'] ?>">
                  </div>
                </div>
                <label class="fw-bold mt-2">Text</label>
                <textarea name="para_text" class="form-control mb-2" rows="3"><?= htmlspecialchars($p['para_text']) ?></textarea>

                <button class="btn btn-success btn-sm">Update</button>
                <button formaction="save_education.php" name="action" value="delete_para"
                        class="btn btn-danger btn-sm float-end"
                        onclick="return confirm('Delete this item?');">
                  Delete
                </button>
              </form>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>

  </div>
</div>
</body>
</html>
