<?php
ob_start();
require_once "db.php"; // admin DB

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}



// ✅ Load header settings
$header = $pdo->query("SELECT * FROM events_page_header WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// ✅ Load intro section
$intro = $pdo->query("SELECT * FROM events_page_intro WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Events Page | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; margin-bottom:12px; }
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

  <h3 class="mb-4">Manage Events Page</h3>

  <?php if(isset($_GET['saved'])): ?>
    <div class="alert alert-success">✅ Saved successfully</div>
  <?php endif; ?>


  <!-- ✅ PAGE HEADER SETTINGS -->
  <div class="card p-4 shadow-sm mb-4 section-card">
    <div class="section-title">🖼️ Page Header</div>

    <form action="save_events_page.php" method="POST" enctype="multipart/form-data">
      <input type="hidden" name="action" value="save_header">

      <label class="fw-bold mb-1">Page Title</label>
      <input type="text" name="page_title" class="form-control mb-2"
             value="<?= htmlspecialchars($header['page_title']) ?>" required>

      <label class="fw-bold mb-1">Page Subtitle</label>
      <textarea name="page_subtitle" class="form-control mb-2" rows="3" required><?= 
        htmlspecialchars($header['page_subtitle']) ?></textarea>

      <label class="fw-bold mb-1">Background Image</label>
      <input type="file" name="bg_image" class="form-control mb-2">

      <?php if (!empty($header['bg_image'])): ?>
        <img src="../<?= htmlspecialchars($header['bg_image']) ?>" style="max-width:220px" class="rounded mt-2">
      <?php endif; ?>

      <button class="btn btn-primary mt-3">Save Header</button>
    </form>
  </div>


  <!-- ✅ INTRO SECTION -->
  <div class="card p-4 shadow-sm mb-4 section-card">
    <div class="section-title">📝 Intro Section</div>

    <form action="save_events_page.php" method="POST">
      <input type="hidden" name="action" value="save_intro">

      <label class="fw-bold mb-1">Heading</label>
      <input type="text" name="intro_heading" class="form-control mb-2"
             value="<?= htmlspecialchars($intro['heading']) ?>" required>

      <label class="fw-bold mb-1">Paragraph</label>
      <textarea name="intro_paragraph" class="form-control mb-2" rows="4" required><?= 
        htmlspecialchars($intro['paragraph']) ?></textarea>

      <button class="btn btn-success mt-3">Save Intro</button>
    </form>
  </div>


</div>
</div>

</body>
</html>
