<?php
ob_start();
require_once "db.php"; // or "admin_pannel/db.php" if that’s your path

session_start();


// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}


$set = $pdo->query("SELECT * FROM financial_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$sections = $pdo->query("SELECT * FROM financial_sections ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras_stmt = $pdo->query("SELECT * FROM financial_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($paras_stmt as $p) {
  $paras[$p['section_id']][] = $p;
}

$limits = $pdo->query("SELECT * FROM financial_limits ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Financial Assistance | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; text-decoration:none; border-bottom:1px solid #2f343a; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.2rem; margin-bottom:12px; }
</style>
</head>
<body>
<div class="admin-wrapper">

  <?php include "sidebar.php"; ?>

  <div class="admin-content">

    <h3 class="mb-4">Manage Financial Assistance (Rizq relif)</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>

    <!-- PAGE HEADER -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🖼️ Page Header</div>
      <form action="save_financial.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="save_header">
        <label class="fw-bold mb-1">Page Title</label>
        <input type="text" name="page_title" class="form-control mb-2" value="<?= htmlspecialchars($set['page_title'] ?? '') ?>" required>

        <label class="fw-bold mb-1">Page Subtitle (quote)</label>
        <textarea name="page_subtitle" class="form-control mb-2" rows="3" required><?= htmlspecialchars($set['page_subtitle'] ?? '') ?></textarea>

        <label class="fw-bold mb-1">Header Background Image</label>
        <input type="file" name="bg_image" class="form-control mb-2">
        <?php if (!empty($set['bg_image'])): ?>
          <img src="../<?= htmlspecialchars($set['bg_image']) ?>" alt="" style="max-width:220px" class="rounded mt-2">
        <?php endif; ?>

        <button class="btn btn-primary mt-2">Save Header</button>
      </form>
    </div>

    <!-- ADD SECTION -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">➕ Add New Section</div>
      <form action="save_financial.php" method="POST">
        <input type="hidden" name="action" value="add_section">
        <div class="row g-2">
          <div class="col-md-6">
            <label class="fw-bold mb-1">Section Title</label>
            <input type="text" name="section_title" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label class="fw-bold mb-1">Style</label>
            <select name="style" class="form-select">
              <option value="default">Default (light)</option>
              <option value="green">Green (white text)</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="fw-bold mb-1">Position</label>
            <input type="number" name="position" class="form-control" value="100">
          </div>
        </div>
        <button class="btn btn-success mt-3">Add Section</button>
      </form>
    </div>

    <!-- LIST SECTIONS + PARAS -->
    <?php foreach ($sections as $s): ?>
      <div class="card p-4 shadow-sm mb-4 section-card">
        <div class="d-flex justify-content-between">
          <div>
            <div class="section-title mb-1"><?= htmlspecialchars($s['section_title']) ?></div>
            <span class="badge bg-secondary me-2"><?= htmlspecialchars($s['style']) ?></span>
            <span class="badge bg-dark">pos: <?= (int)$s['position'] ?></span>
          </div>
          <form action="save_financial.php" method="POST" onsubmit="return confirm('Delete this section? All its content will be removed.')">
            <input type="hidden" name="action" value="delete_section">
            <input type="hidden" name="id" value="<?= $s['id'] ?>">
            <button class="btn btn-danger btn-sm">Delete</button>
          </form>
        </div>

        <!-- Add paragraph -->
        <form action="save_financial.php" method="POST" class="mt-3">
          <input type="hidden" name="action" value="add_para">
          <input type="hidden" name="section_id" value="<?= $s['id'] ?>">

          <div class="row g-2">
            <div class="col-md-3">
              <label class="fw-bold mb-1">Type</label>
              <select name="type" class="form-select" required>
                <option value="heading">Heading</option>
                <option value="paragraph" selected>Paragraph</option>
                <option value="li">List Item</option>
                <option value="html">Raw HTML</option>
              </select>
            </div>
            <div class="col-md-3">
              <label class="fw-bold mb-1">Position</label>
              <input type="number" name="position" class="form-control" value="100">
            </div>
          </div>

          <label class="fw-bold mt-2 mb-1">Text</label>
          <textarea name="para_text" class="form-control mb-2" rows="3" placeholder="Text..."></textarea>

          <button class="btn btn-secondary btn-sm">Add Item</button>
        </form>

        <!-- Existing paragraphs -->
        <?php if (!empty($paras[$s['id']])): ?>
          <hr>
          <?php foreach ($paras[$s['id']] as $p): ?>
            <div class="bg-white border rounded p-3 mb-2">
              <form action="save_financial.php" method="POST">
                <input type="hidden" name="action" value="update_para">
                <input type="hidden" name="id" value="<?= $p['id'] ?>">

                <div class="row g-2">
                  <div class="col-md-3">
                    <label class="fw-bold mb-1">Type</label>
                    <select name="type" class="form-select">
                      <option value="heading"   <?= $p['type']=='heading'?'selected':''; ?>>Heading</option>
                      <option value="paragraph" <?= $p['type']=='paragraph'?'selected':''; ?>>Paragraph</option>
                      <option value="li"        <?= $p['type']=='li'?'selected':''; ?>>List Item</option>
                      <option value="html"      <?= $p['type']=='html'?'selected':''; ?>>Raw HTML</option>
                    </select>
                  </div>
                  <div class="col-md-3">
                    <label class="fw-bold mb-1">Position</label>
                    <input type="number" name="position" class="form-control" value="<?= (int)$p['position'] ?>">
                  </div>
                </div>

                <label class="fw-bold mt-2 mb-1">Text</label>
                <textarea name="para_text" class="form-control mb-2" rows="3"><?= htmlspecialchars($p['para_text']) ?></textarea>

                <button class="btn btn-success btn-sm">Update</button>

                <button formaction="save_financial.php" name="action" value="delete_para"
                        class="btn btn-danger btn-sm float-end"
                        onclick="return confirm('Delete this item?');">
                  Delete
                </button>
              </form>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>

    <!-- LIMITS TABLE (Rent/Food/etc.) -->
    <div class="card p-4 shadow-sm section-card">
      <div class="section-title">💵 Funding Limits Table</div>

      <!-- Add row -->
      <form action="save_financial.php" method="POST" class="mb-3">
        <input type="hidden" name="action" value="add_limit">
        <div class="row g-2">
          <div class="col-md-4">
            <label class="fw-bold mb-1">Type of Need</label>
            <input type="text" name="need" class="form-control" placeholder="Rent / Food / ..." required>
          </div>
          <div class="col-md-4">
            <label class="fw-bold mb-1">Maximum Funding</label>
            <input type="text" name="max_limit" class="form-control" placeholder="$300 / One Monthly Bus Pass ..." required>
          </div>
          <div class="col-md-2">
            <label class="fw-bold mb-1">Position</label>
            <input type="number" name="position" class="form-control" value="100">
          </div>
          <div class="col-md-2 d-flex align-items-end">
            <button class="btn btn-success w-100">Add Row</button>
          </div>
        </div>
      </form>

      <?php foreach ($limits as $r): ?>
        <div class="bg-white border rounded p-3 mb-2">
          <form action="save_financial.php" method="POST">
            <input type="hidden" name="action" value="update_limit">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">

            <div class="row g-2">
              <div class="col-md-4">
                <label class="fw-bold mb-1">Type of Need</label>
                <input type="text" name="need" class="form-control" value="<?= htmlspecialchars($r['need']) ?>">
              </div>
              <div class="col-md-4">
                <label class="fw-bold mb-1">Maximum Funding</label>
                <input type="text" name="max_limit" class="form-control" value="<?= htmlspecialchars($r['max_limit']) ?>">
              </div>
              <div class="col-md-2">
                <label class="fw-bold mb-1">Position</label>
                <input type="number" name="position" class="form-control" value="<?= (int)$r['position'] ?>">
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-success btn-sm me-2">Update</button>
                <button formaction="save_financial.php" name="action" value="delete_limit"
                        class="btn btn-danger btn-sm"
                        onclick="return confirm('Delete this row?');">Delete</button>
              </div>
            </div>
          </form>
        </div>
      <?php endforeach; ?>

    </div>

  </div>
</div>
</body>
</html>
