<?php
ob_start();
require_once "db.php";
session_start();

// ✅ SECURITY CHECK 1: Must be logged in
if (!isset($_SESSION['user_id'])) {
  header("Location: index.php");
  exit;
}

// ✅ SECURITY CHECK 2: Must be admin
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') {
  header("Location: index.php");
  exit;
}

// Load settings
$settings = $pdo->query("SELECT * FROM membership_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$purpose  = $pdo->query("SELECT * FROM membership_purpose WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$bullets  = $pdo->query("SELECT * FROM membership_purpose_bullets WHERE purpose_id=1 ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$cards    = $pdo->query("SELECT * FROM membership_cards ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Membership | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }

/* ✅✅✅ MISSING SIDEBAR CSS (same like your other pages) */
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a {
  color:#ccc; padding:12px 20px; display:block;
  text-decoration:none; border-bottom:1px solid #2f343a;
}
.admin-sidebar a:hover, .admin-sidebar a.active {
  background:#0d6efd; color:#fff;
}
/* ✅✅✅ end sidebar css */

.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }
</style>
</head>
<body>

<div class="admin-wrapper">

  <?php include "sidebar.php"; ?>

  <div class="admin-content">

    <h3 class="mb-4">Manage Membership Page</h3>

    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Saved successfully!</div>
    <?php endif; ?>
    <?php if(isset($_GET['deleted'])): ?>
      <div class="alert alert-warning">🗑️ Deleted successfully!</div>
    <?php endif; ?>
    <?php if(isset($_GET['err'])): ?>
      <div class="alert alert-danger">❌ Something went wrong!</div>
    <?php endif; ?>

    <!-- ✅ PAGE HEADER -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🖼️ Page Header</div>

      <form action="save_membership.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="update_header">

        <label class="fw-bold mb-1">Page Title</label>
        <input type="text" name="page_title" value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>" class="form-control mb-3" required>

        <label class="fw-bold mb-1">Page Subtitle</label>
        <textarea name="page_subtitle" class="form-control mb-3" required><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></textarea>

        <label class="fw-bold mb-1">Background Image</label>
        <input type="file" name="bg_image" class="form-control mb-3">

        <?php if (!empty($settings['bg_image'])): ?>
          <img src="../<?= htmlspecialchars($settings['bg_image']) ?>" class="rounded mt-2" style="max-width:220px;object-fit:cover;">
        <?php endif; ?>

        <button class="btn btn-primary mt-3">Save Header</button>
      </form>
    </div>

    <!-- ✅ PURPOSE SECTION -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🧾 Purpose Section</div>

      <form action="save_membership.php" method="POST">
        <input type="hidden" name="action" value="update_purpose">

        <label class="fw-bold mb-1">Title</label>
        <input type="text" name="title" value="<?= htmlspecialchars($purpose['title'] ?? '') ?>" class="form-control mb-3" required>

        <label class="fw-bold mb-1">Intro Text</label>
        <textarea name="intro" class="form-control mb-3" rows="3"><?= htmlspecialchars($purpose['intro'] ?? '') ?></textarea>

        <label class="fw-bold mb-1">Outro Text</label>
        <textarea name="outro" class="form-control mb-3" rows="3"><?= htmlspecialchars($purpose['outro'] ?? '') ?></textarea>

        <button class="btn btn-success">Save Purpose</button>
      </form>

      <hr class="my-4">

      <div class="section-title">✔ Purpose Bullets</div>

      <!-- Add bullet -->
      <form action="save_membership.php" method="POST" class="row g-2 mb-3">
        <input type="hidden" name="action" value="add_bullet">
        <div class="col-md-8">
          <input type="text" name="bullet_text" class="form-control" placeholder="Bullet text..." required>
        </div>
        <div class="col-md-2">
          <input type="number" name="position" class="form-control" placeholder="Pos" value="0">
        </div>
        <div class="col-md-2">
          <button class="btn btn-primary w-100">Add</button>
        </div>
      </form>

      <!-- List bullets -->
      <?php foreach($bullets as $b): ?>
        <div class="border rounded p-3 mb-2 bg-white">
          <form action="save_membership.php" method="POST" class="row g-2 align-items-center">
            <input type="hidden" name="action" value="update_bullet">
            <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">

            <div class="col-md-8">
              <input type="text" name="bullet_text" class="form-control" value="<?= htmlspecialchars($b['bullet_text']) ?>" required>
            </div>
            <div class="col-md-2">
              <input type="number" name="position" class="form-control" value="<?= (int)$b['position'] ?>">
            </div>
            <div class="col-md-2 d-flex gap-2">
              <button class="btn btn-success w-50">Update</button>

              <button formaction="save_membership.php"
                      name="action" value="delete_bullet"
                      class="btn btn-danger w-50"
                      onclick="return confirm('Delete this bullet?');">
                Delete
              </button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>
    </div>

    <!-- ✅ MEMBERSHIP CARDS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🟩 Membership Cards</div>

      <!-- Add card -->
      <form action="save_membership.php" method="POST" class="border rounded p-3 bg-white mb-4">
        <input type="hidden" name="action" value="add_card">

        <div class="row g-2">
          <div class="col-md-4">
            <label class="fw-bold">Title</label>
            <input type="text" name="title" class="form-control" required>
          </div>
          <div class="col-md-4">
            <label class="fw-bold">Button Text</label>
            <input type="text" name="button_text" class="form-control" value="Join Now" required>
          </div>
          <div class="col-md-4">
            <label class="fw-bold">Button Link</label>
            <input type="text" name="button_link" class="form-control" placeholder="membermonthly.php" required>
          </div>

          <div class="col-md-8">
            <label class="fw-bold">Description</label>
            <textarea name="description" class="form-control" rows="2"></textarea>
          </div>

          <div class="col-md-2">
            <label class="fw-bold">Position</label>
            <input type="number" name="position" class="form-control" value="0">
          </div>

          <div class="col-md-2">
            <label class="fw-bold">Active</label>
            <select name="is_active" class="form-select">
              <option value="1">Yes</option>
              <option value="0">No</option>
            </select>
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-primary"><i class="bi bi-plus-circle"></i> Add Card</button>
          </div>
        </div>
      </form>

      <!-- Existing cards -->
      <?php foreach($cards as $c): ?>
        <div class="border rounded p-3 bg-white mb-3">
          <form action="save_membership.php" method="POST">
            <input type="hidden" name="action" value="update_card">
            <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">

            <div class="row g-2">
              <div class="col-md-4">
                <label class="fw-bold">Title</label>
                <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($c['title']) ?>" required>
              </div>
              <div class="col-md-4">
                <label class="fw-bold">Button Text</label>
                <input type="text" name="button_text" class="form-control" value="<?= htmlspecialchars($c['button_text']) ?>" required>
              </div>
              <div class="col-md-4">
                <label class="fw-bold">Button Link</label>
                <input type="text" name="button_link" class="form-control" value="<?= htmlspecialchars($c['button_link']) ?>" required>
              </div>

              <div class="col-md-8">
                <label class="fw-bold">Description</label>
                <textarea name="description" class="form-control" rows="2"><?= htmlspecialchars($c['description'] ?? '') ?></textarea>
              </div>

              <div class="col-md-2">
                <label class="fw-bold">Position</label>
                <input type="number" name="position" class="form-control" value="<?= (int)$c['position'] ?>">
              </div>

              <div class="col-md-2">
                <label class="fw-bold">Active</label>
                <select name="is_active" class="form-select">
                  <option value="1" <?= ((int)$c['is_active']===1?'selected':'') ?>>Yes</option>
                  <option value="0" <?= ((int)$c['is_active']===0?'selected':'') ?>>No</option>
                </select>
              </div>
            </div>

            <div class="d-flex gap-2 mt-3">
              <button class="btn btn-success btn-sm">Update</button>

              <button formaction="save_membership.php"
                      name="action" value="delete_card"
                      class="btn btn-danger btn-sm"
                      onclick="return confirm('Delete this card?');">
                Delete
              </button>
            </div>
          </form>
        </div>
      <?php endforeach; ?>

    </div>

  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
