<?php
ob_start();
require_once "db.php";
session_start();

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') { header("Location: index.php"); exit; }

$settings = $pdo->query("SELECT * FROM membership_benefits_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$sections = $pdo->query("SELECT * FROM membership_benefits_sections ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$bullets  = $pdo->query("SELECT * FROM membership_benefits_bullets ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$cards    = $pdo->query("SELECT * FROM membership_benefit_cards ORDER BY position ASC, id DESC")->fetchAll(PDO::FETCH_ASSOC);

// group bullets by section_key
$bulByKey = [];
foreach($bullets as $b){ $bulByKey[$b['section_key']][] = $b; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Membership Benefits | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }

/* ✅ layout */
.admin-wrapper { display:flex; min-height:100vh; }

/* ✅ MISSING SIDEBAR CSS (this is what you had in your other admin pages) */
.admin-sidebar { width:250px; background:#212529; color:#fff; flex-shrink:0; }
.admin-sidebar a{
  color:#ccc; padding:12px 20px; display:block;
  text-decoration:none; border-bottom:1px solid #2f343a;
}
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }

.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }

small.muted { color:#6c757d; }

/* ✅ Mobile: sidebar goes full width */
@media (max-width: 992px){
  .admin-wrapper{ flex-direction:column; }
  .admin-sidebar{ width:100%; }
  .admin-content{ padding:15px; }
}
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Membership Benefits</h3>

    <?php if(isset($_GET['saved'])): ?><div class="alert alert-success">✅ Saved successfully!</div><?php endif; ?>
    <?php if(isset($_GET['deleted'])): ?><div class="alert alert-warning">🗑️ Deleted successfully!</div><?php endif; ?>
    <?php if(isset($_GET['err'])): ?><div class="alert alert-danger">❌ Something went wrong!</div><?php endif; ?>
    <?php if(isset($_GET['msg'])): ?><div class="alert alert-danger">❌ <?= htmlspecialchars($_GET['msg']) ?></div><?php endif; ?>

    <!-- ✅ HEADER SETTINGS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🖼️ Page Header</div>

      <form action="save_membership_benefits.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="update_header">

        <label class="fw-bold mb-1">Page Title</label>
        <input type="text" class="form-control mb-3" name="page_title" value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>" required>

        <label class="fw-bold mb-1">Page Subtitle</label>
        <textarea class="form-control mb-3" name="page_subtitle" required><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></textarea>

        <label class="fw-bold mb-1">Background Image</label>
        <input type="file" class="form-control mb-3" name="bg_image">

        <?php if(!empty($settings['bg_image'])): ?>
          <img src="../<?= htmlspecialchars($settings['bg_image']) ?>"
               class="rounded"
               style="max-width:260px; object-fit:cover;">
        <?php endif; ?>

        <button class="btn btn-primary mt-2">Save Header</button>
      </form>
    </div>

    <!-- ✅ SECTIONS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🧩 Sections</div>

      <?php foreach($sections as $s): ?>
        <div class="border rounded p-3 bg-white mb-3">
          <form action="save_membership_benefits.php" method="POST">
            <input type="hidden" name="action" value="update_section">
            <input type="hidden" name="id" value="<?= (int)$s['id'] ?>">

            <div class="row g-2">
              <div class="col-md-4">
                <label class="fw-bold">Title</label>
                <input type="text" class="form-control" name="title" value="<?= htmlspecialchars($s['title']) ?>" required>
                <small class="muted">Section Key: <b><?= htmlspecialchars($s['section_key']) ?></b></small>
              </div>

              <div class="col-md-5">
                <label class="fw-bold">Content</label>
                <textarea class="form-control" rows="2" name="content"><?= htmlspecialchars($s['content'] ?? '') ?></textarea>
              </div>

              <div class="col-md-1">
                <label class="fw-bold">Pos</label>
                <input type="number" class="form-control" name="position" value="<?= (int)$s['position'] ?>">
              </div>

              <div class="col-md-2">
                <label class="fw-bold">Active</label>
                <select class="form-select" name="is_active">
                  <option value="1" <?= ((int)$s['is_active']===1?'selected':'') ?>>Yes</option>
                  <option value="0" <?= ((int)$s['is_active']===0?'selected':'') ?>>No</option>
                </select>
              </div>
            </div>

            <button class="btn btn-success btn-sm mt-2">Update Section</button>
          </form>

          <!-- ✅ bullets for this section -->
          <div class="mt-3">
            <div class="fw-bold mb-2">Bullets (<?= htmlspecialchars($s['section_key']) ?>)</div>

            <!-- add bullet -->
            <form action="save_membership_benefits.php" method="POST" class="row g-2 mb-2">
              <input type="hidden" name="action" value="add_bullet">
              <input type="hidden" name="section_key" value="<?= htmlspecialchars($s['section_key']) ?>">

              <div class="col-md-8">
                <input type="text" class="form-control" name="bullet_text" placeholder="Bullet text..." required>
              </div>
              <div class="col-md-2">
                <input type="number" class="form-control" name="position" value="0">
              </div>
              <div class="col-md-2">
                <button class="btn btn-primary w-100">Add</button>
              </div>
            </form>

            <?php if(!empty($bulByKey[$s['section_key']])): ?>
              <?php foreach($bulByKey[$s['section_key']] as $b): ?>
                <div class="border rounded p-2 mb-2 bg-light">
                  <form action="save_membership_benefits.php" method="POST" class="row g-2 align-items-center">
                    <input type="hidden" name="action" value="update_bullet">
                    <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">

                    <div class="col-md-8">
                      <input type="text" class="form-control" name="bullet_text" value="<?= htmlspecialchars($b['bullet_text']) ?>" required>
                    </div>
                    <div class="col-md-2">
                      <input type="number" class="form-control" name="position" value="<?= (int)$b['position'] ?>">
                    </div>

                    <div class="col-md-2 d-flex gap-2">
                      <button class="btn btn-success w-50">Update</button>

                      <button type="submit"
                              name="action" value="delete_bullet"
                              class="btn btn-danger w-50"
                              onclick="return confirm('Delete bullet?');">
                        Delete
                      </button>
                    </div>
                  </form>
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <div class="text-muted small">No bullets for this section.</div>
            <?php endif; ?>
          </div>

        </div>
      <?php endforeach; ?>
    </div>

    <!-- ✅ BENEFIT CARDS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">🟩 Discount Cards</div>

      <!-- Add card -->
      <form action="save_membership_benefits.php" method="POST" class="border rounded p-3 bg-white mb-4">
        <input type="hidden" name="action" value="add_card">

        <div class="row g-2">
          <div class="col-md-3">
            <label class="fw-bold">Business</label>
            <input name="business_name" class="form-control" required>
          </div>
          <div class="col-md-2">
            <label class="fw-bold">Category</label>
            <input name="category" class="form-control">
          </div>
          <div class="col-md-2">
            <label class="fw-bold">Discount</label>
            <input name="discount" class="form-control">
          </div>
          <div class="col-md-3">
            <label class="fw-bold">Offer</label>
            <input name="offer" class="form-control">
          </div>
          <div class="col-md-2">
            <label class="fw-bold">Location</label>
            <input name="location" class="form-control">
          </div>

          <div class="col-md-3">
            <label class="fw-bold">Contact</label>
            <input name="contact" class="form-control">
          </div>
          <div class="col-md-2">
            <label class="fw-bold">Position</label>
            <input name="position" class="form-control" type="number" value="0">
          </div>
          <div class="col-md-2">
            <label class="fw-bold">Active</label>
            <select class="form-select" name="is_active">
              <option value="1">Yes</option>
              <option value="0">No</option>
            </select>
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-primary"><i class="bi bi-plus-circle"></i> Add Card</button>
          </div>
        </div>
      </form>

      <!-- Existing cards -->
      <?php if(empty($cards)): ?>
        <div class="text-muted">No cards yet.</div>
      <?php endif; ?>

      <?php foreach($cards as $c): ?>
        <div class="border rounded p-3 bg-white mb-3">
          <form action="save_membership_benefits.php" method="POST">
            <input type="hidden" name="action" value="update_card">
            <input type="hidden" name="id" value="<?= (int)$c['id'] ?>">

            <div class="row g-2">
              <div class="col-md-3">
                <label class="fw-bold">Business</label>
                <input name="business_name" class="form-control" value="<?= htmlspecialchars($c['business_name']) ?>" required>
              </div>
              <div class="col-md-2">
                <label class="fw-bold">Category</label>
                <input name="category" class="form-control" value="<?= htmlspecialchars($c['category'] ?? '') ?>">
              </div>
              <div class="col-md-2">
                <label class="fw-bold">Discount</label>
                <input name="discount" class="form-control" value="<?= htmlspecialchars($c['discount'] ?? '') ?>">
              </div>
              <div class="col-md-3">
                <label class="fw-bold">Offer</label>
                <input name="offer" class="form-control" value="<?= htmlspecialchars($c['offer'] ?? '') ?>">
              </div>
              <div class="col-md-2">
                <label class="fw-bold">Location</label>
                <input name="location" class="form-control" value="<?= htmlspecialchars($c['location'] ?? '') ?>">
              </div>

              <div class="col-md-3">
                <label class="fw-bold">Contact</label>
                <input name="contact" class="form-control" value="<?= htmlspecialchars($c['contact'] ?? '') ?>">
              </div>
              <div class="col-md-2">
                <label class="fw-bold">Position</label>
                <input name="position" class="form-control" type="number" value="<?= (int)$c['position'] ?>">
              </div>
              <div class="col-md-2">
                <label class="fw-bold">Active</label>
                <select class="form-select" name="is_active">
                  <option value="1" <?= ((int)$c['is_active']===1?'selected':'') ?>>Yes</option>
                  <option value="0" <?= ((int)$c['is_active']===0?'selected':'') ?>>No</option>
                </select>
              </div>
            </div>

            <div class="d-flex gap-2 mt-3">
              <button class="btn btn-success btn-sm">Update</button>

              <button type="submit"
                      name="action" value="delete_card"
                      class="btn btn-danger btn-sm"
                      onclick="return confirm('Delete this card?');">
                Delete
              </button>
            </div>

          </form>
        </div>
      <?php endforeach; ?>

    </div>

  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
