<?php
ob_start();
require_once "db.php";
session_start();

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }
if (!isset($_SESSION['role']) || strtolower($_SESSION['role']) !== 'admin') { header("Location: index.php"); exit; }

$settings = $pdo->query("SELECT * FROM membership_monthly_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$bullets  = $pdo->query("SELECT * FROM membership_monthly_bullets ORDER BY position ASC, id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Monthly Membership | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
  body { background:#f5f6fa; }

  .admin-wrapper { display:flex; min-height:100vh; }

  /* ✅ MISSING CSS (SIDEBAR) — same as your other admin pages */
  .admin-sidebar { width:250px; background:#212529; color:#fff; flex-shrink:0; }
  .admin-sidebar a{
    color:#ccc; padding:12px 20px; display:block;
    text-decoration:none; border-bottom:1px solid #2f343a;
  }
  .admin-sidebar a:hover,
  .admin-sidebar a.active{
    background:#0d6efd; color:#fff;
  }

  .admin-content { flex-grow:1; padding:30px; }

  .section-card { border-radius:12px; }
  .section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }

  /* little polish */
  .card { border:0; }
  label { font-size: 14px; }
  textarea { resize: vertical; }

  /* responsive */
  @media (max-width: 992px){
    .admin-wrapper { flex-direction: column; }
    .admin-sidebar { width:100%; }
    .admin-content { padding:20px; }
  }
</style>
</head>

<body>

<div class="admin-wrapper">

  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">Manage Monthly Membership Page</h3>

    <?php if(isset($_GET['saved'])): ?><div class="alert alert-success">✅ Saved successfully!</div><?php endif; ?>
    <?php if(isset($_GET['deleted'])): ?><div class="alert alert-warning">🗑️ Deleted successfully!</div><?php endif; ?>
    <?php if(isset($_GET['err'])): ?><div class="alert alert-danger">❌ Something went wrong!</div><?php endif; ?>

    <!-- ✅ SETTINGS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">⚙️ Page Settings</div>

      <form action="save_monthly_membership.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="update_settings">

        <div class="row g-2">
          <div class="col-md-6">
            <label class="fw-bold">Page Title</label>
            <input type="text" class="form-control" name="page_title"
                   value="<?= htmlspecialchars($settings['page_title'] ?? '') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Currency</label>
            <input type="text" class="form-control" name="currency"
                   value="<?= htmlspecialchars($settings['currency'] ?? 'CAD') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Page Subtitle</label>
            <textarea class="form-control" name="page_subtitle" rows="2"><?= htmlspecialchars($settings['page_subtitle'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Fee Amount (display only)</label>
            <input type="number" step="0.01" class="form-control" name="fee_amount"
                   value="<?= htmlspecialchars($settings['fee_amount'] ?? '10.00') ?>">
          </div>

          <div class="col-md-6">
            <label class="fw-bold">PayPal Client ID</label>
            <input type="text" class="form-control" name="paypal_client_id"
                   value="<?= htmlspecialchars($settings['paypal_client_id'] ?? '') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">PayPal Plan ID</label>
            <input type="text" class="form-control" name="paypal_plan_id"
                   value="<?= htmlspecialchars($settings['paypal_plan_id'] ?? '') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Background Image</label>
            <input type="file" class="form-control" name="bg_image">
            <?php if(!empty($settings['bg_image'])): ?>
              <img src="../<?= htmlspecialchars($settings['bg_image']) ?>"
                   class="rounded mt-2" style="max-width:240px;object-fit:cover;">
            <?php endif; ?>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Success Message</label>
            <input type="text" class="form-control" name="success_message"
                   value="<?= htmlspecialchars($settings['success_message'] ?? '') ?>">
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Intro Title</label>
            <input type="text" class="form-control" name="intro_title"
                   value="<?= htmlspecialchars($settings['intro_title'] ?? '') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Form Title</label>
            <input type="text" class="form-control" name="form_title"
                   value="<?= htmlspecialchars($settings['form_title'] ?? '') ?>" required>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Intro Text</label>
            <textarea class="form-control" name="intro_text" rows="3"><?= htmlspecialchars($settings['intro_text'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Form Subtitle</label>
            <textarea class="form-control" name="form_subtitle" rows="3"><?= htmlspecialchars($settings['form_subtitle'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Note Text</label>
            <textarea class="form-control" name="note_text" rows="3"><?= htmlspecialchars($settings['note_text'] ?? '') ?></textarea>
          </div>

          <div class="col-md-6">
            <label class="fw-bold">Organization Block</label>
            <textarea class="form-control" name="org_block" rows="3"><?= htmlspecialchars($settings['org_block'] ?? '') ?></textarea>
          </div>

          <div class="col-12">
            <label class="fw-bold">Declaration Text</label>
            <textarea class="form-control" name="declaration_text" rows="3"><?= htmlspecialchars($settings['declaration_text'] ?? '') ?></textarea>
          </div>

          <div class="col-12 mt-2">
            <button class="btn btn-primary"><i class="bi bi-save"></i> Save Settings</button>
          </div>
        </div>
      </form>
    </div>

    <!-- ✅ BULLETS -->
    <div class="card p-4 shadow-sm mb-4 section-card">
      <div class="section-title">✔ Benefits Bullets</div>

      <form action="save_monthly_membership.php" method="POST" class="row g-2 mb-3">
        <input type="hidden" name="action" value="add_bullet">
        <div class="col-md-8">
          <input type="text" name="bullet_text" class="form-control" placeholder="Bullet text..." required>
        </div>
        <div class="col-md-2">
          <input type="number" name="position" class="form-control" value="0">
        </div>
        <div class="col-md-2">
          <button class="btn btn-success w-100"><i class="bi bi-plus-circle"></i> Add</button>
        </div>
      </form>

      <?php foreach($bullets as $b): ?>
        <div class="border rounded p-3 bg-white mb-2">
          <form action="save_monthly_membership.php" method="POST" class="row g-2 align-items-center">
            <input type="hidden" name="action" value="update_bullet">
            <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">

            <div class="col-md-7">
              <input type="text" class="form-control" name="bullet_text"
                     value="<?= htmlspecialchars($b['bullet_text']) ?>" required>
            </div>

            <div class="col-md-2">
              <input type="number" class="form-control" name="position"
                     value="<?= (int)$b['position'] ?>">
            </div>

            <div class="col-md-1">
              <select class="form-select" name="is_active">
                <option value="1" <?= ((int)$b['is_active']===1?'selected':'') ?>>Yes</option>
                <option value="0" <?= ((int)$b['is_active']===0?'selected':'') ?>>No</option>
              </select>
            </div>

            <div class="col-md-2 d-flex gap-2">
              <button class="btn btn-primary w-50">Update</button>

              <button formaction="save_monthly_membership.php"
                      name="action" value="delete_bullet"
                      class="btn btn-danger w-50"
                      onclick="return confirm('Delete this bullet?');">
                Delete
              </button>

              <input type="hidden" name="id" value="<?= (int)$b['id'] ?>">
            </div>
          </form>
        </div>
      <?php endforeach; ?>

    </div>

  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
